; notesantispam-ja.nsi
;
; This script builds the installer for NotesAntiSpam
;
;
;***************************************************************************************
; RemoveStr
;***************************************************************************************
; input, top of stack = string to search for
; top of stack-1 = string to search in
; output, top of stack (replaces with the portion of the string remaining)
; modifies no other variables.
;
; Usage:
; Push "this is a long ass string"
; Push "ass"
; Call StrStr
; Pop $0
; ($0 at this point is "this is a long string")

Function un.RemoveStr
Exch $1 ; st=haystack,old$1, $1=needle
Exch ; st=old$1,haystack
Exch $2 ; st=old$1,old$2, $2=haystack
Push $3
Push $4
Push $5
StrLen $3 $1
StrCpy $4 0
; $1=needle
; $2=haystack
; $3=len(needle)
; $4=cnt
; $5=tmp
; $6= output string with search string removed
; $7= tmp output character
loop:
StrCpy $5 $2 $3 $4
StrCmp $5 $1 skip
StrCmp $5 "" done

;-- Copy current character into output if no match was detected and increment counter
StrCpy $7 $2 1 $4
StrCpy $6 "$6$7"
IntOp $4 $4 + 1
Goto loop

;-- Inrement by length of hayneedle
skip:
IntOp $4 $4 + $3
Goto loop

done:
StrCpy $1 $2 "" $4
Pop $5
Pop $4
Pop $3
Pop $2
Exch $6
FunctionEnd

;***************************************************************************************
; Macro - Upgrade DLL File
; Written by Joost Verburg
; ------------------------
;
; Example of usage:
; !insertmacro UpgradeDLL "dllname.dll" "$SYSDIR\dllname.dll"
;
; !define UPGRADEDLL_NOREGISTER if you want to upgrade a DLL which cannot
; be registered
;
; Note that this macro sets overwrite to TRY. Change it back to whatever 
; you want after you insert the macro.

!macro UpgradeDLL LOCALFILE DESTFILE

  Push $R0
  Push $R1
  Push $R2
  Push $R3

  ;------------------------
  ;Check file and version

  IfFileExists "${DESTFILE}" "" "copy_${LOCALFILE}"

  ClearErrors
    GetDLLVersionLocal "${LOCALFILE}" $R0 $R1
    GetDLLVersion "${DESTFILE}" $R2 $R3
  IfErrors "upgrade_${LOCALFILE}"

  IntCmpU $R0 $R2 "" "done_${LOCALFILE}" "upgrade_${LOCALFILE}"
  IntCmpU $R1 $R3 "done_${LOCALFILE}" "done_${LOCALFILE}" "upgrade_${LOCALFILE}"

  ;------------------------
  ;Let's upgrade the DLL!

  SetOverwrite try

  "upgrade_${LOCALFILE}:"
;    !ifndef UPGRADEDLL_NOREGISTER
;      ;Unregister the DLL
;      UnRegDLL "${DESTFILE}"
;    !endif

  ;------------------------
  ;Try to copy the DLL directly

  ClearErrors
    StrCpy $R0 "${DESTFILE}"
    Call ":file_${LOCALFILE}"
  IfErrors "" "noreboot_${LOCALFILE}"

  ;------------------------
  ;DLL is in use. Copy it to a temp file and Rename it on reboot.

  GetTempFileName $R0
    Call ":file_${LOCALFILE}"
  Rename /REBOOTOK $R0 "${DESTFILE}"

  ;------------------------
  ;Register the DLL on reboot

;  !ifndef UPGRADEDLL_NOREGISTER
;    WriteRegStr HKLM "Software\Microsoft\Windows\CurrentVersion\RunOnce" "Register ${DESTFILE}" '"$SYSDIR\rundll32.exe" "${DESTFILE},DllRegisterServer"'
;  !endif

  Goto "done_${LOCALFILE}"

  ;------------------------
  ;DLL does not exist - just extract

  "copy_${LOCALFILE}:"
    StrCpy $R0 "${DESTFILE}"
    Call ":file_${LOCALFILE}"

  ;------------------------
  ;Register the DLL

  "noreboot_${LOCALFILE}:"
;    !ifndef UPGRADEDLL_NOREGISTER
;      RegDLL "${DESTFILE}"
;    !endif

  ;------------------------
  ;Done

  "done_${LOCALFILE}:"

  Pop $R3
  Pop $R2
  Pop $R1
  Pop $R0

  ;------------------------
  ;End

  Goto "end_${LOCALFILE}"

  ;------------------------
  ;Called to extract the DLL

  "file_${LOCALFILE}:"
    File /oname=$R0 "${LOCALFILE}"
    Return

  "end_${LOCALFILE}:"

!macroend

;***************************************************************************************
; Global Settings
;***************************************************************************************
; define version
!define VERSION "0.3.1-ja"

; The name of the installer
Name "NotesAntiSpam"

; The file to write
OutFile "NotesAntiSpam-Setup-${VERSION}.exe"

; The default installation directory
InstallDir "C:\Lotus\Notes"
; Registry key to check for directory (so if you install again, it will 
; overwrite the old one automatically)
InstallDirRegKey HKLM SOFTWARE\NotesAntiSpam "Install_Dir"

; Don't show Dir-Selection if directory exists
;DirShow hide

; The text to prompt the user to enter a directory
ComponentText "This will install NotesAntiSpam on your System. Select which optional things you want installed."
; The text to prompt the user to enter a directory
DirText "Choose a directory to install in to (Must be the Directory of Lotus-Notes):"

Function .onInit
	; read default install-dir from environment
	ReadRegStr $INSTDIR HKLM SOFTWARE\Lotus\Notes "Path"
	; Check if Install-Dir already exists
	IfFileExists "$INSTDIR\nlnotes.exe" PathGood
		StrCpy $INSTDIR "C:\Lotus\Notes"
		MessageBox MB_OKCANCEL|MB_ICONSTOP "Lotus-Notes not installed. Continue on your own risk." IDOK PathGood
			Abort ; Exit if user don't want to take risk ...
	PathGood:
	; set $SMPROGRAMS to all-users
	SetShellVarContext all
FunctionEnd

Function un.onInit
	; read install-dir from registry
	ReadRegStr $INSTDIR HKLM SOFTWARE\NotesAntiSpam "Install_Dir"
	; set $SMPROGRAMS to all-users
	SetShellVarContext all
FunctionEnd

Function .onVerifyInstDir
	; Check if Install-Dir already exists
	IfFileExists "$INSTDIR\nlnotes.exe" PathGood
		Abort ; If instdir does not exist ask user for Directory
	PathGood:
FunctionEnd

Function .onInstSuccess
  ; Write the installation path into the registry
  WriteRegStr HKLM SOFTWARE\NotesAntiSpam "Install_Dir" "$INSTDIR"
  ; Write the installed Version to registry
  WriteRegStr HKLM SOFTWARE\NotesAntiSpam "InstalledVersion" "${VERSION}"
FunctionEnd

; needed section

Section "-Base-DLLs"
  ; Set output path to the installation directory.
  SetOutPath "$INSTDIR"
  ; Put file there
  File "C:\Lotus\Notes\notescpp\lib\mswin32\lcppn24.dll"
  File "..\external\gdbm-1.8.0\win32c\vc_release\gdbm.dll"
SectionEnd

Section "-NotesAntiSpam"
  ; Set output path to the installation directory.
  SetOutPath "$INSTDIR"
  ; Put file there
  File "..\Release\notesantispam.exe"
  File "..\NASExtPwd\Release\NASExtPwd.dll"
  ; ShortCuts
  CreateDirectory "$SMPROGRAMS\NotesAntiSpam"
  CreateShortCut "$SMPROGRAMS\NotesAntiSpam\NotesAntiSpam.lnk" "$INSTDIR\notesantispam.exe" "" "$INSTDIR\notesantispam.exe" 0
SectionEnd

Section "MFC 7.1 Runtime-DLLs"
  ; Set output path to the installation directory.
  SetOutPath "$SYSDIR"
  !define UPGRADEDLL_NOREGISTER
  !insertmacro UpgradeDLL "MFC71.DLL" "$SYSDIR\MFC71.DLL" 
  !insertmacro UpgradeDLL "MSVCR71.DLL" "$SYSDIR\MSVCR71.DLL" 
  !insertmacro UpgradeDLL "MSVCP71.DLL" "$SYSDIR\MSVCP71.DLL" 
  !undef UPGRADEDLL_NOREGISTER
SectionEnd

Section "Documentation"
  ; Set output path to the installation directory.
  SetOutPath "$INSTDIR\NotesAntiSpam"
  ; Put file there
  File "..\doc\License.txt"
  File "..\doc\ReadMe.txt"
  File "..\doc\TODO.txt"
  File "..\doc\Version.txt"
  File "..\doc\NotesAntiSpam-Manual.pdf"
  ; ShortCuts
  CreateDirectory "$SMPROGRAMS\NotesAntiSpam\doc"
  CreateShortCut "$SMPROGRAMS\NotesAntiSpam\doc\License.lnk" "$INSTDIR\NotesAntiSpam\License.txt"
  CreateShortCut "$SMPROGRAMS\NotesAntiSpam\doc\ReadMe.lnk" "$INSTDIR\NotesAntiSpam\ReadMe.txt"
  CreateShortCut "$SMPROGRAMS\NotesAntiSpam\doc\TODO.lnk" "$INSTDIR\NotesAntiSpam\TODO.txt"
  CreateShortCut "$SMPROGRAMS\NotesAntiSpam\doc\Version.lnk" "$INSTDIR\NotesAntiSpam\Version.txt"
  CreateShortCut "$SMPROGRAMS\NotesAntiSpam\doc\Manual.lnk" "$INSTDIR\NotesAntiSpam\NotesAntiSpam-Manual.pdf"
SectionEnd

Section "Startup Shortcut"
	CreateShortCut "$SMPROGRAMS\X^[gAbv\NotesAntiSpam.lnk" "$INSTDIR\NotesAntiSpam.exe" "" "$INSTDIR\NotesAntiSpam.exe" 0
SectionEnd

Section "Desktop Shortcut"
	CreateShortCut "$DESKTOP\NotesAntiSpam.lnk" "$INSTDIR\NotesAntiSpam.exe" "" "$INSTDIR\NotesAntiSpam.exe" 0
SectionEnd

Section "SSO between Lotus-Notes-Applications"
  IfFileExists $INSTDIR\notes.ini defaultIni defaultIniError
  defaultIni:
  ReadIniStr $R1 $INSTDIR\notes.ini Notes EXTMGR_ADDINS
  StrCmp $R1 "" emptystr
  WriteIniStr $INSTDIR\notes.ini Notes EXTMGR_ADDINS "$R1,NASExtPwd"
  goto endstr
  emptystr:
  WriteIniStr $INSTDIR\notes.ini Notes EXTMGR_ADDINS "NASExtPwd"
  goto endstr
  defaultIniError:
  MessageBox MB_ICONSTOP|MB_OK "Unable to activate SSO, please use Menu (Configuration->General->Store Notes-Password in Memory) after first start of NotesAntiSpam to activate!"
  endstr:
SectionEnd

; optional section
Section "Uninstaller"
  ; Write the uninstall keys for Windows
  WriteRegStr HKLM "Software\Microsoft\Windows\CurrentVersion\Uninstall\NotesAntiSpam" "DisplayName" "NotesAntiSpam (remove only)"
  WriteRegStr HKLM "Software\Microsoft\Windows\CurrentVersion\Uninstall\NotesAntiSpam" "UninstallString" '"$INSTDIR\uninstallNAS.exe"'
  WriteUninstaller "uninstallNAS.exe"
  CreateDirectory "$SMPROGRAMS\NotesAntiSpam"
  CreateShortCut "$SMPROGRAMS\NotesAntiSpam\Uninstall.lnk" "$INSTDIR\uninstallNAS.exe" "" "$INSTDIR\uninstallNAS.exe" 0
SectionEnd

; uninstall stuff

UninstallText "This will uninstall NotesAntiSpam."

; special uninstall section.
Section "Uninstall"
  SetShellVarContext all
  ; remove registry keys
  DeleteRegKey HKLM "Software\Microsoft\Windows\CurrentVersion\Uninstall\NotesAntiSpam"
  DeleteRegKey HKLM SOFTWARE\NotesAntiSpam
  ; disable sso-DLL
  ReadIniStr $R1 $INSTDIR\notes.ini Notes EXTMGR_ADDINS
  Push $R1
  Push ",NASExtPwd"
  Call un.RemoveStr
  Pop $R1
  Push $R1
  Push "NASExtPwd,"
  Call un.RemoveStr
  Pop $R1
  Push $R1
  Push "NASExtPwd"
  Call un.RemoveStr
  Pop $R1
  WriteIniStr $INSTDIR\notes.ini Notes EXTMGR_ADDINS $R1
  ; remove files
  ; NotesAntiSpam
  Delete /REBOOTOK "$INSTDIR\NotesAntiSpam.exe"
  ;shared files
  Delete /REBOOTOK "$INSTDIR\NASExtPwd.dll"
  Delete /REBOOTOK "$INSTDIR\gdbm.dll"
  ; ini-file
  Delete "$INSTDIR\NotesAntiSpam.ini"
  ; Documentation and support-files
  Delete "$INSTDIR\NotesAntiSpam\*.*"
  ; MUST REMOVE UNINSTALLER, too
  Delete "$INSTDIR\uninstallNAS.exe"
  ; remove shortcuts, if any.
  Delete "$SMPROGRAMS\NotesAntiSpam\doc\*.*"
  RMDir "$SMPROGRAMS\NotesAntiSpam\doc"
  Delete "$SMPROGRAMS\NotesAntiSpam\*.*"
  RMDir "$SMPROGRAMS\NotesAntiSpam"
  Delete "$SMPROGRAMS\X^[gAbv\NotesAntiSpam.lnk"
  Delete "$DESKTOP\NotesAntiSpam.lnk"
  ; remove directories used.
  RMDir "$INSTDIR\NotesAntiSpam"
SectionEnd

; eof
