using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using Microsoft.Win32;
using System.Text.RegularExpressions;
using System.Diagnostics;
using System.IO;
using System.Collections;
using System.Reflection;

namespace NgenExecWin
{
    public partial class MainWindow : Form
    {
        public MainWindow()
        {
            InitializeComponent();
        }

        /// <summary>
        /// œKJnĂ邩ǂ
        /// </summary>
        bool isstarted = false;
        /// <summary>
        /// .NET Framework̃o[W
        /// </summary>
        string version;

        /// <summary>
        /// NGEN.EXEɓnݒt@C擾܂B
        /// </summary>
        /// <returns></returns>
        private string[] GetArgmentArray()
        {
            ArrayList argmentstemp = new ArrayList();
            string inipath = Path.GetDirectoryName(Assembly.GetExecutingAssembly().Location) + "\\ngenexec.ini";
            Environment.CurrentDirectory = Path.GetDirectoryName(Assembly.GetExecutingAssembly().Location);
            rtbox_Result.AppendText("XNvg"+inipath+"ǂݍݒ...\n");
            StreamReader scrreader = new StreamReader(inipath);
            while (!scrreader.EndOfStream)
            {
                argmentstemp.Add(scrreader.ReadLine());
            }
            scrreader.Close();
            return (string[])argmentstemp.ToArray(typeof(string));
        }

        /// <summary>
        /// Ngens܂B
        /// </summary>
        private void RunNgen()
        {
            RegistryKey tempkey = Registry.LocalMachine;
            RegistryKey dotnetkey = tempkey.OpenSubKey(@"SOFTWARE\Microsoft\.NETFramework");
            string dotnetpath = (string)dotnetkey.GetValue("InstallRoot");
            string ngenpath = dotnetpath + version + @"\ngen.exe";

            string[] argmentarray = GetArgmentArray();
            
            foreach (string argment in argmentarray)
            {
                Process ngenprocess = new Process();
                ngenprocess.StartInfo = new ProcessStartInfo(ngenpath,argment);
                ngenprocess.StartInfo.UseShellExecute = false;
                //ngenprocess.StartInfo.UseShellExecute = true;
                ngenprocess.StartInfo.RedirectStandardOutput = true;
                ngenprocess.StartInfo.RedirectStandardError = true;
                ngenprocess.StartInfo.RedirectStandardInput = true;
                ngenprocess.StartInfo.CreateNoWindow = true;
                ngenprocess.Start();
                //StreamReader ngenout = ngenprocess.StandardOutput;
                //StreamReader ngenerr = ngenprocess.StandardError;
                //StreamWriter ngenin = ngenprocess.StandardInput;
                ngenprocess.OutputDataReceived += new DataReceivedEventHandler(ngenprocess_OutputDataReceived);
                ngenprocess.ErrorDataReceived += new DataReceivedEventHandler(ngenprocess_ErrorDataReceived);
                ngenprocess.BeginOutputReadLine();
                ngenprocess.BeginErrorReadLine();
                ngenprocess.WaitForExit();
            }
        }

        void ngenprocess_ErrorDataReceived(object sender, DataReceivedEventArgs e)
        {
            rtbox_Result.AppendText(e.Data + "\n");
        }

        void ngenprocess_OutputDataReceived(object sender, DataReceivedEventArgs e)
        {
            rtbox_Result.AppendText(e.Data + "\n");
        }

        private string GetDotNetVersion()
        {
            //.NET Framework ̃o[W擾
            RegistryKey tempkey = Registry.LocalMachine;
            RegistryKey dotnetkey = tempkey.OpenSubKey(@"SOFTWARE\Microsoft\.NETFramework");
            string[] subkeys = dotnetkey.GetSubKeyNames();
            Regex isdotnetversion = new Regex(@"^v\d+\.\d+\.\d+$");
            foreach (string subkey in subkeys)
                if (isdotnetversion.IsMatch(subkey))
                    return(subkey);
            return "";
        }

        void Start()
        {
            try
            {
                if (isstarted == false)
                {
                    btn_Close.Text = "";
                    btn_Close.Enabled = false;
                    label_status.Text = "œKsĂ܂";
                    label_status.Refresh();
                    isstarted = true;
                    version = GetDotNetVersion();
                    backgroundWorker.DoWork += new DoWorkEventHandler(backgroundWorker_DoWork);
                    backgroundWorker.RunWorkerCompleted += new RunWorkerCompletedEventHandler(backgroundWorker_RunWorkerCompleted);
                    backgroundWorker.RunWorkerAsync();
                }
                else
                {
                    Application.Exit();
                }
            }
            catch (Exception ex)
            {
                rtbox_Result.AppendText("vIȃG[ߎsI܂B\n\tǗҌŎsĂ邩mFĂB\n\tXNvgǂݍ߂ȂesłB\nڍׂȏF\n"
                    + ex.Message + "\nO̔ӏF\n" + ex.Source + "\nX^bNg[XF\n" + ex.StackTrace);
                if (ex.InnerException != null)
                    rtbox_Result.AppendText("\nȌڍ׏F\n" + ex.InnerException.Message);
            }
        }

        void backgroundWorker_RunWorkerCompleted(object sender, RunWorkerCompletedEventArgs e)
        {
            foreach (string arg in Environment.GetCommandLineArgs())
            {
                if (arg == "/a")
                    Application.Exit();
            }
            label_status.Text = "œK܂";
            btn_Close.Enabled = true;
        }

        void backgroundWorker_DoWork(object sender, DoWorkEventArgs e)
        {
            RunNgen();
        }

        private void btn_Close_Click(object sender, EventArgs e)
        {
            Start();
        }

        private void Form1_Load(object sender, EventArgs e)
        {
            foreach (string arg in Environment.GetCommandLineArgs())
            {
                if (arg == "/a")
                {
                    Start();
                }
            }
        }
    }
}