//---------------------------------------------------------------------
// PS/2 interface for EDU2(ATmega64)
// by Takuya Matsubara / NICO Corp.2008
// http://www.nicotak.com/
//
// Keyboard
// (Japanese Keyboard)

// (Original Program)
// Atmel Application Note
// AVR313: Interfacing the PC AT Keyboard


#include <avr/io.h>
#include <avr/interrupt.h>
#include <avr/pgmspace.h>
#include "keyboard.h"
#include "nicobasic.h"

/*
#include "textx.h"	//debug
*/

#define USEMOUSE 0

void kb_decode(void);

char bitcount=11;
char kb_buffcnt=0;
unsigned char kb_buffer=0;
unsigned char tempdata;// Holds the received scan code

#define FLAG_SHIFT (1<<0)
#define FLAG_ISUP  (1<<1)
#define FLAG_EZERO (1<<2)

char kb_flag;


//char is_up=0, shift = 0;
//char e0flag=0;


//*********************
// Pin definition file
//*********************
// Keyboard connections

#if HARDTYPE==HARD_EDUMK2

	#define PS2_DATAPIN  PINE
	#define PS2_DATAPORT PORTE
	#define PS2_DATADDR  DDRE
	#define PS2_DATABIT  (1<<7)

	#define PS2_CLKPIN   PINE
	#define PS2_CLKPORT  PORTE
	#define PS2_CLKDDR   DDRE
	#define PS2_CLKBIT   (1<<6)

	#define PS2CLK_SIG		SIG_INTERRUPT6

	#define PS2INTR_SETMASK EICRB |= (1<<ISC61); //falling edge
//	EICRB &=~(1<<ISC60);
	#define PS2INTR_ENABLE	EIMSK|=(1<<INT6)	// 荞݋
	#define PS2INTR_DISABLE	EIMSK&=~(1<<INT6)	// 荞݋֎~
	//INT6̗ɂ銄荞
#endif

#if HARDTYPE==HARD_EDUMK1
//EDU
	#define PS2_PINDATA PIND
	#define PS2_PORTDATA PORTD
	#define PS2_DDRDATA DDRD
	#define PS2_BITDATA (1<<4)

	#define PS2_CLKPIN PIND
	#define PS2_CLKPORT PORTD
	#define PS2_DDRCLK DDRD
	#define PS2_BITCLK (1<<3)

	#define PS2INTR_SETMASK PCMSK2|=(1<<PCINT19)
	#define PS2INTR_ENABLE	PCICR|=(1<<PCIE2)
	#define PS2CLK_SIG		SIG_PIN_CHANGE2
#endif


#if HARDTYPE==HARD_LEDGAME
	#define PS2_DATAPIN PINC
	#define PS2_DATAPORT PORTC
	#define PS2_DATADDR DDRC
	#define PS2_DATABIT (1<<0)

	#define PS2_CLKPIN PINC
	#define PS2_CLKPORT PORTC
	#define PS2_CLKDDR DDRC
	#define PS2_CLKBIT (1<<1)

	#define PS2INTR_SETMASK PCMSK1|=(1<<PCINT9)
	#define PS2INTR_ENABLE	PCICR|=(1<<PCIE1)
	#define PS2CLK_SIG		SIG_PIN_CHANGE1
#endif


void mouse_sendbyte(unsigned char data);
unsigned char mouse_recvbyte(void);
void ps2_clkwait(void);


// (Japanese Keyboard)

// Unshifted characters
PROGMEM unsigned char keytable[] = {
     0           ,0    //0x00 
    ,0           ,0    //0x01 f9
    ,0           ,0    //0x02 
    ,0           ,0    //0x03 f5
    ,0           ,0    //0x04 f3
    ,0           ,0    //0x05 f1
    ,0           ,0    //0x06 f2
    ,0           ,0    //0x07 f12
    ,0           ,0    //0x08 f7
    ,0           ,0    //0x09 f10
    ,0           ,0    //0x0a f8
    ,0           ,0    //0x0b f6
    ,0           ,0    //0x0c f4
    ,KEYBOARD_TAB ,0   //0x0d tab 
    ,0           ,0    //0x0e zenkaku 
    ,0           ,0    //0x0f    
    ,0           ,0    //0x10    
    ,0           ,0    //0x11 alt 
    ,0           ,0    //0x12 shift 
    ,0           ,0    //0x13
    ,0           ,0    //0x14 ctrl
    ,'q'         ,'Q'  //0x15 q 
    ,'1'         ,'!'  //0x16 1 
    ,0           ,0    //0x17
    ,0           ,0    //0x18
    ,0           ,0    //0x19
    ,'z'         ,'Z'  //0x1a z 
    ,'s'         ,'S'  //0x1b s 
    ,'a'         ,'A'  //0x1c a 
    ,'w'         ,'W'  //0x1d w 
    ,'2'         ,'\"' //0x1e 2 
    ,0           ,0    //0x1f windows
    ,0           ,0    //0x20  
    ,'c'         ,'C'  //0x21 c 
    ,'x'         ,'X'  //0x22 x 
    ,'d'         ,'D'  //0x23 d 
    ,'e'         ,'E'  //0x24 e 
    ,'4'         ,'$'  //0x25 4 
    ,'3'         ,'#'  //0x26 3 
    ,0           ,0    //0x27
    ,0           ,0    //0x28
    ,' '         ,0    //0x29 space  
    ,'v'         ,'V'  //0x2a v 
    ,'f'         ,'F'  //0x2b f 
    ,'t'         ,'T'  //0x2c t 
    ,'r'         ,'R'  //0x2d r 
    ,'5'         ,'%'  //0x2e 5 
    ,0           ,0    //0x2f
    ,0           ,0    //0x30  
    ,'n'         ,'N'  //0x31 n 
    ,'b'         ,'B'  //0x32 b 
    ,'h'         ,'H'  //0x33 h 
    ,'g'         ,'G'  //0x34 g 
    ,'y'         ,'Y'  //0x35 y 
    ,'6'         ,'&'  //0x36 6 
    ,0           ,0    //0x37
    ,0           ,0    //0x38
    ,','         ,'<'  //0x39 ,    
    ,'m'         ,'M'  //0x3a m 
    ,'j'         ,'J'  //0x3b j 
    ,'u'         ,'U'  //0x3c u 
    ,'7'         ,'\'' //0x3d 7 
    ,'8'         ,'('  //0x3e 8 
    ,0           ,0    //0x3f
    ,0           ,0    //0x40
    ,','         ,'<'  //0x41 ,    
    ,'k'         ,'K'  //0x42 k 
    ,'i'         ,'I'  //0x43 i 
    ,'o'         ,'O'  //0x44 o 
    ,'0'         ,0    //0x45 zero 
    ,'9'         ,')'  //0x46 9 
    ,0           ,0    //0x47
    ,0           ,0    //0x48
    ,'.'         ,'>'  //0x49 . 
    ,'/'         ,'?'  //0x4a / 
    ,'l'         ,'L'  //0x4b L 
    ,';'         ,'+'  //0x4c ; 
    ,'p'         ,'P'  //0x4d p 
    ,'-'         ,'='  //0x4e - 
    ,0           ,0    //0x4f
    ,0           ,0    //0x50
    ,'\\'        ,'_'  //0x51 yen_
    ,':'         ,'*'  //0x52 : 
    ,0           ,0    //0x53   
    ,'@'         ,'`'  //0x54 @ 
    ,'^'         ,'~'  //0x55 ^ 
    ,0           ,0    //0x56
    ,0           ,0    //0x57
    ,0           ,0    //0x58 caps
    ,0           ,0    //0x59 shift 
    ,KEYBOARD_ENTER,0  //0x5a ENTER 
    ,'['          ,'{' //0x5b [
    ,0            ,0   //0x5c
    ,']'          ,'}' //0x5d ]  
    ,0            ,0   //0x5e
    ,0            ,0   //0x5f
    ,0            ,0   //0x60
    ,0            ,0   //0x61
    ,0            ,0   //0x62
    ,0            ,0   //0x63
    ,0            ,0   //0x64 henkan
    ,0            ,0   //0x65
    ,KEYBOARD_BS  ,0   //0x66 BS 
    ,0            ,0   //0x67 muhenkan
    ,0            ,0   //0x68
    ,'1'          ,0   //0x69 tenkey1 
    ,'\\'         ,'|' //0x6a yen| 
    ,'4'          ,0   //0x6b tenkey4 
    ,'7'          ,0   //0x6c tenkey7 
    ,0            ,0   //0x6d
    ,0            ,0   //0x6e
    ,0            ,0   //0x6f
    ,'0'          ,0   //0x70 0
    ,'.'          ,0   //0x71 .
    ,'2'          ,0   //0x72 2
    ,'5'          ,0   //0x73 5
    ,'6'          ,0   //0x74 6
    ,'8'          ,0   //0x75 8
    ,KEYBOARD_ESC ,0   //0x76 ESC
    ,0            ,0   //0x77 num
    ,0            ,0   //0x78 F11
    ,'+'          ,0   //0x79 +  
    ,'3'          ,0   //0x7a 3  
    ,'-'          ,0   //0x7b -  
    ,'*'          ,0   //0x7c *  
    ,'9'          ,0   //0x7d 9  
};


PROGMEM unsigned char keytable2[] = {
     KEYBOARD_LEFT // 0x6b LEFT
    ,0       // 0x6c home
    ,0       // 0x6d
    ,0       // 0x6e
    ,0       // 0x6f
    ,0       // 0x70 ins
    ,0       // 0x71 del
    ,KEYBOARD_DOWN // 0x72 DOWN
    ,0        // 0x73
    ,KEYBOARD_RIGHT // 0x74 RIGHT
    ,KEYBOARD_UP    // 0x75 UP
//   ,0    // 0x76
//   ,0    // 0x77
//   ,0    // 0x78
//   ,0    // 0x79
//   ,0    // 0x7a pagedown
//   ,0    // 0x7b
//   ,0    // 0x7c
//   ,0    // 0x7d pageup
};


void ps2_clk_high(void)
{
	PS2_CLKPORT |= PS2_CLKBIT;//pullup(n[hIɃvAbvĂȂsv)
	PS2_CLKDDR &= ~PS2_CLKBIT;
}

void ps2_clk_low(void)
{
	PS2_CLKPORT &= ~PS2_CLKBIT;
	PS2_CLKDDR |= PS2_CLKBIT;
}

void ps2_data_high(void)
{
	PS2_DATAPORT |= PS2_DATABIT;//pullup(n[hIɃvAbvĂȂsv)
	PS2_DATADDR &= ~PS2_DATABIT;
}

void ps2_data_low(void)
{
	PS2_DATAPORT &= ~PS2_DATABIT;
	PS2_DATADDR |= PS2_DATABIT;
}

//----------keyboard init(init_kb)
void kb_init(void)
{
	ps2_data_high();
	ps2_clk_high();

//	PS2_DATAPORT |=  PS2_DATABIT;	//Pullup
//	PS2_DATADDR  &= ~PS2_DATABIT;	//Direction INPUT

//	PS2_CLKPORT |=  PS2_CLKBIT;	//Pullup
//	PS2_CLKDDR  &= ~PS2_CLKBIT;		//Direction INPUT

	PS2INTR_SETMASK;
	PS2INTR_ENABLE;	// 荞݋

	#if USEMOUSE
	    mouse_sendbyte(0xFF);	// 
	    mouse_recvbyte();		// 0xFA 
	    mouse_recvbyte();		// 0xAA
	    mouse_recvbyte();		// 0x00

	    mouse_sendbyte(0xF4);	// 
	    mouse_recvbyte();		// 0xFA
	#endif
}

//----------keyboard Clock intrrupt
// clk荞
SIGNAL (PS2CLK_SIG)
{
// Routine entered at falling edge
	unsigned char datapin=0;

	if ((PS2_CLKPIN & PS2_CLKBIT)==0){
	 // Routine entered at falling edge
		if(PS2_DATAPIN & PS2_DATABIT)
			datapin = 0x80;

		if(bitcount==11){//startbit
			if(datapin){// DATA==HIGH error
				return;
			}
		}else if(bitcount == 2){//Parity bit
			//
		}else if(bitcount == 1){//stopbit
			bitcount = 11;
			if(datapin==0){//DATA==LOW error
				return;
			}
		#if USEMOUSE
			kb_buffer = tempdata;
			kb_buffcnt++;
		#else
			kb_decode();
		#endif
			return;
		}else{//data bit
			tempdata >>= 1;
			tempdata |= datapin;// Store a '1'
		}
		bitcount--;
	}
}

//----------keyboard decode(decode)
void kb_decode(void)
{
	if(tempdata==0xe0){
		kb_flag |= FLAG_EZERO;
		return;
	}
	if(tempdata==0xf0){// The up-key identifier
		kb_flag |= FLAG_ISUP;	//sw ON-->OFF
		return;
	}
	
	if((tempdata==0x12)||(tempdata==0x59)){ // Left SHIFT or Right SHIFT
		if(kb_flag & FLAG_ISUP)
			kb_flag &= ~FLAG_SHIFT;
		else
			kb_flag |= FLAG_SHIFT;//XCb`莞̂shift ON
	}else{
		if((kb_flag & FLAG_ISUP)==0){
			PGM_P p;
			unsigned char temp;

			if((kb_flag & FLAG_EZERO)&&(tempdata >= 0x6b)){
				p = (PGM_P)keytable2;
				tempdata -= 0x6b;
				p += tempdata;
			}else{
				p = (PGM_P)keytable;
				p += ((int)tempdata << 1);

				if(kb_flag & FLAG_SHIFT){
					p++;
				}
			}

			temp=pgm_read_byte(p);
			if(temp != 0){
				kb_buffer = temp;
				kb_buffcnt++;
			}
		}
	}
	kb_flag &= ~(FLAG_EZERO | FLAG_ISUP);
}



//----------keyboard get buffer
unsigned char kb_getbuff(void)
{
	#if USEMOUSE
		return(0);
	#endif

	if(kb_buffcnt==0) return(0);

	kb_buffcnt--;

	return(kb_buffer);
}


//debug
/*

int main(void)
{
	unsigned char key;
	long i;

	led_init();
	led_locate(0,0);
	led_putch('K');
	led_putch('B');

	i=100000;
	while(i--);

	kb_init();
	sei();
		
	while(1)
	{
		led_disp();

		key = kb_getbuff();
		if(key != 0){
			led_putch(key);
		}
	}
	return 0;
}
*/


#define PS2CLK_EQ_HIGH  (PS2_CLKPIN & PS2_CLKBIT)
#define PS2DATA_EQ_HIGH (PS2_DATAPIN & PS2_DATABIT)

#if USEMOUSE

//----------
unsigned char mouse_recvbyte(void)
{
	while(kb_buffcnt==0);
	kb_buffcnt--;

	return(kb_buffer);
}

void mouse_sendbyte(unsigned char data)
{
    char i, parity=0, ret= 0;
	int wait=2000;

	PS2INTR_DISABLE;	// 荞݋֎~

    ps2_clk_high();
    ps2_clk_low();
    while(wait--);		//    wait 60u-100usec
    ps2_data_low();		//Start bit
    ps2_clk_high();

    for(i=0; i<8; i++) {
		ps2_clkwait();
        if(data & 1) {	//
            ps2_data_high();
            parity++;
        } else {
            ps2_data_low();
        }
        data >>= 1;
    }
	ps2_clkwait();
    if(parity & 1) {	// odd parity bit
        ps2_data_low();
    } else {
        ps2_data_high();
    }
	ps2_clkwait();
    ps2_data_high();		// stop bit

	ps2_clkwait();
    if(PS2DATA_EQ_HIGH) {	// ack
        ret = 1;//error
    }
    while(!(PS2CLK_EQ_HIGH));

	PS2INTR_ENABLE;	// 荞݋
}


//-----------------------------------
void mouse_get(MOUSEDATA *pmouse)
{
    unsigned char ret;
	int valx,valy;

    ret = mouse_recvbyte();	//
	if((ret & (1<<3))==0)return;	//t[~OG[?

	valx = (int)mouse_recvbyte();
	valy = (int)mouse_recvbyte();

	if(ret & (1<<4))valx = -valx;	//X}CiX
	pmouse->x1 = valx;
	if(ret & (1<<5))valy = -valy;	//Y}CiX
	pmouse->y1 = valy;
	pmouse->button = ret & 7;
	//bit0:left button
	//bit1:right button
	//bit2:mid button
	//bit3:1
	//bit4:Xs 1=left/0=right
	//bit5:Ys 1=down/0=up
	//bit6:Xv overflow
	//bit7:Yv overflow
}

//-----------------------------------
void ps2_clkwait(void)
{
	ps2_clk_high();

    while(!(PS2CLK_EQ_HIGH));

    while(PS2CLK_EQ_HIGH);
}

#endif
