// str
// by takuya matsubara

#include <avr/pgmspace.h>
#include "str.h"

//------------------------------------------------------------
unsigned char str_ucase(unsigned char chrcode)
{
	if((chrcode >= 'a')&&(chrcode <= 'z'))
		chrcode -= 0x20;

	return(chrcode);
}



//------------------------------------------------------------
//Rs[:pSrc
//Rs[:pDst
void str_cpy(char *pDst,char *pSrc)
{
	while(1){
		*pDst = *pSrc;
		if(*pDst == 0)break;
		pDst++;
		pSrc++;
	}
}





//--------------------------------------------------------------

char str_ncmp(char *p1,char *p2,char cnt)
{
	while(*p1 == *p2)
	{
		cnt--;
		if(cnt <= 0)return(0);	//equal
		p1++;
		p2++;
	}
	return(1);	//not EQ
}

//------------------------------------------------------------
//񒷂
char str_len(char *p1)
{
	char len=0;

	while(*p1 != 0)
	{
		p1++;
		len++;
	}
	return(len);
}

void str_cat(char *p1,char *p2)
{
	str_cpy(p1+str_len(p1) ,p2);
}

//------------------------------------------------------------
//r
//v0ԂBsv1Ԃ
char str_cmp(char *p1,char *p2)
{
	while(*p1 == *p2)
	{
		if(*p1 == 0)return(0);//equal
		p1++;
		p2++;
	}
	return(1);// not equal
}

//------------------------------------------------------------
//𐔎
//啶ł邱
//example "&HFFF"  "&B01011" "123"
int	str_val(char *str)
{
	int ketaval=1;
	int val=0;
	char ketamulti=10;
	char ch;
	char len;
	char minus=0;

	if(*str=='-'){	//}CiX
		str++;
		minus=1;
	}
	if(*str=='&'){	//&H ܂ &B
		str++;
		if(*str=='H') ketamulti=16;
		if(*str=='B') ketamulti=2;
		str++;
	}

	len = str_len(str);
	str += (len-1);	//ŉʂϊ
	while(len--){
		ch = *str;
		str--;
		if(ch >= '0'){	//p̏ꍇAi͖j
			if(ch>='A')
				ch = 10+(ch-'A');	//16ip
			else
				ch -= '0';

			val +=  ch * ketaval;
			ketaval *= ketamulti;
		}
	}
	if(minus==1)
		val = -val;

	return(val);
}

//------------------------------------------------------------
//
void prm_strcpy(char *pDst, PGM_P pSrc ,char cnt)
{
	while(cnt > 0){
		if(pgm_read_byte(pSrc++)=='\0')
			cnt--;
	}
	while(1){
		*pDst = pgm_read_byte(pSrc++);
		if(*pDst=='\0')break;
		pDst++;
	}
}


char prm_search(PGM_P pTbl ,char *pKey)
{
	char num=0;
	char *pTmp;
	char ch;

	while(1){
		pTmp = pKey;
		while(1){
			ch = pgm_read_byte(pTbl++);
			if(*pTmp != ch)
				break;	//not equal

			if(ch == '\0')return(num);	//equal
			pTmp++;
		}
		while(ch != '\0'){
			ch = pgm_read_byte(pTbl++);
		}
		if(pgm_read_byte(pTbl)=='\0')
			return(-1);	//not found

		num++;
	}
}

