// Switch function
// by Takuya Matsubara / NICO Corp. 2008
// http://www.nicotak.com/
//

//
// ppEĔzz͎Rɂł܂B
// Ĕzzꍇɂ͂킩₷`ŖLĂB
//---------------------------------------------------------------------
#include <avr/io.h>
#include "sw.h"

#define SW_PORT  PORTE		// vAbv
#define SW_DDR   DDRE       // |[g͐ݒ
#define SW_PIN   PINE       // ̓|[g

#define SWMASK_U (1<<2)	//up
#define SWMASK_D (1<<3)	//down
#define SWMASK_L (1<<4)	//left
#define SWMASK_R (1<<5)	//right


#define SWBTN_PORT  PORTD		// vAbv
#define SWBTN_DDR   DDRD       // |[g͐ݒ
#define SWBTN_PIN   PIND       // ̓|[g

#define SWMASK_A	 (1<<6)
#define SWMASK_B	 (1<<7)

char SW_WRK[4];

void sw_init(void)
{
	SW_PORT |=  (SWMASK_U|SWMASK_D|SWMASK_R|SWMASK_L); 	//pullup
 	SW_DDR  &= ~(SWMASK_U|SWMASK_D|SWMASK_R|SWMASK_L); 	//input

	SWBTN_PORT |= (SWMASK_A|SWMASK_B); 	//pullup
 	SWBTN_DDR  &= ~(SWMASK_A|SWMASK_B); 	//input
}

//---------------------------------------------------------------
// XCb`ǂݎ
//   :o|[g̃}XN
//   ߂lF0=XCb`It / 1=XCb`I


void sw_sampling( void )
{
	/// rv艻 ///
	char msk  ;
	char l1   ;
	char l2   ;
	char lvl  ;
	char swdata=0;

	if(!(SW_PIN & SWMASK_U))	swdata |= SW_UP;
	if(!(SW_PIN & SWMASK_D))	swdata |= SW_DOWN;
	if(!(SW_PIN & SWMASK_R))	swdata |= SW_RIGHT;
	if(!(SW_PIN & SWMASK_L))	swdata |= SW_LEFT;
	if(!(SWBTN_PIN & SWMASK_A))	swdata |= SW_A;
	if(!(SWBTN_PIN & SWMASK_B))	swdata |= SW_B;

	msk  = SW_WRK[2] ^ SW_WRK[3];
	l1   = SW_WRK[2] & ~msk;
	l2   = swdata       &  msk;
	lvl  = l1 | l2;

	/// rvgK ///
	SW_WRK[1] = lvl & ~SW_WRK[0];

	/// XV ///
	SW_WRK[0] = lvl;
	SW_WRK[2] = SW_WRK[3];
	SW_WRK[3] = swdata;
}

//---------------------------------------------------------------
// XCb`ǂݎ
//   :o|[g̃}XN
//   ߂lF0=XCb`It / 1=XCb`I
unsigned char sw_get(void)
{
#if 1
	char swdata=0;

	if(!(SW_PIN & SWMASK_U))	swdata |= SW_UP;
	if(!(SW_PIN & SWMASK_D))	swdata |= SW_DOWN;
	if(!(SW_PIN & SWMASK_R))	swdata |= SW_RIGHT;
	if(!(SW_PIN & SWMASK_L))	swdata |= SW_LEFT;
	if(!(SWBTN_PIN & SWMASK_A))	swdata |= SW_A;
	if(!(SWBTN_PIN & SWMASK_B))	swdata |= SW_B;

	return(swdata);
#else
	return(SW_WRK[0]);  // XCb`Ă
#endif
}

//---------------------------------------------------------------
// XCb`ǂݎ
//   :o|[g̃}XN
//   ߂lF0=XCb`It / 1=XCb`I
unsigned char sw_get_trig(void)
{
	return(SW_WRK[1]);
}


