//---------------------------------------------------------------------
// text function
// for EDU2(ATmega64)
// by takuya matsubara
// http://nicotak.com
//---------------------------------------------------------------------
#include <avr/io.h>
#include <avr/pgmspace.h>
#include "vram.h"
#include "textx.h"
#include "i2c.h"

#if FONTMINI
	#include "sfontmin.h"	//3x5X[tHg
#else
	#include "sfont.h"	//4x6X[tHg
#endif

#if MMC_KANJI
	#include "tff.h"	//FAT file system by ChaN
	#include "diskio.h"	//FAT file system by ChaN
#endif

extern char dispwidth;
extern char dispheight;
extern char dispmode;

char text_x=0;  // printfpJ[\ʒu
char text_y=0;
//char cursorflag=0;
char color=1;

//---------------------------------------------------------------------
// J[\ʒuݒ
// xFXW0`BʊOƎsB
// yFYW0`BʊOƉ։ʃXN[܂B-1ƍ̒lێ
void text_locate(char tx,char ty)
{
	text_x = tx;

	if(ty != -1)
		text_y = ty;
}

void text_setcolor(char c)
{
	color=c;
}



void text_putch2(unsigned char ch)
{
	char tx;
	char ty;
	char i;
	unsigned char bitdata;
	PGM_P p = (PGM_P)smallfont;
	
	if(ch < 0x20){
		ch='';
	}
	if(dispmode==1){	//LN^t̏ꍇ
		tx=text_x / (FONTW+1);
		ty=text_y / (FONTH+1);
		lcd_setchar(tx ,ty ,ch);
		return;
	}

	ty = text_y;
	p += ((int)(ch - 0x20) * 3);

	for(i=0 ;i<FONTH ;i++) {
		if((ty >= 0)&&(ty < dispheight)){
			bitdata = pgm_read_byte(p);

			if((i & 1)==0){	//i % 2
				bitdata >>= 4;
			}else{
				bitdata &= 0xf;
				p++;
			}

			for(tx=0; tx<FONTW; tx++){
				if((1<<3) & bitdata)
					vram_pset(text_x+tx,ty,color);
//				else
//					vram_pset(text_x+tx,ty,0);
				bitdata<<=1;
			}
		}
		ty++;
	}
}

unsigned char chh=0;

//---------------------------------------------------------------------
// 1LN^VRAM]
//E1\Ă玩J[\ړ
// chFLN^[R[hi0x00-0xffj
// ߂lF0Ԃ܂B
void text_putch(unsigned char ch)
{
	if(ch==13){	// CR
		text_x = dispwidth;
//	}else if(ch==0x1D){	// cursor left
	}else if(ch==8){	// bs
		text_x -= (FONTW+1);    // J[\ړ
		vram_line(text_x,text_y,text_x+FONTW,text_y+FONTH,0x10);
		return;
	}

	//SJIS
	if(chh != 0){	//high byte = exist
		text_putchw(((unsigned int)chh << 8) | ch);
		chh=0;
	}else{			 //high byte = empty
		if((ch >= 0x81)&&(ch < 0x98)){
			chh = ch;
			return;
		}else{
			text_putch2(ch);	//normal code
			text_x += 5;    // J[\ړ
		}
	}

	if(text_x > (dispwidth-FONTW)){
		text_x = 0;
		text_y += 8;
	}
	if(text_y > (dispheight-FONTH)){
		vram_scroll(0,text_y-(dispheight-FONTH));
		text_y=dispheight-FONTH;
	}
}





#if MMC_KANJI

//SJIS\ memory card
void text_putchw(unsigned int ch)
{
	FIL file;
	BYTE res;
	UINT cnt;

	unsigned int adr;
	char x,y;
	unsigned char bitdata[8];

	if(text_x > (dispwidth-8)){
		text_x = 0;
		text_y += 8;
	}
	if(text_y > (dispheight-8)){
		vram_scroll(0,text_y-(dispheight-8));
		text_y=dispheight-8;
	}

	adr = ch-0x8140;
	adr = ((adr >> 8)*0xc0)+(adr & 0xff);
	adr *= 8;

	// tHgt@CJ
	res = f_open(&file, "font.dat", FA_OPEN_EXISTING | FA_READ);
	if (res) return;
	res = f_lseek(&file, adr);
	res = f_read(&file, bitdata, 8, &cnt);
	f_close(&file);	// t@C


	for(y=0 ;y<8 ;y++) {
		for(x=0 ;x<8 ;x++) {
			if((0x80 >> x)& bitdata[(int)y])
				vram_pset(text_x+x, text_y+y, color);
		}
	}
	text_x += 10;    // J[\ړ
}
#else
//EEPROM
void text_putchw(unsigned int ch)
{
	#define EEPROMSLA 0xA0     // EEPROM AhX

	unsigned int adr;
	char x,y;
	unsigned char bitdata[8];

	if(text_x > (dispwidth-8)){
		text_x = 0;
		text_y += 8;
	}
	if(text_y > (dispheight-8)){
		vram_scroll(0,text_y-(dispheight-8));
		text_y=dispheight-8;
	}

	adr = ch - 0x8140;
	adr = ((adr >> 8)*0xc0)+(adr & 0xff);
	adr *= 8;

	// font data
	i2c_eeprom_read(EEPROMSLA,adr,bitdata,8);

	for(y=0 ;y<8 ;y++) {
		for(x=0 ;x<8 ;x++) {
			if((0x80 >> x)& bitdata[(int)y])
				vram_pset(text_x+x, text_y+y, color);
		}
	}
	text_x += 10;    // J[\ړ
}

#endif

