//
// http://www7.big.jp/~kerokero/avr/


#include <avr/io.h>
#include <avr/interrupt.h>
#include <avr/pgmspace.h>

#include "nicobasic.h"
#include "akiled.h"


//--------------------------------------
#define BYTE unsigned char
#define WORD unsigned short

//---------------------------------------------------------------------
//   h^ns`
//---------------------------------------------------------------------

struct PB{
	char :1;			//0
	char :1;			//1
	char :1;			//2
	char :1;			//3
	char VID_DOT:1;		//4 rfIEhbg
	char VID_SYNC:1;	//5 rfIMoc1a
	char BEEP:1;		//6 TEhooc1b
	char :1;			//7
};

#define pib (*(volatile struct PB*)&PINB)
#define pdb (*(volatile struct PB*)&DDRB)
#define pob (*(volatile struct PB*)&PORTB)

//--------------------------------------
//#include "sound.h"
//#include "mml.h"

//NbNXs[hmenuProject - ConfigrationŐݒς
#ifndef F_CPU
	#define F_CPU 8000000	// CPUNbNg[Hz]
#endif
#define FREQ_H 15750	// horizontal frequency[Hz]

void videodot0(BYTE *vram );
void videodot1(BYTE *vram );
void videodot2(BYTE *vram );
void videodot3(BYTE *vram );
void videodot4(BYTE *vram );
void videodot5(BYTE *vram );
void videodot6(BYTE *vram );
void videodot7(BYTE *vram );



///////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////// rfIM
///////////////////////////////////////////////////////////////////////////
extern unsigned char vram[488];

BYTE linesync=1;
BYTE linetmp=0;


#define LINESTART 29	//VsyncI [line]

#if F_CPU == 8000000
	#define OFFSETV 60		//s̗][clock]
//	#define VIDEOWIDTH 16	//screen width[pixel]
	#define DOTH 4			//1pixel̃TCY[line]
#else
	#define OFFSETV 230		//s̗][clock]
//	#define VIDEOWIDTH 52	//screen width[pixel]
	#define DOTH 5			//1pixel̃TCY[line]
#endif

//#define DOTH 6			//1pixel̃TCY[line]
#define VIDEOHEIGHT 32	//screen height[pixel]


typedef void job( BYTE *p);
job *calladr;
job *sss1[] = {
	videodot0,
	videodot1,
	videodot2,
	videodot3,
	videodot4,
	videodot5,
	videodot6,
	videodot7,
};

///////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////// 荞ݏ
// 1sec/15750Hz =  63.49...usec
// (1sec/60) / (1sec/15750) = 262.5

//   1`9:M
//       1`3OupX
//       4`6pX
//       7`9upX
//   10`21:eXgMȂ

char video_driver(void)
{
	if(linesync < 22){	// line001-line021 
		if(linesync == 1){
			//Output Compare Register A
			OCR1A = ((F_CPU / FREQ_H) - 20);
//			OCR1A = (F_CPU / FREQ_H) ;
		}else if(linesync == 7){
			OCR1A = F_CPU / 160000; //
		}
		linesync++;
		return(0);
	}
	//line022-

		BYTE row;
		BYTE *p;

		row = linetmp / DOTH;

//	if(linetmp >= (VIDEOHEIGHT * DOTH)){
	if(row >= VIDEOHEIGHT){

		linetmp++;
		if(linetmp == ((VIDEOHEIGHT * DOTH)+1)){
			return(1);
		}
		if(linetmp == (262-21)){
			linesync = 1;
			linetmp = 0;
		}
		return(0);
	}


	#if USE_AKILED
		if((row * DOTH)==linetmp){
			led_disp();	//akizuki LED
			linetmp++;
			return(0);
		}
	#endif

//	mask = pgm_read_byte(&masktable[row & 7]);
	p = &vram[(row >> 3)*122];

#if F_CPU>8000000
		while(TCNT1L < OFFSETV);	//// Ԓ ////
#endif

	calladr = sss1[row & 7];
	calladr(p);

	linetmp++;

	return(0);
}


////////////////////////////////////////////////////
/////////////////////////// 
////////////////////////////////////////////////////

void video_init(void)
{
	/// PWMݒ ///
	TCNT1 = 0;
	ICR1 = (F_CPU / FREQ_H) - 1;	/// TOPl

	TCCR1A = (3<<COM1A0)|(2<<COM1B0)|(2<<WGM10);
//video
//Set   OC1A on Compare Match,and Clear OC1A at BOTTOM (inverting mode).
//  operation=Fast PWM / top=OCR1A / update=BOTTOM / flagset=TOP

	TCCR1B = (3<<WGM12)|(1<<CS10);
//audio
//Clear OC1B on Compare Match,and Set OC1B at BOTTOM (non-inverting mode).
//  operation=Fast PWM / top=ICR1 / update=BOTTOM / flagset=TOP

//Waveform Generation Mode WGM1x = 0b1110
//clock select= clk div1

	/// 
	TIMSK |= (1<<TOIE1);	// ^C}[Pꊄ

	/// |[go
	pdb.VID_DOT  = 1;
	pdb.VID_SYNC = 1;
#if USE_BEEP
	pdb.BEEP     = 1;
#endif
}

/////////////////////////////////////////////////////

