//
// http://www7.big.jp/~kerokero/avr/

// for greencard
// by takuya matsubara
// http://nicotak.com

#include <avr/io.h>
#include <avr/interrupt.h>
#include <avr/pgmspace.h>

#include "vram.h"
#include "video.h"


//--------------------------------------
#define BYTE unsigned char
#define WORD unsigned short

//---------------------------------------------------------------------
//   h^ns`
//---------------------------------------------------------------------

struct PB{
	char :1;			// 0
	char VID_SYNC:1;	// 1rfIM
	char BEEP:1;		// 2TEho
	char :1;			//
	char :1;			//
	char :1;
	char :1;
	char :1;
};

#define pib (*(volatile struct PB*)&PINB)
#define pdb (*(volatile struct PB*)&DDRB)
#define pob (*(volatile struct PB*)&PORTB)

struct PD{
	char :1;		//0
	char :1;		//1
	char :1;		//2
	char :1;		//3
	char :1;		//4
	char :1;		//5
	char :1;		//6
	char VID_DOT:1;	//7 rfIM
};

#define pid (*(volatile struct PD*)&PIND)
#define pdd (*(volatile struct PD*)&DDRD)
#define pod (*(volatile struct PD*)&PORTD)

//--------------------------------------
//#include "sound.h"
//#include "mml.h"

//NbNXs[hmenuProject - ConfigrationŐݒς
#ifndef F_CPU
	#define F_CPU 8000000	// CPUNbNg[Hz]
#endif
#define FREQ_H 15750	// horizontal frequency[Hz]


PROGMEM BYTE masktable[]={
	0x01,
	0x02,
	0x04,
	0x08,
	0x10,
	0x20,
	0x40,
	0x80
};


///////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////// rfIM
///////////////////////////////////////////////////////////////////////////
extern unsigned char vram[VRAMSIZE];

BYTE linesync=1;
BYTE linetmp=0;


#if F_CPU == 8000000
	#define OFFSETV 60		//s̗][clock]
	#define DOTH 4			//1pixel̃TCY[line]
#else
	#define OFFSETV 230		//s̗][clock]
	#define DOTH 6			//1pixel̃TCY[line]
#endif


///////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////// 荞ݏ
// 1sec/15750Hz =  63.49...usec
// (1sec/60) / (1sec/15750) = 262.5

//   1`9:M
//       1`3OupX
//       4`6pX
//       7`9upX
//   10`21:eXgMȂ

char video_driver(void)
{
	if(linesync < 22){	// line001-line021 
		if(linesync == 1){	//(line001-line006)
			//Output Compare Register A
#if F_CPU>8000000
			OCR1A = ((F_CPU / FREQ_H) - 20);
#else
			OCR1A = ((F_CPU / FREQ_H) - 8);
#endif
		}else if(linesync == 7){
			OCR1A = F_CPU / 160000; //
		}
		linesync++;
		return(0);
	}
	//line022-

	BYTE row;

	row = linetmp / DOTH;

	if(row >= VRAMHEIGHT){

		linetmp++;
		if(linetmp == ((VRAMHEIGHT * DOTH)+1)){
			return(1);
		}
		if(linetmp == (262-21)){
			linesync = 1;
			linetmp = 0;
		}
		return(0);
	}

	BYTE mask = pgm_read_byte(&masktable[row & 7]);
	BYTE *p = &vram[(row >> 3)* VRAMWIDTH];

#if F_CPU>8000000
		while(TCNT1L < OFFSETV);	//// Ԓ ////
#endif

	char cnt = VRAMWIDTH;
	while(cnt--){
		pod.VID_DOT = ((mask & *p)!=0);
		p++;
	}
	pod.VID_DOT = 0;
	linetmp++;

	return(0);
}


////////////////////////////////////////////////////
/////////////////////////// 
////////////////////////////////////////////////////

void video_init(void)
{
	/// PWMݒ ///
	TCNT1 = 0;
	ICR1 = (F_CPU / FREQ_H) - 1;	/// TOPl

	TCCR1A = (3<<COM1A0)|(2<<COM1B0)|(2<<WGM10);
//video
//Set   OC1A on Compare Match,and Clear OC1A at BOTTOM (inverting mode).
//  operation=Fast PWM / top=OCR1A / update=BOTTOM / flagset=TOP

	TCCR1B = (3<<WGM12)|(1<<CS10);
//audio
//Clear OC1B on Compare Match,and Set OC1B at BOTTOM (non-inverting mode).
//  operation=Fast PWM / top=ICR1 / update=BOTTOM / flagset=TOP

//Waveform Generation Mode WGM1x = 0b1110
//clock select= clk div1

	/// 
	TIMSK1 |= (1<<TOIE1);	// ^C}[Pꊄ

	/// |[go
	pdd.VID_DOT  = 1;
	pdb.VID_SYNC = 1;
}

/////////////////////////////////////////////////////

