//--------------------------------------
// video out for greencard 
// atmega168  OU20MHz

// by takuya matsubara
// http://nicotak.com
// ۏȂ

#include <avr/io.h>
#include <avr/interrupt.h>
#include <avr/pgmspace.h>
#include <avr/sleep.h>

//--------------------------------------
#define BYTE unsigned char
#define WORD unsigned short

#include "video.h"
#include "vram.h"
#include "textx.h"


//NbNXs[hmenuProject - ConfigrationŐݒς
#ifndef F_CPU
	#define F_CPU 8000000	// CPUNbNg[Hz]
#endif
#define FREQ_H 15750	// horizontal frequency[Hz]




///////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////// 荞ݏ
// 1sec/15750Hz =  63.49...usec
// (1sec/60) / (1sec/15750) = 262.5

//   1`9:M
//       1`3OupX
//       4`6pX
//       7`9upX
//   10`21:eXgMȂ
BYTE tick=0;

SIGNAL(SIG_OVERFLOW1)
{	//	15750Hz
	if(video_driver()) tick++;
}

void idle(void){
	sleep_mode();		// 
}

void sleep_loop(char i)
{
	BYTE tickback=tick;

    set_sleep_mode(SLEEP_MODE_IDLE); //
	while(i--){
		while(tickback == tick){
			idle();// 1/60sec
		}
		tickback=tick;
	}
}

//-------------------------------------------------------
int main(void)
{
	BYTE ch=0x20;

	video_init();	// initialize H-sync intr.

	sei();
	while(1)
	{
		text_putch(ch++);
		if(ch >= 0x7f){

			ch=0x20;
		}
		sleep_loop(4);
	}
	return 0;
}
