// vram
// for greencard
// by takuya matsubara
// http://nicotak.com

// ppEĔzz͎Rɂł܂B
// Ĕzzꍇɂ͂킩₷`ŖLĂB
//---------------------------------------------------------------------

#include <avr/io.h>
#include <avr/interrupt.h>
#include "vram.h"


unsigned char vram[VRAMSIZE];//488

void vram_clear(void)
{
	unsigned char *p = &vram[0];
	int i=VRAMSIZE;

	while(i--){
//	for(i=0; i<VRAMMAX; i++){
		*p++ = 0;
	}
}
//-------------------
char vram_point(char x,char y)
{
	unsigned char *pV;
	unsigned char mask;

	if((x<0)||(y<0)||(x>=VRAMWIDTH)||(y>=VRAMHEIGHT))return(0);

	pV = &vram[((y>>3)*VRAMWIDTH)+x];    //  addr=((y/8)*VRAMWIDTH)+x
	mask = 1 << (y & 0b111);//  mask=1<<(y % 8)

	if(*pV & mask)
		return(1);
	else
		return(0);
}
//-----------------
//color 0=OFF / 1=ON / 2=XOR
void vram_pset(char x,char y,char c)
{
	unsigned char *pV;
	unsigned char mask;

	if((x<0)||(y<0)||(x>=VRAMWIDTH)||(y>=VRAMHEIGHT))return;

	pV = &vram[((y>>3)*VRAMWIDTH)+x];    //  addr=((y/8)*VRAMWIDTH)+x
	mask = 1 << (y & 0b111);  //  mask=1<<(y % 8)

	if(c==0)
		*pV &= ~mask;
	else if(c==1)
		*pV |= mask;
	else if(c==2)
		*pV ^= mask;
}
//-----------------
void vram_scroll(char xd,char yd)
{
	unsigned char temp1,temp2,temp3,temp4;
	char yd2;
	int i,j;

	if(xd == 0){
	}else if(xd > 0){
		while(xd--){
			for(j=0; j<(4*VRAMWIDTH); j+=VRAMWIDTH){
				for(i=j; i<(j+(VRAMWIDTH-1)); i++){
					vram[i] = vram[i+1];
				}
				vram[j+(VRAMWIDTH-1)] =0;
			}
		}
	}else{
		xd = -xd;
		while(xd--){
			for(j=0; j<(4*VRAMWIDTH); j+=VRAMWIDTH){
				for(i=(j+(VRAMWIDTH-1)); i>j; i--){
					vram[i] = vram[i-1];
				}
				vram[j+0] =0;
			}
		}
	}

	if(yd > 0){
//		unsigned char *pV;
//		pV = &vram[0];
		yd2 = (8-yd);
		for(i=0; i<VRAMWIDTH; i++){
			temp1 = vram[i+(VRAMWIDTH*0)];
			temp2 = vram[i+(VRAMWIDTH*1)];
			temp3 = vram[i+(VRAMWIDTH*2)];
			temp4 = vram[i+(VRAMWIDTH*3)];
			vram[i+(VRAMWIDTH*0)] = (temp1 >> yd)|(temp2 << yd2);
			vram[i+(VRAMWIDTH*1)] = (temp2 >> yd)|(temp3 << yd2);
			vram[i+(VRAMWIDTH*2)] = (temp3 >> yd)|(temp4 << yd2);
			vram[i+(VRAMWIDTH*3)] = (temp4 >> yd);
//			temp1 = *(pV+0);
//			temp2 = *(pV+(122*1));
//			temp3 = *(pV+(122*2));
//			temp4 = *(pV+(122*3));
//			*(pV+0      ) = (temp1 >> yd)|(temp2 << yd2);
//			*(pV+(122*1)) = (temp2 >> yd)|(temp3 << yd2);
//			*(pV+(122*2)) = (temp3 >> yd)|(temp4 << yd2);
//			*(pV+(122*3)) = (temp4 >> yd);
//			pV++;
		}
	}else{
	//
	}
}




//-----------------
void vram_init(void)
{
	vram_clear();
}


//void lcd_disp(void)
//{
//}


//void vram_boxf(char x1 ,char y1 ,char x2 ,char y2 ,char color)
//{
//	char x;
//	char y;
//
//	if(x1 > x2){
//		x = x1;
//		x1 = x2;
//		x2 = x;
//	}
//	if(y1 > y2){
//		y = y1;
//		y1 = y2;
//		y2 = y;
//	}
//	for(y=y1 ;y<y2 ;y++){
//		for(x=x1 ;x<x2 ;x++){
//			vram_pset(x, y ,color); //hbg`
//		}
//	}
//}


//--------------------------------------------------------------------------------
//C`
//x1FX1W
//y1FY1W
//x2FX2W
//y2FY2W
//colorFJ[R[hB0=/1=
void vram_line(char x1 ,char y1 ,char x2 ,char y2 ,char color)
{
	char xd;	// X2-X1W̋
	char yd;	// Y2-Y1W̋
	char xs=1;  // X1pixelړ
	char ys=1;  // Y1pixelړ
	int e;

	xd = x2 - x1;	 // X2-X1W̋
	if(xd < 0){
		xd = -xd;	 // X2-X1W̐Βl
		xs = -1;	  // X1pixelړ
	}
	yd = y2 - y1;	 // Y2-Y1W̋
	if(yd < 0){
		yd = -yd;	 // Y2-Y1W̐Βl
		ys = -1;	  // Y1pixelړ
	}

	if(color & 0x10){
		color &= ~0x10;
		for(; y1<=y2; y1+=ys){
			for(xd=x1; xd<=x2; xd+=xs){
				vram_pset(xd, y1 ,color); //hbg`
			}
		}
		return;
	}

	vram_pset(x1, y1 ,color); //hbg`
	e = 0;
	if( yd < xd ) {
		while( x1 != x2) {
			x1 += xs;
			e += (2 * yd);
			if(e >= xd) {
				y1 += ys;
				e -= (2 * xd);
			}
			vram_pset(x1, y1 ,color); //hbg`
		}
	}else{
		while( y1 != y2) {
			y1 += ys;
			e += (2 * xd);
			if(e >= yd) {
				x1 += xs;
				e -= (2 * yd);
			}
			vram_pset (x1, y1 ,color); //hbg`
		}
	}
}


#if 0
void vram_circle(char xc, char yc, char r,char col)
{
	char x1,y1,x2=0,y2=0;
	int a;

	for(a=0;a<360;a++){
		x1=(char)(vect_x1(a)*r /255)+xc;
		y1=(char)(vect_y1(a)*r /255)+yc;
		if(a>0)
			vram_line(x1,y1,x2,y2,col);

		x2=x1;
		y2=y1;
	}
}
#else

void vram_circle(char xc, char yc, char r,char col)
{
    int tswitch;
    char X, Y;
	char xp,yp;
	char xm,ym;
    char dYX;

    dYX = yc - xc;
    X = 0;
    Y = r;
    tswitch = 3 - 2 * r;
    while (X <= Y) {
		xp = xc + X;
		yp = yc + Y;
		xm = xc - X;
		ym = yc - Y;

        vram_pset(xp, yp,col);     
        vram_pset(xp, ym,col);
        vram_pset(xm, yp,col);     
        vram_pset(xm, ym,col);
        vram_pset(yp - dYX, yc + X,col); 
        vram_pset(yp - dYX, yc - X,col);
        vram_pset(ym - dYX, yc + X,col); 
        vram_pset(ym - dYX, yc - X,col);
        if (tswitch < 0) {
            tswitch += (4 * X + 6);
        } else {
            tswitch += (4 * (X - Y) + 10);
            Y--;
        }
        X++;
    }
}
#endif
