#include <avr/io.h>
#include <avr/interrupt.h> 
#include "sio.h"

/*-----------------------------------------------------------*/
/*    LCDo͊֐  V{`                              */
/*-----------------------------------------------------------*/
#define LCD_PORT   PORTB
#define LCD_DDR  DDRB

#define LCDCTR_PORT   PORTD
#define LCDCTR_DDR  DDRD

#define LCD_E  (1 << 4)  /* rbg ENABLE      */
#define LCD_RS (1 << 5)  /* rbg REGISTER SELECT  */

#define MSECCNT    1000   /* 1ms̃[v*/

/*-----------------------------------------------------------*/

void lcd_put_ch(char ch);
void lcd_wait( long m );
void lcd_init(void);
void lcd_position(char tx ,char ty);


/*-----------------------------------------------------------*/

void lcd_wait( long m )
{
    while( m > 0 ) {
        m--;
    }
}

/*-----------------------------------------------------------*/
/*    LCD                                              */
/*-----------------------------------------------------------*/
void lcd_init(void)
{
    lcd_wait(15L*MSECCNT);
	LCDCTR_DDR = LCD_E | LCD_RS;
	LCD_DDR = 0xff;

    LCDCTR_PORT &= ~LCD_RS;   /* RS = L */
    lcd_put_ch( 0x30 ); /*Function Set Mode */
    lcd_wait(4L*MSECCNT);
    lcd_put_ch( 0x30 );
    lcd_wait(1L*MSECCNT);
    lcd_put_ch( 0x30 ); /*Function Set Mode=4bit */
    lcd_put_ch( 0x38 ); /* Mode=8bit / Line=2 / Font=5x7dot*/
    lcd_put_ch( 0x0F ); /* Display=ON / Cursor=ON / Blink=ON */
    lcd_put_ch( 0x06 ); /*  */
    lcd_put_ch( 0x01 ); /* Display Clear*/
    lcd_wait(2L*MSECCNT);
    LCDCTR_PORT |= LCD_RS;    /* RS = H */
}


/*-----------------------------------------------------------*/
/*    LCD\ʒu̐ݒ                                      */
/* Fchar tx   :xW                                    */
/* Fchar ty   :yW                                    */
/* ߂lFȂ                                              */
/*              tx                                           */
/*      0123456789ABCDEF                                     */
/*  ty 0################                                     */
/*     1################                                     */
/*-----------------------------------------------------------*/
void lcd_position(char tx ,char ty)
{
    LCDCTR_PORT &= ~LCD_RS;    /* RS = L */
    lcd_put_ch(0x80 | tx | (0x40 * ty)); /* Address = 0 */
    LCDCTR_PORT |= LCD_RS;    /* RS = H */
}



/*-----------------------------------------------------------*/
/*        LCD@1oCgM                                   */
/* F  char ch : LCDW[ւ̑Mf[^             */
/* ߂lFȂ                                              */
/*-----------------------------------------------------------*/
void lcd_put_ch(char ch)
{

    LCD_PORT = ch;  /*f[^i[ */

    LCDCTR_PORT |= LCD_E;   /* ENABLE = H */

    LCDCTR_PORT &= ~LCD_E;   /* ENABLE = L*/
//    lcd_wait(MSECCNT/50);
    lcd_wait(MSECCNT);
}


/*-----------------------------------------------------------*/
/*        LCD \                                     */
/* F char *str : ̐擪|C^                   */
/* ߂lFȂ                                              */
/*-----------------------------------------------------------*/
void lcd_put_str(char *str)
{
    while(*str != 0) {
        lcd_put_ch( *str );
        str++;
    }
}



int main(void)
{
	int c; 
	char x=0;
	char y=0;

	sio_init();
	lcd_init();
	lcd_position(0,0);
	lcd_put_str("Serial Mon.");

	sei();
	while(1)
	{
		c=sio_rx();

		if(c != -1){
	        lcd_put_ch( (char)c );
			if(c==13){
				x=16;
			}
			x++;
			if(x>=16){
				x=0;
				y++;
				if(y>=2){
					y=0;
				}
				lcd_position(x,y);
			}
		}
	}

	return 0;
}
