# -*- mode: ruby; coding: euc-jp-unix -*-
# $Id: test_tudura.rb,v 1.2 2003/12/26 15:23:08 takai Exp $

require 'rubyunit'
require 'tudura'

include Tudura

class MyContextAware
  include ContextAware
  def context
    @context
  end
end

class ContextTest < RUNIT::TestCase
  def setup
    @context = Context.new { |defs|
      defs << ObjectDef.new('obj') do |props|
	props << PropertyDef.new('one',   LiteralValue.new('1'))
	props << PropertyDef.new('two',   LiteralValue.new('2.0'))
	props << PropertyDef.new('three', LiteralValue.new('3.0%'))
	props << PropertyDef.new('ref', ReferenceValue.new('ref_obj'))
      end
      defs << ObjectDef.new('ref_obj') do |props|
	props << PropertyDef.new('value', LiteralValue.new('ref'))
      end
      defs << ObjectDef.new('context_aware', 'MyContextAware')
    }.configure
  end
  def test_new
    assert_equals 1,      @context.fetch(:obj).one
    assert_equals 2.0,    @context.fetch(:obj).two
    assert_equals "3.0%", @context.fetch(:obj).three
    assert_equals "ref",  @context.fetch(:obj).ref.value

    assert_same @context, @context.fetch(:context_aware).context
  end
end
