# -*- mode: ruby; coding: euc-jp-unix -*-
# $Id: test_web.rb,v 1.1 2003/12/27 06:50:38 takai Exp $

require 'rubyunit'
require 'tudura'
require 'tudura/web'
require 'webrick/log'
require 'webrick/config'
require 'webrick/httpversion'
require 'webrick/httprequest'
require 'webrick/httpresponse'

include Tudura

class MockupHandlerMapping
  def get_handler req
    MockupHandler.new
  end
end

class MockupHandler
  include Handler
  def handle_request req, res
    res.body = "MockupHandler#handle_request is called"
  end
end

class MockupHandler2
  include Handler
  def handle_request req, res
    res.body = "MockupHandler2#handle_request is called"
  end
end

class MockupView
  attr_accessor :resource
  def render model, req, res
  end
end

class DispatcherServletTest < RUNIT::TestCase
  def setup
    @servlet = DispatcherServlet.new
    @servlet.handler_mapping = MockupHandlerMapping.new
    
    config = WEBrick::Config::HTTP.dup.update(
        :ServerSoftware => ENV["SERVER_SOFTWARE"],
        :HTTPVersion    => WEBrick::HTTPVersion.new("1.0"),
        :RunOnCGI       => false,   # to detect if it runs on CGI.
        :NPH            => false,   # set true to run as NPH script.
        :Logger         => WEBrick::BasicLog.new
    )
    @req = WEBrick::HTTPRequest.new config
    @res = WEBrick::HTTPResponse.new config
  end

  def test_do_HEAD
    @servlet.do_HEAD @req, @res
    assert_equals "MockupHandler#handle_request is called", @res.body
  end
  def test_do_GET
    @servlet.do_GET @req, @res
    assert_equals "MockupHandler#handle_request is called", @res.body
  end
  def test_do_POST
    @servlet.do_POST @req, @res
    assert_equals "MockupHandler#handle_request is called", @res.body
  end
end

class PathInfoHandlerMappingTest < RUNIT::TestCase
  def setup
    mappings = {'mockup' => MockupHandler.new,
                'mockup2' => MockupHandler2.new}
    @mapping = PathInfoHandlerMapping.new
    @mapping.default_handler = 'mockup'
    @mapping.mappings = mappings
    
    config = WEBrick::Config::HTTP.dup.update(
        :ServerSoftware => ENV["SERVER_SOFTWARE"],
        :HTTPVersion    => WEBrick::HTTPVersion.new("1.0"),
        :RunOnCGI       => false,   # to detect if it runs on CGI.
        :NPH            => false,   # set true to run as NPH script.
        :Logger         => WEBrick::BasicLog.new
    )
    @req = WEBrick::HTTPRequest.new config    
  end
  def test_get_handler
    @req.path_info = nil
    assert_kind_of MockupHandler, get_handler
    @req.path_info = '/mockup/'
    assert_kind_of MockupHandler, get_handler
    @req.path_info = '/mockup2/'
    assert_kind_of MockupHandler2, get_handler
    @req.path_info = ''
    assert_kind_of MockupHandler, get_handler
    @req.path_info = '//'
    assert_kind_of MockupHandler, get_handler
    @req.path_info = '/nosuch/'
    assert_kind_of MockupHandler, get_handler
  end
  
  private
  def get_handler
    @mapping.get_handler @req
  end
end

class FilenameViewResolverTest < RUNIT::TestCase
  def setup
    mappings = {'success' => MockupView.new}
    @resolver = FilenameViewResolver.new
    @resolver.mappings = mappings
    @resolver.prefix   = '/tmp/prefix/'
    @resolver.suffix   = '.rhtml'
  end
  def test_resolv_name
    view = @resolver.resolv_name 'success'
    assert_kind_of MockupView, view
    assert_equals '/tmp/prefix/success.rhtml', view.resource
  end
end

class ErbViewTest < RUNIT::TestCase
  def setup
    @view = ErbView.new
    @view.resource = dirname + '/hello.rhtml'

    config = WEBrick::Config::HTTP.dup.update(
        :ServerSoftware => ENV["SERVER_SOFTWARE"],
        :HTTPVersion    => WEBrick::HTTPVersion.new("1.0"),
        :RunOnCGI       => false,   # to detect if it runs on CGI.
        :NPH            => false,   # set true to run as NPH script.
        :Logger         => WEBrick::BasicLog.new
    )
    @req = WEBrick::HTTPRequest.new config
    @res = WEBrick::HTTPResponse.new config
  end
  def test_render
    model = {'name' => 'World'}
    @view.render model, @req, @res
    assert_equals "Hello, World.", @res.body
  end
  def dirname
    File.dirname __FILE__
  end
end
