/*
 * Decompiled with CFR 0.152.
 */
package jp.nimbus.ide.beanflow.action;

import java.util.List;
import java.util.Map;
import jp.nimbus.ide.action.EditAction;
import jp.nimbus.ide.beanflow.dialog.ExtensionInputDialog;
import jp.nimbus.ide.beanflow.editpart.ArgumentEditPart;
import jp.nimbus.ide.beanflow.editpart.AttributeEditPart;
import jp.nimbus.ide.beanflow.model.Parameter;
import jp.nimbus.ide.beanflow.model.ReferenceType;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.Request;
import org.eclipse.ui.IWorkbenchPart;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class EditExtensionAction
extends EditAction {
    private ReferenceType valueType;
    private String expression;

    public EditExtensionAction(IWorkbenchPart part, String actionId, ReferenceType valueType) {
        super(part, actionId);
        this.valueType = valueType;
    }

    public void run() {
        this.expression = null;
        List editPartList = this.getSelectedObjects();
        if (editPartList != null && editPartList.size() == 1) {
            ExtensionInputDialog dialog;
            ReferenceType parameterType;
            EditPart editPart = (EditPart)editPartList.get(0);
            Parameter parameter = null;
            if (editPart instanceof AttributeEditPart) {
                parameter = (Parameter)editPart.getModel();
            } else if (editPart instanceof ArgumentEditPart) {
                parameter = (Parameter)editPart.getModel();
            }
            String input = null;
            if (parameter != null && (parameterType = parameter.getReferenceType()) == this.valueType) {
                input = (String)parameter.getValue();
            }
            boolean separatedValue = false;
            if (this.valueType == ReferenceType.Var) {
                separatedValue = true;
            }
            if ((dialog = new ExtensionInputDialog(this.getWorkbenchPart().getSite().getShell(), input, separatedValue)).open() == 0) {
                String result = dialog.getResult();
                if (result != null) {
                    if (this.valueType == ReferenceType.Var) {
                        String cursor = this.searchCursor(parameter.getNode());
                        this.expression = String.valueOf(cursor) + result;
                    } else {
                        this.expression = result;
                    }
                }
                super.run();
            }
        }
    }

    protected Request createRequest() {
        Request request = super.createRequest();
        Map data = request.getExtendedData();
        data.put("_data_type", this.valueType);
        data.put("_data_expression", this.expression);
        return request;
    }

    private String searchCursor(Node node) {
        String cursor = null;
        Node parentNode = node.getParentNode();
        if (parentNode != null) {
            cursor = parentNode.getNodeName().equals("for") ? ((Element)parentNode).getAttribute("var") : this.searchCursor(parentNode);
        }
        return cursor;
    }
}

