/*
 * Decompiled with CFR 0.152.
 */
package jp.nimbus.ide.beanflow.action;

import java.util.List;
import java.util.Map;
import jp.nimbus.ide.action.EditAction;
import jp.nimbus.ide.beanflow.editpart.ArgumentEditPart;
import jp.nimbus.ide.beanflow.editpart.AttributeEditPart;
import jp.nimbus.ide.beanflow.editpart.FlowInvocationEditPart;
import jp.nimbus.ide.beanflow.editpart.JunctionEditPart;
import jp.nimbus.ide.beanflow.editpart.LoopEditPart;
import jp.nimbus.ide.beanflow.editpart.ResourceEditPart;
import jp.nimbus.ide.beanflow.editpart.StepEditPart;
import jp.nimbus.ide.beanflow.model.Argument;
import jp.nimbus.ide.beanflow.model.Attribute;
import jp.nimbus.ide.beanflow.model.FlowInvocation;
import jp.nimbus.ide.beanflow.model.Junction;
import jp.nimbus.ide.beanflow.model.Loop;
import jp.nimbus.ide.beanflow.model.ReferenceType;
import jp.nimbus.ide.beanflow.model.Resource;
import jp.nimbus.ide.beanflow.model.Step;
import jp.nimbus.ide.dialog.EditorDialog;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.Request;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.ui.IWorkbenchPart;

public class EditValueAction
extends EditAction {
    private static final String DIALOG_TITLE = "\u7de8\u96c6";
    private static final String DIALOG_DESCRIPTION = "\u65b0\u3057\u3044\u8a2d\u5b9a\u5024\u3092\u5165\u529b\u3057\u3066\u304f\u3060\u3055\u3044\u3002";
    private String expression;
    private ReferenceType valueType = ReferenceType.Text;

    public EditValueAction(IWorkbenchPart part, String actionId) {
        super(part, actionId);
    }

    public void run() {
        this.expression = null;
        List editPartList = this.getSelectedObjects();
        if (editPartList != null && editPartList.size() == 1) {
            EditPart editPart = (EditPart)editPartList.get(0);
            if (editPart instanceof StepEditPart) {
                Step step = (Step)editPart.getModel();
                String input = step.getName();
                this.openSimpleEditDialog(input);
            } else if (editPart instanceof AttributeEditPart) {
                Attribute attribute = (Attribute)editPart.getModel();
                ReferenceType parameterType = attribute.getReferenceType();
                if (parameterType == ReferenceType.Unknown || parameterType == ReferenceType.Text) {
                    String input = (String)attribute.getValue();
                    this.openDetailEditDialog(input);
                }
            } else if (editPart instanceof ArgumentEditPart) {
                Argument argument = (Argument)editPart.getModel();
                ReferenceType parameterType = argument.getReferenceType();
                if (parameterType == ReferenceType.Unknown || parameterType == ReferenceType.Text) {
                    String input = (String)argument.getValue();
                    this.openDetailEditDialog(input);
                }
            } else if (editPart instanceof ResourceEditPart) {
                Resource resource = (Resource)editPart.getModel();
                String input = resource.getName();
                this.openSimpleEditDialog(input);
            } else if (editPart instanceof JunctionEditPart) {
                Junction junction = (Junction)editPart.getModel();
                String input = junction.getCondition();
                this.openSimpleEditDialog(input);
            } else if (editPart instanceof LoopEditPart) {
                Loop loop = (Loop)editPart.getModel();
                String input = loop.getCursor();
                this.openSimpleEditDialog(input);
            } else if (editPart instanceof FlowInvocationEditPart) {
                FlowInvocation flowInvocation = (FlowInvocation)editPart.getModel();
                String input = flowInvocation.getStepName();
                this.openSimpleEditDialog(input);
            }
        }
    }

    protected Request createRequest() {
        Request request = super.createRequest();
        Map data = request.getExtendedData();
        data.put("_data_expression", this.expression);
        data.put("_data_type", this.valueType);
        return request;
    }

    private void openSimpleEditDialog(String input) {
        InputDialog dialog = new InputDialog(this.getWorkbenchPart().getSite().getShell(), DIALOG_TITLE, DIALOG_DESCRIPTION, input, null);
        if (dialog.open() == 0) {
            this.expression = dialog.getValue();
            super.run();
        }
    }

    private void openDetailEditDialog(String input) {
        Object[] result;
        EditorDialog dialog = new EditorDialog(this.getWorkbenchPart().getSite().getShell(), input);
        if (dialog.open() == 0 && (result = dialog.getResult()) != null && result.length == 1) {
            this.expression = (String)result[0];
            super.run();
        }
    }
}

