/*
 * Decompiled with CFR 0.152.
 */
package jp.nimbus.ide.beanflow.action;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import jp.nimbus.ide.action.EditAction;
import jp.nimbus.ide.beanflow.dialog.ExtendedSelectionDialog;
import jp.nimbus.ide.beanflow.editpart.ArgumentEditPart;
import jp.nimbus.ide.beanflow.editpart.AttributeEditPart;
import jp.nimbus.ide.beanflow.model.Activity;
import jp.nimbus.ide.beanflow.model.ActivityContainer;
import jp.nimbus.ide.beanflow.model.Flow;
import jp.nimbus.ide.beanflow.model.Parameter;
import jp.nimbus.ide.beanflow.model.ReferenceType;
import jp.nimbus.ide.beanflow.model.Step;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.Request;
import org.eclipse.ui.IWorkbenchPart;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SelectStepAction
extends EditAction {
    private static final String DIALOG_TITLE = "\u30b9\u30c6\u30c3\u30d7\u306e\u9078\u629e";
    private static final String DIALOG_MESSAGE = "\u30b9\u30c6\u30c3\u30d7\u3092\u9078\u629e\u3057\u3066\u304f\u3060\u3055\u3044\u3002";
    private Flow flow;
    private String expression;

    public SelectStepAction(IWorkbenchPart part, String actionId, Flow flow) {
        super(part, actionId);
        this.flow = flow;
    }

    @Override
    public void run() {
        this.expression = null;
        List editPartList = this.getSelectedObjects();
        if (editPartList != null && editPartList.size() == 1) {
            Object[] result;
            Parameter parameter;
            String input = null;
            EditPart editPart = (EditPart)editPartList.get(0);
            if ((editPart instanceof AttributeEditPart || editPart instanceof ArgumentEditPart) && (parameter = (Parameter)editPart.getModel()).getReferenceType() == ReferenceType.StepRef) {
                input = (String)parameter.getValue();
            }
            ArrayList<String> stepNameList = new ArrayList<String>();
            this.searchStep(stepNameList, this.flow.getActivities());
            Collections.sort(stepNameList);
            ExtendedSelectionDialog dialog = new ExtendedSelectionDialog(this.getWorkbenchPart().getSite().getShell(), DIALOG_TITLE, DIALOG_MESSAGE, stepNameList.toArray(new String[stepNameList.size()]), input);
            if (dialog.open() == 0 && (result = dialog.getResult()) != null && result.length == 1) {
                this.expression = (String)result[0];
                super.run();
            }
        }
    }

    private void searchStep(List<String> stepNameList, List<Activity> activityList) {
        for (Activity activity : activityList) {
            if (activity instanceof Step) {
                stepNameList.add(((Step)activity).getName());
                continue;
            }
            if (!(activity instanceof ActivityContainer)) continue;
            this.searchStep(stepNameList, ((ActivityContainer)((Object)activity)).getActivities());
        }
    }

    @Override
    protected Request createRequest() {
        Request request = super.createRequest();
        Map data = request.getExtendedData();
        data.put("_data_expression", this.expression);
        data.put("_data_type", ReferenceType.StepRef);
        return request;
    }
}

