/*
 * Decompiled with CFR 0.152.
 */
package jp.nimbus.ide.beanflow.dialog;

import java.util.regex.Pattern;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class ExtensionInputDialog
extends Dialog {
    private static final String TITLE = "\u30e1\u30f3\u30d0\u53c2\u7167\u306e\u8a2d\u5b9a";
    private ExtensionType extensionType = ExtensionType.None;
    private Text extensionText;
    private static Pattern digitPattern = Pattern.compile("[0-9]+");
    private String result;
    private boolean separatedValue;

    public ExtensionInputDialog(Shell parentShell, String initialValue, boolean separatedValue) {
        super(parentShell);
        this.separatedValue = separatedValue;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(TITLE);
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = this.createBasePanel(parent);
        Composite optionsPanel = new Composite(composite, 0);
        optionsPanel.setLayoutData((Object)new GridData(768));
        optionsPanel.setLayout((Layout)new GridLayout(2, false));
        Button button1 = new Button(optionsPanel, 16);
        button1.setText("\u306a\u3057");
        button1.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ExtensionInputDialog.this.extensionType = ExtensionType.Indexer;
            }
        });
        button1.setSelection(true);
        Button button2 = new Button(optionsPanel, 16);
        button2.setText("\u30a4\u30f3\u30c7\u30af\u30b5");
        button2.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ExtensionInputDialog.this.extensionType = ExtensionType.Indexer;
            }
        });
        Button button3 = new Button(optionsPanel, 16);
        button3.setText("\u30d7\u30ed\u30d1\u30c6\u30a3");
        button3.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ExtensionInputDialog.this.extensionType = ExtensionType.Property;
            }
        });
        this.extensionText = new Text(composite, 2048);
        this.extensionText.setLayoutData((Object)new GridData(768));
        return composite;
    }

    private Composite createBasePanel(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(1, false);
        layout.marginHeight = this.convertVerticalDLUsToPixels(7);
        layout.marginWidth = this.convertHorizontalDLUsToPixels(7);
        layout.verticalSpacing = this.convertVerticalDLUsToPixels(4);
        layout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(1808));
        ExtensionInputDialog.applyDialogFont((Control)composite);
        return composite;
    }

    protected void buttonPressed(int buttonId) {
        if (buttonId == 0) {
            String extensionString = this.extensionText.getText();
            if (extensionString != null && extensionString.length() > 0) {
                if (this.extensionType == ExtensionType.Indexer) {
                    extensionString = digitPattern.matcher(extensionString).matches() ? "[" + extensionString + "]" : "(" + extensionString + ")";
                } else if (this.extensionType == ExtensionType.Property && this.separatedValue) {
                    extensionString = "." + extensionString;
                }
                this.result = extensionString;
            }
            this.okPressed();
        } else if (1 == buttonId) {
            this.result = null;
            this.cancelPressed();
        }
    }

    public String getResult() {
        return this.result;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum ExtensionType {
        None,
        Indexer,
        Property;

    }
}

