/*
 * Decompiled with CFR 0.152.
 */
package jp.nimbus.ide.beanflow.editpart;

import java.beans.PropertyChangeEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import jp.nimbus.ide.beanflow.action.StaticMethodExpression;
import jp.nimbus.ide.beanflow.figure.InvocationFigure;
import jp.nimbus.ide.beanflow.figure.StatementFigure;
import jp.nimbus.ide.beanflow.model.Argument;
import jp.nimbus.ide.beanflow.model.ReferenceType;
import jp.nimbus.ide.beanflow.model.StaticInvocation;
import jp.nimbus.ide.editpart.EditableModelEditPart;
import org.eclipse.draw2d.IFigure;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.editpolicies.ComponentEditPolicy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArgumentEditPart
extends EditableModelEditPart {
    protected IFigure createFigure() {
        Argument argument = (Argument)this.getModel();
        StatementFigure figure = new StatementFigure(){

            public void add(IFigure figure, Object constraint, int index) {
                if (figure instanceof InvocationFigure) {
                    super.add(figure, constraint, -1);
                    ArgumentEditPart.this.updateParentBounds();
                } else {
                    super.add(figure, constraint, index);
                }
            }

            public void remove(IFigure figure) {
                super.remove(figure);
                if (figure instanceof InvocationFigure) {
                    ArgumentEditPart.this.updateParentBounds();
                }
            }
        };
        figure.setValue(argument);
        return figure;
    }

    protected List<Object> getModelChildren() {
        ArrayList<Object> children = new ArrayList<Object>();
        Argument argument = (Argument)this.getModel();
        if (argument.getReferenceType() == ReferenceType.StaticInvoke) {
            children.add(argument.getValue());
        }
        return children;
    }

    protected void createEditPolicies() {
        this.installEditPolicy("ComponentEditPolicy", (EditPolicy)new ArgumentEditPolicy());
    }

    @Override
    public void propertyChange(PropertyChangeEvent event) {
        String propertyName = event.getPropertyName();
        if (propertyName.equals("_bounds")) {
            this.refreshBounds();
        } else if (propertyName.equals("_value")) {
            Argument argument = (Argument)this.getModel();
            StatementFigure figure = (StatementFigure)this.getFigure();
            figure.setValue(argument);
            this.refreshChildren();
            this.updateParentBounds();
        }
    }

    private class ArgumentEditPolicy
    extends ComponentEditPolicy {
        private ArgumentEditPolicy() {
        }

        public Command getCommand(Request request) {
            Command command = null;
            Object type = request.getType();
            if (type.equals("_edit_values") || type.equals("_reference_object") || type.equals("_reference_input") || type.equals("_reference_service") || type.equals("_reference_resource") || type.equals("_reference_step") || type.equals("_reference_cursor")) {
                command = this.createEditValueCommand(request);
            } else if (type.equals("_add_static_method")) {
                command = this.createEditStaticInvocationCommand(request);
            }
            return command;
        }

        private Command createEditValueCommand(Request request) {
            Argument argument = (Argument)ArgumentEditPart.this.getModel();
            ReferenceType argumentType = (ReferenceType)((Object)request.getExtendedData().get("_data_type"));
            String expression = (String)request.getExtendedData().get("_data_expression");
            return new EditValueCommand(argument, argumentType, expression);
        }

        private Command createEditStaticInvocationCommand(Request request) {
            Argument argument = (Argument)ArgumentEditPart.this.getModel();
            Map data = request.getExtendedData();
            StaticMethodExpression methodExpression = (StaticMethodExpression)data.get("_data_expression");
            StaticInvocation staticInvocation = null;
            if (methodExpression != null) {
                String type = methodExpression.getType();
                String methodName = methodExpression.getName();
                String[] parameterTypes = methodExpression.getParameterTypes();
                staticInvocation = argument.createStaticInvocation();
                staticInvocation.setCode(type);
                staticInvocation.setName(methodName);
                ArrayList<Argument> arguments = new ArrayList<Argument>();
                String[] stringArray = parameterTypes;
                int n = parameterTypes.length;
                int n2 = 0;
                while (n2 < n) {
                    String parameterTypeExp = stringArray[n2];
                    Argument arg = staticInvocation.createArgument();
                    arg.setType(parameterTypeExp);
                    arguments.add(arg);
                    ++n2;
                }
                staticInvocation.setArguments(arguments);
            }
            return new EditValueCommand(argument, ReferenceType.StaticInvoke, staticInvocation);
        }
    }

    private class EditValueCommand
    extends Command {
        private Argument argument;
        private ReferenceType argumentType;
        private Object expression;
        private ReferenceType oldArgumentType;
        private Object oldExpression;

        public EditValueCommand(Argument argument, ReferenceType argumentType, Object expression) {
            this.argument = argument;
            this.argumentType = argumentType;
            this.expression = expression;
        }

        public void execute() {
            this.oldArgumentType = this.argument.getReferenceType();
            this.oldExpression = this.argument.getValue();
            this.argument.setValue(this.argumentType, this.expression);
        }

        public void undo() {
            this.argument.setValue(this.oldArgumentType, this.oldExpression);
        }
    }
}

