/*
 * Decompiled with CFR 0.152.
 */
package jp.nimbus.ide.beanflow.model;

import java.util.ArrayList;
import java.util.List;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import jp.nimbus.ide.Activator;
import jp.nimbus.ide.ParseException;
import jp.nimbus.ide.beanflow.model.Argument;
import jp.nimbus.ide.model.EditableModel;
import jp.nimbus.ide.model.ElementModel;
import jp.nimbus.ide.xml.util.DocumentUtil;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Invocation
extends EditableModel
implements ElementModel {
    private static final String ATTR_NAME = "name";
    private static final String TAG_ARGUMENT = "argument";
    public static final String NAME = "_name";
    public static final String ARGUMENTS = "_arguments";
    private static XPathExpression nameXPath;
    protected Element node;
    private List<Argument> argumentList;

    static {
        try {
            nameXPath = Activator.xPath.compile("@name");
        }
        catch (XPathExpressionException e) {
            e.printStackTrace();
        }
    }

    public Invocation(Element node) {
        this.node = node;
        this.createArgumentList();
    }

    private void createArgumentList() {
        this.argumentList = new ArrayList<Argument>();
        NodeList nodeList = this.node.getChildNodes();
        int length = nodeList.getLength();
        int i = 0;
        while (i < length) {
            Element element;
            Node childNode = nodeList.item(i);
            if (childNode.getNodeType() == 1 && (element = (Element)childNode).getTagName().equals(TAG_ARGUMENT)) {
                Argument argument = new Argument(element);
                this.argumentList.add(argument);
            }
            ++i;
        }
    }

    @Override
    public Element getNode() {
        return this.node;
    }

    public String getName() {
        String name = null;
        try {
            name = (String)nameXPath.evaluate(this.node, XPathConstants.STRING);
        }
        catch (XPathExpressionException e) {
            throw new ParseException(e);
        }
        return name;
    }

    public void setName(String name) {
        this.node.setAttribute(ATTR_NAME, name);
        this.firePropertyChange(NAME, null, name);
    }

    public Argument createArgument() {
        Element element = DocumentUtil.createElement(this.node, TAG_ARGUMENT);
        return new Argument(element);
    }

    public List<Argument> getArguments() {
        return this.argumentList;
    }

    public void setArguments(List<Argument> arguments) {
        for (Argument argument : arguments) {
            this.node.appendChild(argument.getNode());
            this.argumentList.add(argument);
        }
        this.firePropertyChange(ARGUMENTS, null, arguments);
    }
}

