/*
 * Decompiled with CFR 0.152.
 */
package jp.nimbus.ide.beanflow.model;

import java.util.ArrayList;
import java.util.List;
import jp.nimbus.ide.beanflow.model.Attribute;
import jp.nimbus.ide.beanflow.model.Invocation;
import jp.nimbus.ide.beanflow.model.Reference;
import jp.nimbus.ide.beanflow.model.ReferenceType;
import jp.nimbus.ide.beanflow.model.StaticInvocation;
import jp.nimbus.ide.xml.util.DocumentUtil;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Result
extends Reference {
    private static final String TAG_THIS = "this";
    private static final String TAG_FIELD = "field";
    private static final String TAG_ATTRIBUTE = "attribute";
    private static final String TAG_INVOKE = "invoke";
    private static final String TAG_STATIC_INVOKE = "static-invoke";
    public static final String VALUE = "_value";
    public static final String ATTRIBUTE = "_attribute";
    public static final String INVOCATION = "_invocation";
    public static final String STATIC_INVOCATION = "_static_invocation";

    public Result(Element node) {
        super(node);
    }

    public String getValue() {
        String value = null;
        if (this.getReferenceType() == ReferenceType.Text) {
            Text text = DocumentUtil.getFirstTextNode(this.node);
            value = text.getNodeValue();
        }
        return value;
    }

    public void setValue(ReferenceType resultType, String valueExp) {
        DocumentUtil.removeChildren(this.node);
        if (resultType == ReferenceType.Text) {
            Text text = this.node.getOwnerDocument().createTextNode(valueExp);
            this.node.appendChild(text);
        } else if (resultType == ReferenceType.This) {
            Element element = DocumentUtil.createElement(this.node, TAG_THIS);
            this.node.appendChild(element);
        }
        this.firePropertyChange(VALUE, null, valueExp);
    }

    public List<Object> getInvocationList() {
        ArrayList<Object> invocationList = new ArrayList<Object>();
        NodeList children = this.node.getChildNodes();
        int childrenSize = children.getLength();
        int i = 0;
        while (i < childrenSize) {
            Node childNode = children.item(i);
            if (childNode.getNodeType() == 1) {
                Element childElement = (Element)childNode;
                String nodeName = childElement.getNodeName();
                if (nodeName.equals(TAG_ATTRIBUTE) || nodeName.equals(TAG_FIELD)) {
                    invocationList.add(new Attribute(childElement));
                } else if (nodeName.equals(TAG_INVOKE)) {
                    invocationList.add(new Invocation(childElement));
                } else if (nodeName.equals(TAG_STATIC_INVOKE)) {
                    invocationList.add(new StaticInvocation(childElement));
                }
            }
            ++i;
        }
        return invocationList;
    }

    public Attribute createAttribute() {
        Element childNode = DocumentUtil.createElement(this.node, TAG_ATTRIBUTE);
        return new Attribute(childNode);
    }

    public void addAttribute(Attribute attribute) {
        this.node.appendChild(attribute.getNode());
        this.firePropertyChange(ATTRIBUTE, null, attribute);
    }

    public void removeAttribute(Attribute attribute) {
        this.node.removeChild(attribute.getNode());
        this.firePropertyChange(ATTRIBUTE, attribute, null);
    }

    public Invocation createInvocation() {
        Element childNode = DocumentUtil.createElement(this.node, TAG_INVOKE);
        return new Invocation(childNode);
    }

    public void addInvocation(Invocation invocation) {
        this.node.appendChild(invocation.getNode());
        this.firePropertyChange(INVOCATION, null, invocation);
    }

    public void removeInvocation(Invocation invocation) {
        this.node.removeChild(invocation.getNode());
        this.firePropertyChange(INVOCATION, invocation, null);
    }

    public StaticInvocation createStaticInvocation() {
        Element childNode = DocumentUtil.createElement(this.node, TAG_STATIC_INVOKE);
        return new StaticInvocation(childNode);
    }

    public void addStaticInvocation(StaticInvocation staticInvocation) {
        this.node.appendChild(staticInvocation.getNode());
        this.firePropertyChange(STATIC_INVOCATION, null, staticInvocation);
    }

    public void removeStaticInvocation(StaticInvocation staticInvocation) {
        this.node.removeChild(staticInvocation.getNode());
        this.firePropertyChange(STATIC_INVOCATION, staticInvocation, null);
    }
}

