/*
 * Decompiled with CFR 0.152.
 */
package jp.nimbus.ide.beanflow.util;

import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import jp.nimbus.ide.Activator;
import jp.nimbus.ide.ParseException;
import jp.nimbus.ide.util.ProjectElementsManager;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FlowDescriptionManager
extends ProjectElementsManager<String> {
    private XPathExpression flowNameXPath;
    private boolean searchTerminated = false;
    private String result = null;

    public FlowDescriptionManager(String flowName) {
        try {
            this.flowNameXPath = Activator.xPath.compile("flow[@name='" + flowName + "']");
        }
        catch (XPathExpressionException e) {
            e.printStackTrace();
        }
    }

    @Override
    protected void searchDocument(Element rootElement) {
        Node flowNode = null;
        try {
            flowNode = (Node)this.flowNameXPath.evaluate(rootElement, XPathConstants.NODE);
        }
        catch (XPathExpressionException e) {
            throw new ParseException(e);
        }
        if (flowNode != null) {
            Node prevNode = flowNode.getPreviousSibling();
            this.result = this.internalSearchDocument(prevNode);
            this.searchTerminated = true;
        }
    }

    private String internalSearchDocument(Node node) {
        String result = null;
        if (node != null) {
            if (node.getNodeType() == 3) {
                result = this.internalSearchDocument(node.getPreviousSibling());
            } else if (node.getNodeType() == 8 && (result = node.getNodeValue()) != null) {
                result = result.trim();
            }
        }
        return result;
    }

    @Override
    protected boolean isCreatedResult() {
        return this.searchTerminated;
    }

    @Override
    protected String getResult() {
        return this.result;
    }
}

