/*
 * Decompiled with CFR 0.152.
 */
package jp.nimbus.ide.beanflow.wizard;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import jp.nimbus.ide.beanflow.editor.BeanFlowEditor;
import jp.nimbus.ide.beanflow.wizard.BeanFlowWizardPage;
import jp.nimbus.ide.util.ErrorHandler;
import jp.nimbus.ide.xml.util.DocumentUtil;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.FileEditorInput;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class BeanFlowWizard
extends Wizard
implements INewWizard {
    private BeanFlowWizardPage page;
    private ISelection selection;

    public BeanFlowWizard() {
        this.setNeedsProgressMonitor(true);
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.selection = selection;
    }

    public void addPages() {
        this.page = new BeanFlowWizardPage(this.selection);
        this.addPage((IWizardPage)this.page);
    }

    public boolean performFinish() {
        final String containerName = this.page.getContainerName();
        final String fileName = this.page.getFileName();
        final String beanflowName = this.page.getBeanflowName();
        IRunnableWithProgress op = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException {
                try {
                    try {
                        BeanFlowWizard.this.doFinish(containerName, fileName, beanflowName, monitor);
                    }
                    catch (CoreException e) {
                        throw new InvocationTargetException(e);
                    }
                }
                finally {
                    monitor.done();
                }
            }
        };
        try {
            this.getContainer().run(true, false, op);
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
        catch (InvocationTargetException e) {
            ErrorHandler.handle(this.getShell(), (Exception)e.getTargetException());
            return false;
        }
        return true;
    }

    private void doFinish(String containerName, String fileName, String beanflowName, IProgressMonitor monitor) throws CoreException {
        monitor.beginTask("Creating " + fileName, 2);
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IResource resource = root.findMember((IPath)new Path(containerName));
        if (!resource.exists() || !(resource instanceof IContainer)) {
            this.throwCoreException("Container \"" + containerName + "\" does not exist.");
        }
        IContainer container = (IContainer)resource;
        final IFile file = container.getFile((IPath)new Path(fileName));
        try {
            InputStream stream = this.openContentStream(container, beanflowName);
            if (file.exists()) {
                file.setContents(stream, true, true, monitor);
            } else {
                file.create(stream, true, monitor);
            }
            stream.close();
        }
        catch (IOException iOException) {}
        monitor.worked(1);
        monitor.setTaskName("Opening file for editing...");
        this.getShell().getDisplay().asyncExec(new Runnable(){

            public void run() {
                IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                try {
                    page.openEditor((IEditorInput)new FileEditorInput(file), BeanFlowEditor.EDITOR_ID);
                }
                catch (PartInitException partInitException) {}
            }
        });
        monitor.worked(1);
    }

    private InputStream openContentStream(IContainer container, String beanflowName) {
        ByteArrayInputStream inputStream = null;
        String contents = null;
        try {
            Document document = DocumentUtil.create();
            Element flows = document.createElement("flows");
            Element flow = document.createElement("flow");
            flow.setAttribute("name", beanflowName);
            flows.appendChild(flow);
            document.appendChild(flows);
            String charset = container.getDefaultCharset();
            contents = DocumentUtil.convert(document, charset);
        }
        catch (Exception e) {
            ErrorHandler.handle(this.getShell(), e);
        }
        if (contents != null) {
            inputStream = new ByteArrayInputStream(contents.getBytes());
        }
        return inputStream;
    }

    private void throwCoreException(String message) throws CoreException {
        Status status = new Status(4, "jp.nimbus.ide", 0, message, null);
        throw new CoreException((IStatus)status);
    }
}

