/*
 * Decompiled with CFR 0.152.
 */
package jp.nimbus.ide.dialog;

import java.util.Arrays;
import java.util.Comparator;
import java.util.regex.Pattern;
import jp.nimbus.ide.Resources;
import jp.nimbus.ide.util.TypeUtil;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;

public class InvocationSelectionDialog
extends ElementTreeSelectionDialog {
    private static final int CHAR_WIDTH = 30;
    private static final int CHAR_HEIGHT = 18;
    private static final String TITLE = "\u547c\u51fa\u3057\u5bfe\u8c61\u306e\u9078\u629e";
    private static final String MESSAGE = "\u547c\u51fa\u3057\u5bfe\u8c61\u3092\u9078\u629e\u3057\u3066\u304f\u3060\u3055\u3044\u3002";
    private static final char PARAMETER_BEGIN = '(';
    private static final char PARAMETER_END = ')';
    private static final char PARAMETER_DELIMITER = ',';
    private static final String LABEL_INDEXER = "\u30a4\u30f3\u30c7\u30af\u30b5";
    private InvocationType invocationType;
    private Text indexerText;
    private String indexerExpression;
    private static Pattern digitPattern = Pattern.compile("[0-9]+");

    public InvocationSelectionDialog(Shell parent, InvocationType invocationType, String typeFqn) {
        super(parent, (ILabelProvider)new LabelProvider(invocationType), (ITreeContentProvider)new TreeContentProvider(invocationType));
        this.invocationType = invocationType;
        this.setSize(30, 18);
        this.setTitle(TITLE);
        this.setMessage(MESSAGE);
        this.setInput(typeFqn);
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        if (this.invocationType == InvocationType.Property) {
            Composite indexerPanel = new Composite(composite, 0);
            indexerPanel.setLayoutData((Object)new GridData(768));
            indexerPanel.setLayout((Layout)new GridLayout(2, false));
            Label label = new Label(indexerPanel, 0);
            label.setText(LABEL_INDEXER);
            this.indexerText = new Text(indexerPanel, 2048);
            this.indexerText.setLayoutData((Object)new GridData(768));
            this.indexerText.setEditable(false);
        }
        this.getTreeViewer().addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                StructuredSelection structuredSelection;
                IMethod method;
                if (InvocationSelectionDialog.this.invocationType == InvocationType.Property && (method = (IMethod)(structuredSelection = (StructuredSelection)event.getSelection()).getFirstElement()) != null) {
                    String[] parameterTypes = method.getParameterTypes();
                    if (parameterTypes.length == 2) {
                        InvocationSelectionDialog.this.indexerText.setText("");
                        InvocationSelectionDialog.this.indexerText.setEditable(true);
                        InvocationSelectionDialog.this.indexerText.setFocus();
                    } else {
                        InvocationSelectionDialog.this.indexerText.setText("");
                        InvocationSelectionDialog.this.indexerText.setEditable(false);
                    }
                }
            }
        });
        return composite;
    }

    protected void computeResult() {
        String text;
        super.computeResult();
        if (this.indexerText != null && (text = this.indexerText.getText()) != null && text.length() > 0) {
            this.indexerExpression = digitPattern.matcher(text).matches() ? "[" + text + "]" : "(" + text + ")";
        }
    }

    public String getIndexerExpression() {
        return this.indexerExpression;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum InvocationType {
        Property,
        Method,
        StaticMethod;

    }

    private static class LabelProvider
    extends org.eclipse.jface.viewers.LabelProvider {
        private InvocationType invocationType;

        public LabelProvider(InvocationType invocationType) {
            this.invocationType = invocationType;
        }

        public Image getImage(Object element) {
            return Resources.getImage("_icon_member");
        }

        public String getText(Object element) {
            StringBuilder stringBuilder = new StringBuilder();
            IMethod method = (IMethod)element;
            String methodName = method.getElementName();
            if (this.invocationType == InvocationType.Property) {
                methodName = methodName.substring("set".length());
            }
            stringBuilder.append(methodName);
            stringBuilder.append('(');
            String[] paramSignatures = method.getParameterTypes();
            int paramLength = paramSignatures.length;
            int i = 0;
            while (i < paramLength) {
                String fqn = Signature.toString((String)paramSignatures[i]);
                stringBuilder.append(fqn.substring(fqn.lastIndexOf(46) + 1));
                if (i != paramLength - 1) {
                    stringBuilder.append(',');
                }
                ++i;
            }
            stringBuilder.append(')');
            return stringBuilder.toString();
        }
    }

    private static class TreeContentProvider
    implements ITreeContentProvider {
        private InvocationType invocationType;

        public TreeContentProvider(InvocationType invocationType) {
            this.invocationType = invocationType;
        }

        public Object[] getElements(Object inputElement) {
            String typeFqn = (String)inputElement;
            Object[] methods = null;
            switch (this.invocationType) {
                case Property: {
                    methods = TypeUtil.findProperties(typeFqn);
                    break;
                }
                case Method: {
                    methods = TypeUtil.findMethods(typeFqn);
                    break;
                }
                case StaticMethod: {
                    methods = TypeUtil.findStaticMethods(typeFqn);
                }
            }
            Arrays.sort(methods, new Comparator<IMethod>(){

                @Override
                public int compare(IMethod o1, IMethod o2) {
                    return o1.getElementName().compareTo(o2.getElementName());
                }
            });
            return methods;
        }

        public Object getParent(Object element) {
            return null;
        }

        public boolean hasChildren(Object element) {
            return false;
        }

        public Object[] getChildren(Object parentElement) {
            return null;
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public void dispose() {
        }
    }
}

