/*
 * Decompiled with CFR 0.152.
 */
package jp.nimbus.ide.editpart;

import jp.nimbus.ide.model.Connection;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.PolylineConnection;
import org.eclipse.draw2d.PolylineDecoration;
import org.eclipse.draw2d.RotatableDecoration;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.editparts.AbstractConnectionEditPart;
import org.eclipse.gef.editpolicies.ConnectionEndpointEditPolicy;
import org.eclipse.gef.requests.GroupRequest;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.widgets.Display;

public class ConnectionEditPart
extends AbstractConnectionEditPart {
    protected IFigure createFigure() {
        PolylineConnection connection = new PolylineConnection(){

            public void paintFigure(Graphics graphics) {
                graphics.setAntialias(1);
                graphics.setForegroundColor(new Color((Device)Display.getCurrent(), 128, 128, 128));
                super.paintFigure(graphics);
            }
        };
        PolylineDecoration decoration = new PolylineDecoration(){

            public void paintFigure(Graphics graphics) {
                graphics.setAntialias(1);
                graphics.setForegroundColor(new Color((Device)Display.getCurrent(), 128, 128, 128));
                super.paintFigure(graphics);
            }
        };
        connection.setTargetDecoration((RotatableDecoration)decoration);
        return connection;
    }

    protected void createEditPolicies() {
        this.installEditPolicy("ConnectionEditPolicy", (EditPolicy)new ConnectionEditPolicy());
        this.installEditPolicy("Connection Endpoint Policy", (EditPolicy)new ConnectionEndpointEditPolicy());
    }

    private class ConnectionEditPolicy
    extends org.eclipse.gef.editpolicies.ConnectionEditPolicy {
        private ConnectionEditPolicy() {
        }

        protected Command getDeleteCommand(GroupRequest request) {
            Connection connection = (Connection)this.getHost().getModel();
            return new DeleteCommand(connection);
        }
    }

    private class DeleteCommand
    extends Command {
        private Connection connection;

        public DeleteCommand(Connection connection) {
            this.connection = connection;
        }

        public void execute() {
            this.connection.detachSource();
            this.connection.detachTarget();
        }

        public void undo() {
            this.connection.attachSource();
            this.connection.attachTarget();
        }
    }
}

