/*
 * Decompiled with CFR 0.152.
 */
package jp.nimbus.ide.widget;

import jp.nimbus.ide.widget.EditableTableViewer;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;

public class ListViewer
extends EditableTableViewer {
    private static final String FIELD_DELIMITER = ",";

    public ListViewer(Composite parent, String input) {
        super(parent, input);
        this.setupTable();
    }

    public String getOutput() {
        StringBuilder stringBuilder = new StringBuilder();
        TableItem[] tableItemArray = this.getTable().getItems();
        int n = tableItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TableItem tableItem = tableItemArray[n2];
            stringBuilder.append(tableItem.getData());
            stringBuilder.append(FIELD_DELIMITER);
            ++n2;
        }
        int length = stringBuilder.length();
        stringBuilder.delete(length - FIELD_DELIMITER.length(), length);
        return stringBuilder.toString();
    }

    private void setupTable() {
        final Table table = this.getTable();
        table.setLinesVisible(true);
        MenuManager menuManager = new MenuManager();
        menuManager.add((IAction)new Action("\u8ffd\u52a0"){

            public void run() {
                int newIndex = table.getItemCount();
                table.setItemCount(newIndex + 1);
                TableItem tableItem = table.getItem(newIndex);
                tableItem.setData((Object)"");
            }
        });
        menuManager.add((IAction)new Action("\u524a\u9664"){

            public void run() {
                table.remove(table.getSelectionIndex());
            }
        });
        table.setMenu(menuManager.createContextMenu((Control)table));
        TableColumn column = new TableColumn(table, 16384);
        column.setWidth(400);
        this.setColumnProperties(new String[]{"value"});
        CellEditor[] cellEditors = new CellEditor[]{new TextCellEditor((Composite)table)};
        this.setCellEditors(cellEditors);
        this.setCellModifier(new CellModifier(this));
        this.setLabelProvider((IBaseLabelProvider)new TableLabelProvider());
        this.setContentProvider((IContentProvider)new TableContentProvider());
        this.setInput(this.input);
    }

    private class CellModifier
    implements ICellModifier {
        private TableViewer tableViewer;

        public CellModifier(TableViewer tableViewer) {
            this.tableViewer = tableViewer;
        }

        public boolean canModify(Object element, String property) {
            return true;
        }

        public Object getValue(Object element, String property) {
            return (String)element;
        }

        public void modify(Object element, String property, Object value) {
            TableItem tableItem = (TableItem)element;
            tableItem.setData(value);
            this.tableViewer.update(value, null);
        }
    }

    private class TableContentProvider
    implements IStructuredContentProvider {
        private TableContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            Object[] fields = ((String)inputElement).trim().split(ListViewer.FIELD_DELIMITER);
            int i = 0;
            while (i < fields.length) {
                fields[i] = ((String)fields[i]).trim();
                ++i;
            }
            return fields;
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public void dispose() {
        }
    }

    private class TableLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        private TableLabelProvider() {
        }

        public String getColumnText(Object element, int columnIndex) {
            return (String)element;
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }
    }
}

