/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.aop.interceptor.servlet;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import jp.ossc.nimbus.core.ServiceManagerFactory;
import jp.ossc.nimbus.core.ServiceName;
import jp.ossc.nimbus.service.aop.InterceptorChain;
import jp.ossc.nimbus.service.aop.ServletFilterInvocationContext;
import jp.ossc.nimbus.service.aop.interceptor.servlet.ServletFilterInterceptorService;
import jp.ossc.nimbus.service.aop.interceptor.servlet.StreamExchangeInterceptorServiceMBean;
import jp.ossc.nimbus.service.context.Context;
import jp.ossc.nimbus.service.journal.Journal;
import jp.ossc.nimbus.service.journal.editorfinder.EditorFinder;
import jp.ossc.nimbus.util.converter.StreamConverter;

public class StreamExchangeInterceptorService
extends ServletFilterInterceptorService
implements StreamExchangeInterceptorServiceMBean {
    private static final long serialVersionUID = 7618395554145055608L;
    protected ServiceName requestStreamConverterServiceName;
    protected StreamConverter requestStreamConverter;
    protected ServiceName responseStreamConverterServiceName;
    protected StreamConverter responseStreamConverter;
    protected ServiceName threadContextServiceName;
    protected Context threadContext;
    protected ServiceName journalServiceName;
    protected Journal journal;
    protected ServiceName exchangeEditorFinderServiceName;
    protected EditorFinder exchangeEditorFinder;
    protected ServiceName exchangeRequestEditorFinderServiceName;
    protected EditorFinder exchangeRequestEditorFinder;
    protected ServiceName exchangeResponseEditorFinderServiceName;
    protected EditorFinder exchangeResponseEditorFinder;
    protected ServiceName requestBytesEditorFinderServiceName;
    protected EditorFinder requestBytesEditorFinder;
    protected ServiceName requestObjectEditorFinderServiceName;
    protected EditorFinder requestObjectEditorFinder;
    protected ServiceName responseBytesEditorFinderServiceName;
    protected EditorFinder responseBytesEditorFinder;
    protected ServiceName responseObjectEditorFinderServiceName;
    protected EditorFinder responseObjectEditorFinder;
    protected ServiceName exceptionEditorFinderServiceName;
    protected EditorFinder exceptionEditorFinder;
    protected String responseContentType;
    protected String requestObjectAttributeName = DEFAULT_REQUEST_OBJECT_ATTRIBUTE_NAME;
    protected String responseObjectAttributeName = DEFAULT_RESPONSE_OBJECT_ATTRIBUTE_NAME;
    protected String requestObjectContextKey = DEFAULT_REQUEST_OBJECT_CONTEXT_KEY;
    protected String responseObjectContextKey = DEFAULT_RESPONSE_OBJECT_CONTEXT_KEY;
    protected String exchangeJournalKey = "Exchange";
    protected String exchangeRequestJournalKey = "Request";
    protected String exchangeResponseJournalKey = "Response";
    protected String requestBytesJournalKey = "RequestBytes";
    protected String requestObjectJournalKey = "RequestObject";
    protected String responseBytesJournalKey = "ResponseBytes";
    protected String responseObjectJournalKey = "ResponseObject";
    protected String exceptionJournalKey = "Exception";

    public void setRequestStreamConverterServiceName(ServiceName name) {
        this.requestStreamConverterServiceName = name;
    }

    public ServiceName getRequestStreamConverterServiceName() {
        return this.requestStreamConverterServiceName;
    }

    public void setResponseStreamConverterServiceName(ServiceName name) {
        this.responseStreamConverterServiceName = name;
    }

    public ServiceName getResponseStreamConverterServiceName() {
        return this.responseStreamConverterServiceName;
    }

    public void setThreadContextServiceName(ServiceName name) {
        this.threadContextServiceName = name;
    }

    public ServiceName getThreadContextServiceName() {
        return this.threadContextServiceName;
    }

    public void setJournalServiceName(ServiceName name) {
        this.journalServiceName = name;
    }

    public ServiceName getJournalServiceName() {
        return this.journalServiceName;
    }

    public void setExchangeEditorFinderServiceName(ServiceName name) {
        this.exchangeEditorFinderServiceName = name;
    }

    public ServiceName getExchangeEditorFinderServiceName() {
        return this.exchangeEditorFinderServiceName;
    }

    public void setExchangeRequestEditorFinderServiceName(ServiceName name) {
        this.exchangeRequestEditorFinderServiceName = name;
    }

    public ServiceName getExchangeRequestEditorFinderServiceName() {
        return this.exchangeRequestEditorFinderServiceName;
    }

    public void setExchangeResponseEditorFinderServiceName(ServiceName name) {
        this.exchangeResponseEditorFinderServiceName = name;
    }

    public ServiceName getExchangeResponseEditorFinderServiceName() {
        return this.exchangeResponseEditorFinderServiceName;
    }

    public void setRequestBytesEditorFinderServiceName(ServiceName name) {
        this.requestBytesEditorFinderServiceName = name;
    }

    public ServiceName getRequestBytesEditorFinderServiceName() {
        return this.requestBytesEditorFinderServiceName;
    }

    public void setRequestObjectEditorFinderServiceName(ServiceName name) {
        this.requestObjectEditorFinderServiceName = name;
    }

    public ServiceName getRequestObjectEditorFinderServiceName() {
        return this.requestObjectEditorFinderServiceName;
    }

    public void setResponseBytesEditorFinderServiceName(ServiceName name) {
        this.responseBytesEditorFinderServiceName = name;
    }

    public ServiceName getResponseBytesEditorFinderServiceName() {
        return this.responseBytesEditorFinderServiceName;
    }

    public void setResponseObjectEditorFinderServiceName(ServiceName name) {
        this.responseObjectEditorFinderServiceName = name;
    }

    public ServiceName getResponseObjectEditorFinderServiceName() {
        return this.responseObjectEditorFinderServiceName;
    }

    public void setExceptionEditorFinderServiceName(ServiceName name) {
        this.exceptionEditorFinderServiceName = name;
    }

    public ServiceName getExceptionEditorFinderServiceName() {
        return this.exceptionEditorFinderServiceName;
    }

    public void setResponseContentType(String type) {
        this.responseContentType = type;
    }

    public String getResponseContentType() {
        return this.responseContentType;
    }

    public void setRequestObjectAttributeName(String name) {
        this.requestObjectAttributeName = name;
    }

    public String getRequestObjectAttributeName() {
        return this.requestObjectAttributeName;
    }

    public void setResponseObjectAttributeName(String name) {
        this.responseObjectAttributeName = name;
    }

    public String getResponseObjectAttributeName() {
        return this.responseObjectAttributeName;
    }

    public void setRequestObjectContextKey(String key) {
        this.requestObjectContextKey = key;
    }

    public String getRequestObjectContextKey() {
        return this.requestObjectContextKey;
    }

    public void setResponseObjectContextKey(String key) {
        this.responseObjectContextKey = key;
    }

    public String getResponseObjectContextKey() {
        return this.responseObjectContextKey;
    }

    public void setExchangeJournalKey(String key) {
        this.exchangeJournalKey = key;
    }

    public String getExchangeJournalKey() {
        return this.exchangeJournalKey;
    }

    public void setExchangeRequestJournalKey(String key) {
        this.exchangeRequestJournalKey = key;
    }

    public String getExchangeRequestJournalKey() {
        return this.exchangeRequestJournalKey;
    }

    public void setExchangeResponseJournalKey(String key) {
        this.exchangeResponseJournalKey = key;
    }

    public String getExchangeResponseJournalKey() {
        return this.exchangeResponseJournalKey;
    }

    public void setRequestBytesJournalKey(String key) {
        this.requestBytesJournalKey = key;
    }

    public String getRequestBytesJournalKey() {
        return this.requestBytesJournalKey;
    }

    public void setRequestObjectJournalKey(String key) {
        this.requestObjectJournalKey = key;
    }

    public String getRequestObjectJournalKey() {
        return this.requestObjectJournalKey;
    }

    public void setResponseBytesJournalKey(String key) {
        this.responseBytesJournalKey = key;
    }

    public String getResponseBytesJournalKey() {
        return this.responseBytesJournalKey;
    }

    public void setResponseObjectJournalKey(String key) {
        this.responseObjectJournalKey = key;
    }

    public String getResponseObjectJournalKey() {
        return this.responseObjectJournalKey;
    }

    public void setExceptionJournalKey(String key) {
        this.exceptionJournalKey = key;
    }

    public String getExceptionJournalKey() {
        return this.exceptionJournalKey;
    }

    public void startService() throws Exception {
        if (this.requestStreamConverterServiceName == null && this.requestStreamConverter == null) {
            throw new IllegalArgumentException("It is necessary to specify RequestStreamConverterServiceName or RequestStreamConverter.");
        }
        if (this.requestStreamConverterServiceName != null) {
            this.requestStreamConverter = (StreamConverter)ServiceManagerFactory.getServiceObject(this.requestStreamConverterServiceName);
        }
        if (this.responseStreamConverterServiceName == null && this.responseStreamConverter == null) {
            throw new IllegalArgumentException("It is necessary to specify ResponseStreamConverterServiceName or ResponseStreamConverter.");
        }
        if (this.responseStreamConverterServiceName != null) {
            this.responseStreamConverter = (StreamConverter)ServiceManagerFactory.getServiceObject(this.responseStreamConverterServiceName);
        }
        if (this.threadContextServiceName != null) {
            this.threadContext = (Context)ServiceManagerFactory.getServiceObject(this.threadContextServiceName);
        }
        if (this.journalServiceName != null) {
            this.journal = (Journal)ServiceManagerFactory.getServiceObject(this.journalServiceName);
        }
        if (this.exchangeEditorFinderServiceName != null) {
            this.exchangeEditorFinder = (EditorFinder)ServiceManagerFactory.getServiceObject(this.exchangeEditorFinderServiceName);
        }
        if (this.exchangeRequestEditorFinderServiceName != null) {
            this.exchangeRequestEditorFinder = (EditorFinder)ServiceManagerFactory.getServiceObject(this.exchangeRequestEditorFinderServiceName);
        }
        if (this.exchangeResponseEditorFinderServiceName != null) {
            this.exchangeResponseEditorFinder = (EditorFinder)ServiceManagerFactory.getServiceObject(this.exchangeResponseEditorFinderServiceName);
        }
        if (this.requestBytesEditorFinderServiceName != null) {
            this.requestBytesEditorFinder = (EditorFinder)ServiceManagerFactory.getServiceObject(this.requestBytesEditorFinderServiceName);
        }
        if (this.requestObjectEditorFinderServiceName != null) {
            this.requestObjectEditorFinder = (EditorFinder)ServiceManagerFactory.getServiceObject(this.requestObjectEditorFinderServiceName);
        }
        if (this.responseBytesEditorFinderServiceName != null) {
            this.responseBytesEditorFinder = (EditorFinder)ServiceManagerFactory.getServiceObject(this.responseBytesEditorFinderServiceName);
        }
        if (this.responseObjectEditorFinderServiceName != null) {
            this.responseObjectEditorFinder = (EditorFinder)ServiceManagerFactory.getServiceObject(this.responseObjectEditorFinderServiceName);
        }
        if (this.exceptionEditorFinderServiceName != null) {
            this.exceptionEditorFinder = (EditorFinder)ServiceManagerFactory.getServiceObject(this.exceptionEditorFinderServiceName);
        }
    }

    public void setRequestStreamConverter(StreamConverter conv) {
        this.requestStreamConverter = conv;
    }

    public StreamConverter getRequestStreamConverter() {
        return this.requestStreamConverter;
    }

    public void setResponseStreamConverter(StreamConverter conv) {
        this.responseStreamConverter = conv;
    }

    public StreamConverter getResponseStreamConverter() {
        return this.responseStreamConverter;
    }

    public void setThreadContext(Context context) {
        this.threadContext = context;
    }

    public Context getThreadContext() {
        return this.threadContext;
    }

    public void setJournal(Journal journal) {
        this.journal = journal;
    }

    public Journal getJournal() {
        return this.journal;
    }

    public void setExchangeEditorFinder(EditorFinder finder) {
        this.exchangeEditorFinder = finder;
    }

    public EditorFinder getExchangeEditorFinder() {
        return this.exchangeEditorFinder;
    }

    public void setExchangeRequestEditorFinder(EditorFinder finder) {
        this.exchangeRequestEditorFinder = finder;
    }

    public EditorFinder getExchangeRequestEditorFinder() {
        return this.exchangeRequestEditorFinder;
    }

    public void setExchangeResponseEditorFinder(EditorFinder finder) {
        this.exchangeResponseEditorFinder = finder;
    }

    public EditorFinder getExchangeResponseEditorFinder() {
        return this.exchangeResponseEditorFinder;
    }

    public void setRequestBytesEditorFinder(EditorFinder finder) {
        this.requestBytesEditorFinder = finder;
    }

    public EditorFinder getRequestBytesEditorFinder() {
        return this.requestBytesEditorFinder;
    }

    public void setRequestObjectEditorFinder(EditorFinder finder) {
        this.requestObjectEditorFinder = finder;
    }

    public EditorFinder getRequestObjectEditorFinder() {
        return this.requestObjectEditorFinder;
    }

    public void setResponseBytesEditorFinder(EditorFinder finder) {
        this.responseBytesEditorFinder = finder;
    }

    public EditorFinder getResponseBytesEditorFinder() {
        return this.responseBytesEditorFinder;
    }

    public void setResponseObjectEditorFinder(EditorFinder finder) {
        this.responseObjectEditorFinder = finder;
    }

    public EditorFinder getResponseObjectEditorFinder() {
        return this.responseObjectEditorFinder;
    }

    public void setExceptionEditorFinder(EditorFinder finder) {
        this.exceptionEditorFinder = finder;
    }

    public EditorFinder getExceptionEditorFinder() {
        return this.exceptionEditorFinder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object invokeFilter(ServletFilterInvocationContext context, InterceptorChain chain) throws Throwable {
        if (this.getState() != 3) {
            return chain.invokeNext(context);
        }
        try {
            if (this.journal != null) {
                this.journal.startJournal(this.exchangeJournalKey, this.exchangeEditorFinder);
            }
            ServletRequest request = context.getServletRequest();
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            byte[] bytes = new byte[2048];
            try {
                if (this.journal != null) {
                    this.journal.addStartStep(this.exchangeRequestJournalKey, this.exchangeRequestEditorFinder);
                }
                ServletInputStream sis = request.getInputStream();
                try {
                    int size = 0;
                    while ((size = sis.read(bytes)) != -1) {
                        baos.write(bytes, 0, size);
                    }
                }
                finally {
                    if (sis != null) {
                        sis.close();
                    }
                }
                if (this.journal != null) {
                    this.journal.addInfo(this.requestBytesJournalKey, (Object)baos.toByteArray(), this.requestBytesEditorFinder);
                }
                Object requestObj = this.requestStreamConverter.convertToObject(new ByteArrayInputStream(baos.toByteArray()));
                if (this.journal != null) {
                    this.journal.addInfo(this.requestObjectJournalKey, requestObj, this.requestObjectEditorFinder);
                }
                request.setAttribute(this.requestObjectAttributeName, requestObj);
                Object var10_12 = null;
                if (this.journal != null) {
                    this.journal.addEndStep();
                }
            }
            catch (Throwable throwable) {
                Object var10_13 = null;
                if (this.journal != null) {
                    this.journal.addEndStep();
                }
                throw throwable;
            }
            Object ret = chain.invokeNext(context);
            ServletResponse response = context.getServletResponse();
            if (!response.isCommitted()) {
                try {
                    if (this.journal != null) {
                        this.journal.addStartStep(this.exchangeResponseJournalKey, this.exchangeResponseEditorFinder);
                    }
                    if (this.responseContentType != null) {
                        response.setContentType(this.responseContentType);
                    }
                    Object responseObj = request.getAttribute(this.responseObjectAttributeName);
                    if (this.journal != null) {
                        this.journal.addInfo(this.responseObjectJournalKey, responseObj, this.responseObjectEditorFinder);
                    }
                    if (responseObj != null) {
                        InputStream is = this.responseStreamConverter.convertToStream(responseObj);
                        ServletOutputStream sos = response.getOutputStream();
                        int readLen = 0;
                        baos.reset();
                        while ((readLen = is.read(bytes)) != -1) {
                            baos.write(bytes, 0, readLen);
                            sos.write(bytes, 0, readLen);
                        }
                        if (this.journal != null) {
                            this.journal.addInfo(this.responseBytesJournalKey, (Object)baos.toByteArray(), this.responseBytesEditorFinder);
                        }
                    }
                    Object var13_17 = null;
                    if (this.journal != null) {
                        this.journal.addEndStep();
                    }
                }
                catch (Throwable throwable) {
                    Object var13_18 = null;
                    if (this.journal != null) {
                        this.journal.addEndStep();
                    }
                    throw throwable;
                }
            }
            Object object = ret;
            Object var15_20 = null;
            if (this.journal != null) {
                this.journal.endJournal();
            }
            return object;
        }
        catch (Throwable th) {
            try {
                if (this.journal != null) {
                    this.journal.addInfo(this.exceptionJournalKey, (Object)th, this.exceptionEditorFinder);
                }
                throw th;
            }
            catch (Throwable throwable) {
                block32: {
                    Object var15_21 = null;
                    if (this.journal == null) break block32;
                    this.journal.endJournal();
                }
                throw throwable;
            }
        }
    }
}

