/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.semaphore;

import java.io.Serializable;
import java.util.List;
import java.util.Vector;
import jp.ossc.nimbus.service.semaphore.Semaphore;

public class MemorySemaphore
implements Semaphore,
Serializable {
    protected volatile int mResourceCnt = -1;
    protected volatile int mInitialResource = -1;
    protected volatile boolean mFourceEndFlg = false;
    protected List sleepThreads = new Vector();
    protected volatile int waitCount;

    public boolean getResource(long timeOutMiliSecond) {
        return this.getResource(timeOutMiliSecond, -1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean getResource(long timeOutMiliSecond, int maxWaitCount) {
        block37: {
            boolean bl;
            block36: {
                boolean bl2;
                block35: {
                    boolean bl3;
                    block34: {
                        MemorySemaphore memorySemaphore;
                        boolean bl4;
                        block32: {
                            if (maxWaitCount > 0 && this.waitCount >= maxWaitCount) {
                                return false;
                            }
                            MemorySemaphore memorySemaphore2 = this;
                            synchronized (memorySemaphore2) {
                                ++this.waitCount;
                            }
                            long timeOutMs = -1L;
                            if (timeOutMiliSecond >= 0L) {
                                timeOutMs = timeOutMiliSecond;
                            }
                            Thread current = Thread.currentThread();
                            long processTime = 0L;
                            try {
                                while (timeOutMs <= 0L || timeOutMs > processTime) {
                                    if (this.mFourceEndFlg) {
                                        bl4 = false;
                                        Object var16_11 = null;
                                        memorySemaphore = this;
                                        break block32;
                                    }
                                    while (this.mResourceCnt == 0 && (timeOutMs < 0L || timeOutMs > processTime)) {
                                        long proc = 0L;
                                        if (timeOutMs > 0L) {
                                            proc = System.currentTimeMillis();
                                        }
                                        this.sleepThreads.add(current);
                                        try {
                                            Thread.sleep(timeOutMs > 0L ? timeOutMs - processTime : 500L);
                                        }
                                        catch (InterruptedException e) {
                                            Thread.interrupted();
                                            if (this.sleepThreads.contains(current) && this.mResourceCnt == 0) {
                                                boolean bl5 = false;
                                                Object var16_12 = null;
                                                MemorySemaphore memorySemaphore3 = this;
                                                synchronized (memorySemaphore3) {
                                                    --this.waitCount;
                                                    return bl5;
                                                }
                                            }
                                        }
                                        finally {
                                            this.sleepThreads.remove(current);
                                        }
                                        if (timeOutMs <= 0L) continue;
                                        proc = System.currentTimeMillis() - proc;
                                        processTime += proc;
                                    }
                                    MemorySemaphore memorySemaphore4 = this;
                                    synchronized (memorySemaphore4) {
                                        if (this.mResourceCnt > 0) {
                                            --this.mResourceCnt;
                                            bl3 = true;
                                            // MONITOREXIT @DISABLED, blocks:[1, 22, 11, 30] lbl55 : MonitorExitStatement: MONITOREXIT : var9_7
                                            break block34;
                                        }
                                        if (this.mFourceEndFlg) {
                                            bl2 = false;
                                            // MONITOREXIT @DISABLED, blocks:[1, 22, 11, 29] lbl60 : MonitorExitStatement: MONITOREXIT : var9_7
                                            break block35;
                                        }
                                        if (timeOutMs == 0L) {
                                            bl = false;
                                            // MONITOREXIT @DISABLED, blocks:[1, 22, 11, 28] lbl65 : MonitorExitStatement: MONITOREXIT : var9_7
                                            break block36;
                                        }
                                    }
                                }
                                break block37;
                            }
                            catch (Throwable throwable) {
                                Object var16_17 = null;
                                MemorySemaphore memorySemaphore5 = this;
                                synchronized (memorySemaphore5) {
                                    --this.waitCount;
                                    throw throwable;
                                }
                            }
                        }
                        synchronized (memorySemaphore) {
                            --this.waitCount;
                            return bl4;
                        }
                    }
                    Object var16_13 = null;
                    MemorySemaphore memorySemaphore = this;
                    synchronized (memorySemaphore) {
                        --this.waitCount;
                        return bl3;
                    }
                }
                Object var16_14 = null;
                MemorySemaphore memorySemaphore = this;
                synchronized (memorySemaphore) {
                    --this.waitCount;
                    return bl2;
                }
            }
            Object var16_15 = null;
            MemorySemaphore memorySemaphore = this;
            synchronized (memorySemaphore) {
                --this.waitCount;
                return bl;
            }
        }
        Object var16_16 = null;
        MemorySemaphore memorySemaphore = this;
        synchronized (memorySemaphore) {
            --this.waitCount;
            return false;
        }
    }

    public boolean getResource(int maxWaitCount) {
        return this.getResource(-1L, maxWaitCount);
    }

    public boolean getResource() {
        return this.getResource(-1L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void freeResource() {
        if (this.mResourceCnt < this.mInitialResource) {
            MemorySemaphore memorySemaphore = this;
            synchronized (memorySemaphore) {
                ++this.mResourceCnt;
            }
        }
        Thread sleepThread = null;
        List list = this.sleepThreads;
        synchronized (list) {
            if (this.sleepThreads.size() != 0) {
                sleepThread = (Thread)this.sleepThreads.remove(0);
            }
        }
        if (sleepThread != null) {
            sleepThread.interrupt();
        }
    }

    public int getResourceCapacity() {
        return this.mInitialResource;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setResourceCapacity(int capa) {
        MemorySemaphore memorySemaphore = this;
        synchronized (memorySemaphore) {
            if (this.mInitialResource == -1) {
                this.mInitialResource = capa;
                this.mResourceCnt = capa;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getResourceRemain() {
        int cnt;
        MemorySemaphore memorySemaphore = this;
        synchronized (memorySemaphore) {
            cnt = this.mResourceCnt;
        }
        return cnt;
    }

    public int getWaitingCount() {
        return this.waitCount;
    }

    public void release() {
        this.mFourceEndFlg = true;
        while (this.sleepThreads.size() != 0) {
            this.freeResource();
        }
    }

    public void accept() {
        this.mFourceEndFlg = false;
    }
}

