/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.sequence;

import java.util.ArrayList;
import java.util.ListIterator;
import jp.ossc.nimbus.core.ServiceBase;
import jp.ossc.nimbus.core.ServiceName;
import jp.ossc.nimbus.service.sequence.ConstSequenceVariable;
import jp.ossc.nimbus.service.sequence.ContextSequenceVariable;
import jp.ossc.nimbus.service.sequence.Sequence;
import jp.ossc.nimbus.service.sequence.SequenceVariable;
import jp.ossc.nimbus.service.sequence.SimpleSequenceVariable;
import jp.ossc.nimbus.service.sequence.StringSequenceServiceMBean;
import jp.ossc.nimbus.util.CsvArrayList;

public class StringSequenceService
extends ServiceBase
implements Sequence,
StringSequenceServiceMBean {
    protected ArrayList mSequenceNo = null;
    protected String mFormat = null;
    protected String mInitialNumber = "";
    protected boolean mInitialFlag = true;
    protected ServiceName contextServiceName;
    private static final String C_SEMICORON = ";";

    public void setFormat(String format) {
        this.mFormat = format;
    }

    public String getFormat() {
        return this.mFormat;
    }

    public void setContextServiceName(ServiceName name) {
        this.contextServiceName = name;
    }

    public ServiceName getContextServiceName() {
        return this.contextServiceName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startService() {
        StringSequenceService stringSequenceService = this;
        synchronized (stringSequenceService) {
            this.mInitialFlag = true;
            if (this.mSequenceNo == null) {
                CsvArrayList parser = new CsvArrayList();
                parser.split(this.mFormat, C_SEMICORON);
                this.mSequenceNo = new ArrayList();
                ListIterator iterator = parser.listIterator();
                while (iterator.hasNext()) {
                    String formatItem = (String)iterator.next();
                    SequenceVariable item = null;
                    item = formatItem.indexOf(",") != -1 ? new SimpleSequenceVariable(formatItem) : (formatItem.length() > 2 && formatItem.charAt(0) == '%' && formatItem.charAt(formatItem.length() - 1) == '%' ? new ContextSequenceVariable(formatItem, this.contextServiceName) : new ConstSequenceVariable(formatItem));
                    this.mSequenceNo.add(item);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopService() {
        StringSequenceService stringSequenceService = this;
        synchronized (stringSequenceService) {
            this.mSequenceNo = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String increment() {
        StringBuffer retStr = new StringBuffer();
        StringSequenceService stringSequenceService = this;
        synchronized (stringSequenceService) {
            SequenceVariable item;
            boolean isOverFlow;
            int maxCnt = this.mSequenceNo.size();
            for (int rCnt = --maxCnt; rCnt >= 0 && (isOverFlow = (item = (SequenceVariable)this.mSequenceNo.get(rCnt)).increment()); --rCnt) {
            }
            ListIterator iterator = this.mSequenceNo.listIterator();
            while (iterator.hasNext()) {
                item = (SequenceVariable)iterator.next();
                retStr.append(item.getCurrent());
            }
            if (this.mInitialFlag) {
                this.mInitialNumber = retStr.toString();
                this.mInitialFlag = false;
            }
        }
        return retStr.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() {
        StringSequenceService stringSequenceService = this;
        synchronized (stringSequenceService) {
            ListIterator iterator = this.mSequenceNo.listIterator();
            while (iterator.hasNext()) {
                SequenceVariable item = (SequenceVariable)iterator.next();
                item.clear();
            }
            this.mInitialFlag = true;
            this.mInitialNumber = "";
        }
    }

    public String getInitial() {
        return this.mInitialNumber;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getCurrent() {
        StringBuffer retStr = new StringBuffer();
        StringSequenceService stringSequenceService = this;
        synchronized (stringSequenceService) {
            ListIterator iterator = this.mSequenceNo.listIterator();
            while (iterator.hasNext()) {
                SequenceVariable item = (SequenceVariable)iterator.next();
                retStr.append(item.getCurrent());
            }
        }
        return retStr.toString();
    }
}

