/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.graph;

import java.awt.Image;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Properties;
import jp.ossc.nimbus.core.ServiceBase;
import jp.ossc.nimbus.service.graph.AbstractGraphCreatorServiceMBean;
import jp.ossc.nimbus.service.graph.GraphCreator;
import org.jfree.chart.ChartUtilities;
import org.jfree.chart.JFreeChart;
import org.jfree.data.general.Dataset;

public abstract class AbstractGraphCreatorService
extends ServiceBase
implements GraphCreator,
AbstractGraphCreatorServiceMBean {
    protected static final String FILE_SEPARATOR = System.getProperty("file.separator");
    protected Properties keyAndDataFileMapping;
    protected String graphTitle = "";
    protected String encoding;
    protected String saveDir;

    public void setKeyAndDataFileMapping(Properties mapping) {
        this.keyAndDataFileMapping = mapping;
    }

    public Properties getKeyAndDataFileMapping() {
        return this.keyAndDataFileMapping;
    }

    public void setEncoding(String enc) {
        this.encoding = enc;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setGraphTitle(String title) {
        this.graphTitle = title;
    }

    public String getGraphTitle() {
        return this.graphTitle;
    }

    public void setSaveDir(String dir) {
        this.saveDir = dir;
    }

    public String getSaveDir() {
        return this.saveDir;
    }

    public void startService() throws Exception {
        if (this.keyAndDataFileMapping == null) {
            throw new IllegalArgumentException("keyAndDataFileMapping is null");
        }
    }

    public JFreeChart createGraph(String key) throws Exception {
        Dataset ds = this.createDataset(key);
        if (ds == null) {
            return null;
        }
        return this.createGraph(key, ds);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Dataset createDataset(String key) throws Exception {
        FileInputStream fis = this.getInputFileInputStream(key);
        Dataset dataset = null;
        try {
            dataset = this.createDataset(key, this.encoding == null ? new InputStreamReader(fis) : new InputStreamReader((InputStream)fis, this.encoding));
        }
        finally {
            fis.close();
        }
        return dataset;
    }

    protected FileInputStream getInputFileInputStream(String key) throws Exception {
        if (this.keyAndDataFileMapping == null || !this.keyAndDataFileMapping.containsKey(key)) {
            return null;
        }
        String filePath = this.keyAndDataFileMapping.getProperty(key);
        File file = new File(filePath);
        if (!file.exists()) {
            return null;
        }
        return new FileInputStream(file);
    }

    public Image createImage(String key) throws Exception {
        JFreeChart chart = this.createGraph(key);
        if (chart == null) {
            return null;
        }
        return this.createImage(key, chart);
    }

    protected abstract JFreeChart createGraph(String var1, Dataset var2) throws Exception;

    protected abstract Dataset createDataset(String var1, InputStreamReader var2) throws Exception;

    protected abstract Image createImage(String var1, JFreeChart var2) throws Exception;

    public void saveAsJPEG(String key, String file, float quality, int width, int height) throws Exception {
        JFreeChart chart = this.createGraph(key);
        if (chart == null) {
            return;
        }
        if (quality > 0.0f) {
            ChartUtilities.saveChartAsJPEG((File)new File(this.createSavePath(key, file)), (float)quality, (JFreeChart)chart, (int)width, (int)height);
        } else {
            ChartUtilities.saveChartAsJPEG((File)new File(this.createSavePath(key, file)), (JFreeChart)chart, (int)width, (int)height);
        }
    }

    public void saveAsPNG(String key, String file, int width, int height) throws Exception {
        JFreeChart chart = this.createGraph(key);
        if (chart == null) {
            return;
        }
        ChartUtilities.saveChartAsPNG((File)new File(this.createSavePath(key, file)), (JFreeChart)chart, (int)width, (int)height);
    }

    protected String createSavePath(String key, String file) {
        String saveFile;
        String string = saveFile = file == null || file.length() == 0 ? key : file;
        if (this.saveDir != null) {
            String dir = this.saveDir;
            if (!this.saveDir.endsWith(FILE_SEPARATOR) && !saveFile.startsWith(FILE_SEPARATOR)) {
                dir = dir + FILE_SEPARATOR;
            }
            saveFile = dir + saveFile;
        }
        return saveFile;
    }
}

