/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.journal.editor;

import java.io.Serializable;
import jp.ossc.nimbus.service.journal.editor.ItemJournalEditorServiceBase;
import jp.ossc.nimbus.service.journal.editor.MethodJournalData;
import jp.ossc.nimbus.service.journal.editor.MethodJournalEditorServiceMBean;
import jp.ossc.nimbus.service.journal.editorfinder.EditorFinder;

public class MethodJournalEditorService
extends ItemJournalEditorServiceBase
implements MethodJournalEditorServiceMBean,
Serializable {
    private static final String OPEN_BRACKET = "( ";
    private static final String CLOSE_BRACKET = " )";
    private static final String IDENTIFYER_SEPARATOR = ".";
    private static final String TYPE_SEPARATOR = ", ";
    private static final String MESSAGE_SEPARATOR = " : ";
    private static final String ITEM_NAME = "Method : ";
    private boolean isOutputOwnerClass = true;
    private boolean isOutputParameterTypes = true;
    private boolean isOutputMessage = true;

    public MethodJournalEditorService() {
        this.setItemName(ITEM_NAME);
    }

    public void setOutputOwnerClass(boolean isOutput) {
        this.isOutputOwnerClass = isOutput;
    }

    public boolean isOutputOwnerClass() {
        return this.isOutputOwnerClass;
    }

    public void setOutputParameterTypes(boolean isOutput) {
        this.isOutputParameterTypes = isOutput;
    }

    public boolean isOutputParameterTypes() {
        return this.isOutputParameterTypes;
    }

    public void setOutputMessage(boolean isOutput) {
        this.isOutputMessage = isOutput;
    }

    public boolean isOutputMessage() {
        return this.isOutputMessage;
    }

    protected void processItem(EditorFinder finder, Object key, Object value, StringBuffer buf) {
        MethodJournalData methodData = (MethodJournalData)value;
        this.makeMethodJournalFormat(finder, key, methodData, buf);
    }

    protected StringBuffer makeMethodJournalFormat(EditorFinder finder, Object key, MethodJournalData data, StringBuffer buf) {
        Class[] types;
        String message;
        if (this.isOutputMessage() && (message = data.getMessage()) != null) {
            buf.append(message);
            buf.append(MESSAGE_SEPARATOR);
        }
        if (this.isOutputOwnerClass()) {
            this.makeObjectFormat(finder, null, data.getOwnerClass(), buf);
            buf.append(IDENTIFYER_SEPARATOR);
        }
        String name = data.getName();
        buf.append(name);
        buf.append(OPEN_BRACKET);
        if (this.isOutputParameterTypes() && (types = data.getParameterTypes()) != null) {
            for (int i = 0; i < types.length; ++i) {
                this.makeObjectFormat(finder, key, types[i], buf);
                if (i == types.length - 1) continue;
                buf.append(TYPE_SEPARATOR);
            }
        }
        buf.append(CLOSE_BRACKET);
        return buf;
    }
}

