/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.writer;

import jp.ossc.nimbus.core.ServiceBase;
import jp.ossc.nimbus.core.ServiceManagerFactory;
import jp.ossc.nimbus.core.ServiceName;
import jp.ossc.nimbus.service.writer.Category;
import jp.ossc.nimbus.service.writer.GroupCategoryServiceMBean;
import jp.ossc.nimbus.service.writer.MessageWriteException;

public class GroupCategoryService
extends ServiceBase
implements GroupCategoryServiceMBean {
    protected boolean isEnabled = true;
    protected ServiceName[] categoryServiceNames;
    protected Category[] categories;

    public void startService() throws Exception {
        if (this.categoryServiceNames != null) {
            this.categories = new Category[this.categoryServiceNames.length];
            int max = this.categoryServiceNames.length;
            for (int i = 0; i < max; ++i) {
                this.categories[i] = (Category)ServiceManagerFactory.getServiceObject(this.categoryServiceNames[i]);
            }
        }
    }

    public boolean isEnabled() {
        return this.isEnabled;
    }

    public void setEnabled(boolean enable) {
        this.isEnabled = enable;
    }

    public void write(Object elements) throws MessageWriteException {
        if (!this.isEnabled()) {
            return;
        }
        if (this.categories != null) {
            int max = this.categories.length;
            for (int i = 0; i < max; ++i) {
                if (!this.categories[i].isEnabled()) continue;
                this.categories[i].write(elements);
            }
        }
    }

    public void setCategoryServiceNames(ServiceName[] names) {
        this.categoryServiceNames = names;
    }

    public ServiceName[] getCategoryServiceNames() {
        return this.categoryServiceNames;
    }

    public void setCategories(Category[] categories) {
        this.categories = categories;
    }
}

