/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.aop.interceptor;

import java.beans.PropertyEditor;
import java.beans.PropertyEditorManager;
import java.lang.reflect.Method;
import java.util.Locale;
import jp.ossc.nimbus.core.NimbusClassLoader;
import jp.ossc.nimbus.core.ServiceBase;
import jp.ossc.nimbus.core.ServiceLoader;
import jp.ossc.nimbus.core.ServiceManagerFactory;
import jp.ossc.nimbus.core.ServiceMetaData;
import jp.ossc.nimbus.core.ServiceName;
import jp.ossc.nimbus.service.aop.Interceptor;
import jp.ossc.nimbus.service.aop.InterceptorChain;
import jp.ossc.nimbus.service.aop.InvocationContext;
import jp.ossc.nimbus.service.aop.MethodInvocationContext;
import jp.ossc.nimbus.service.aop.interceptor.ExceptionConsumeInterceptorServiceMBean;
import jp.ossc.nimbus.service.log.Logger;

public class ExceptionConsumeInterceptorService
extends ServiceBase
implements Interceptor,
ExceptionConsumeInterceptorServiceMBean {
    private String[] exceptionClassNames;
    private Class[] exceptionClasses;
    private ServiceName logServiceName;
    private Logger log;
    private String logKey;
    private String[] logArgs;
    private Locale logLocale;
    private Object returnValue;
    private boolean isLoggingException;

    public void setExceptionClassNames(String[] classnames) {
        this.exceptionClassNames = classnames;
    }

    public String[] getExceptionClassNames() {
        return this.exceptionClassNames;
    }

    public void setReturnValue(Object val) {
        this.returnValue = val;
    }

    public Object getReturnValue() {
        return this.returnValue;
    }

    public void setLoggerServiceName(ServiceName name) {
        this.logServiceName = name;
    }

    public ServiceName getLoggerServiceName() {
        return this.logServiceName;
    }

    public void setLoggerMessageCode(String key) {
        this.logKey = key;
    }

    public String getLoggerMessageCode() {
        return this.logKey;
    }

    public void setLoggerMessageArgs(String[] args) {
        this.logArgs = args;
    }

    public String[] getLoggerMessageArgs() {
        return this.logArgs;
    }

    public void setLoggerMessageLocale(Locale locale) {
        this.logLocale = locale;
    }

    public Locale getLoggerMessageLocale() {
        return this.logLocale;
    }

    public void setLoggingException(boolean isLogging) {
        this.isLoggingException = isLogging;
    }

    public boolean isLoggingException() {
        return this.isLoggingException;
    }

    public void setLogger(Logger log) {
        this.log = log;
    }

    public void startService() throws Exception {
        if (this.logServiceName != null) {
            if (this.logKey == null) {
                throw new IllegalArgumentException("LoggerMessageCode is null.");
            }
            if (this.log == null) {
                this.log = (Logger)ServiceManagerFactory.getServiceObject(this.logServiceName);
            }
        }
        if (this.exceptionClassNames != null) {
            this.exceptionClasses = new Class[this.exceptionClassNames.length];
            NimbusClassLoader loader = NimbusClassLoader.getInstance();
            for (int i = 0; i < this.exceptionClassNames.length; ++i) {
                this.exceptionClasses[i] = Class.forName(this.exceptionClassNames[i], true, loader);
            }
        }
    }

    public Object invoke(InvocationContext context, InterceptorChain chain) throws Throwable {
        if (this.getState() == 3) {
            try {
                return chain.invokeNext(context);
            }
            catch (Throwable th) {
                if (this.exceptionClasses != null) {
                    Class<?> caught = th.getClass();
                    for (int i = 0; i < this.exceptionClasses.length; ++i) {
                        if (!this.exceptionClasses[i].isAssignableFrom(caught)) continue;
                        if (this.log != null) {
                            this.log.write(this.logLocale, this.logKey, this.logArgs, this.isLoggingException ? th : null);
                        }
                        return this.createReturnValue((MethodInvocationContext)context);
                    }
                }
                throw th;
            }
        }
        return chain.invokeNext(context);
    }

    private Object createReturnValue(MethodInvocationContext context) {
        if (this.returnValue == null) {
            return this.returnValue;
        }
        Method method = context.getTargetMethod();
        Class<?> retType = method.getReturnType();
        if (Void.TYPE.equals(retType)) {
            return null;
        }
        if (this.returnValue != null && retType.isInstance(this.returnValue)) {
            return this.returnValue;
        }
        ServiceMetaData data = ServiceManagerFactory.getServiceMetaData(this.getServiceNameObject());
        ServiceLoader loader = null;
        if (data != null) {
            loader = data.getServiceLoader();
        }
        PropertyEditor editor = null;
        editor = loader == null ? PropertyEditorManager.findEditor(retType) : loader.findEditor(retType);
        if (editor == null) {
            return null;
        }
        editor.setAsText(this.returnValue.toString());
        return editor.getValue();
    }
}

