/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.beancontrol;

import java.beans.PropertyEditor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import jp.ossc.nimbus.beans.ServiceNameEditor;
import jp.ossc.nimbus.core.MetaData;
import jp.ossc.nimbus.core.ServiceManagerFactory;
import jp.ossc.nimbus.core.ServiceName;
import jp.ossc.nimbus.lang.ServiceException;
import jp.ossc.nimbus.service.beancontrol.BeanFlowInvokerFactoryCallBack;
import jp.ossc.nimbus.service.beancontrol.JobStep;
import jp.ossc.nimbus.service.beancontrol.interfaces.InvalidConfigurationException;
import jp.ossc.nimbus.service.beancontrol.resource.ResourceManager;
import jp.ossc.nimbus.service.journal.Journal;
import jp.ossc.nimbus.service.resource.TransactionResource;
import jp.ossc.nimbus.util.CsvArrayList;
import org.w3c.dom.Element;

public class StepParamInformation {
    private static final String C_SETTER = "set";
    private static final String C_THIS = "this";
    protected String mSetterName = null;
    protected String mValue = null;
    protected int mMode = 0;
    protected static final int C_VALUE_MOD = 1;
    protected static final String C_VALUE_MOD_STR = "value";
    protected static final int C_SERVICE_MOD = 2;
    protected static final String C_SERVICE_MOD_STR = "service";
    protected static final int C_STEP_MOD = 3;
    protected static final String C_STEP_MOD_STR = "step";
    protected static final int C_RESOURCE_MOD = 4;
    protected static final String C_RESOURCE_MOD_STR = "resource";
    protected static final int C_INPUT_MOD = 5;
    protected static final String C_INPUT_MOD_STR = "input";
    protected static String C_NAME_ATT = "name";
    protected static String C_TYPE_ATT = "type";
    protected static String C_VALUE_ATT = "value";
    protected static String C_VALUE_NULL = "null";
    protected HashMap mParamHash = null;
    protected boolean mMapFlg = false;
    protected ServiceNameEditor mEditor = new ServiceNameEditor();
    protected boolean mIsTransactionResourceSetter = false;
    protected BeanFlowInvokerFactoryCallBack mCallBack = null;
    protected Method mStepMethod = null;
    protected String mRefStepName = null;
    static /* synthetic */ Class class$jp$ossc$nimbus$service$resource$TransactionResource;

    protected StepParamInformation() {
        this.mParamHash = new HashMap();
    }

    public void fillParameter(Element element, Class clazz, BeanFlowInvokerFactoryCallBack callBack, List jobSteps) {
        int mode;
        this.mCallBack = callBack;
        Method mSetterMethod = null;
        String nameAttr = this.getAttMustBeSpecified(element, C_NAME_ATT);
        nameAttr = C_SETTER + nameAttr;
        this.setSetterName(nameAttr);
        String tmp = this.getAttMustBeSpecified(element, C_TYPE_ATT);
        this.setSetterMode(tmp);
        String valueAttr = element.getAttribute(C_VALUE_ATT);
        if (valueAttr == null || valueAttr.length() == 0) {
            valueAttr = MetaData.getElementContent(element);
        }
        if (!(valueAttr != null && valueAttr.length() != 0 || (mode = this.getSetterMode()) != 2 && mode != 3 && mode != 4)) {
            throw new InvalidConfigurationException(this.getClass().getName() + " value attr must be specified.");
        }
        if (this.getSetterMode() == 3) {
            CsvArrayList csvArrayList = new CsvArrayList();
            csvArrayList.split(valueAttr, "#");
            this.mRefStepName = csvArrayList.getStr(0);
            String getterStr = csvArrayList.getStr(1);
            if (!C_THIS.equals(getterStr)) {
                Iterator ite = jobSteps.iterator();
                boolean findFlg = false;
                while (ite.hasNext()) {
                    JobStep js = (JobStep)ite.next();
                    if (!js.getStepName().equals(this.mRefStepName)) continue;
                    Class claz = js.getBeanClass();
                    Method method = null;
                    try {
                        method = claz.getMethod(getterStr, null);
                    }
                    catch (SecurityException e) {
                        throw new InvalidConfigurationException("Step Getter is invalid " + valueAttr, e);
                    }
                    catch (NoSuchMethodException e) {
                        throw new InvalidConfigurationException("Step Getter is invalid " + valueAttr, e);
                    }
                    findFlg = true;
                    this.mStepMethod = method;
                    break;
                }
                if (!findFlg) {
                    throw new InvalidConfigurationException("Step Getter is none " + valueAttr);
                }
            }
        }
        this.setValue(valueAttr);
        Method[] methods = clazz.getMethods();
        for (int rCnt = 0; rCnt < methods.length; ++rCnt) {
            Class<?>[] params;
            if (!methods[rCnt].getName().equals(nameAttr) || (params = methods[rCnt].getParameterTypes()).length != 1) continue;
            mSetterMethod = methods[rCnt];
            this.mIsTransactionResourceSetter = params[0].isAssignableFrom(class$jp$ossc$nimbus$service$resource$TransactionResource == null ? StepParamInformation.class$("jp.ossc.nimbus.service.resource.TransactionResource") : class$jp$ossc$nimbus$service$resource$TransactionResource);
            this.mParamHash.put(params[0], mSetterMethod);
        }
        if (clazz.isAssignableFrom(Map.class)) {
            this.mMapFlg = true;
        }
        if (!this.mMapFlg && mSetterMethod == null) {
            throw new InvalidConfigurationException(this.getClass().getName() + " Not Found " + nameAttr + " method.");
        }
    }

    protected void setValue(String value) {
        this.mValue = value;
    }

    protected String getValue() {
        return this.mValue;
    }

    protected void setSetterMode(String mode) {
        if (mode.equals(C_VALUE_MOD_STR)) {
            this.mMode = 1;
        } else if (mode.equals(C_SERVICE_MOD_STR)) {
            this.mMode = 2;
        } else if (mode.equals(C_STEP_MOD_STR)) {
            this.mMode = 3;
        } else if (mode.equals(C_RESOURCE_MOD_STR)) {
            this.mMode = 4;
        } else if (mode.equals(C_INPUT_MOD_STR)) {
            this.mMode = 5;
        } else {
            throw new ServiceException("StepParamInformation", "It's not valid mode as setter [" + mode + "]");
        }
    }

    protected int getSetterMode() {
        return this.mMode;
    }

    protected String getSetterName() {
        return this.mSetterName;
    }

    protected void setSetterName(String setterName) {
        this.mSetterName = setterName;
    }

    protected void invokeParameter(Object invokeInstance, HashMap execBlInstanceHash, ResourceManager rm, Object inputObj) throws NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        Object retCls = null;
        Object retObj = null;
        if (invokeInstance == null) {
            throw new ServiceException(this.getClass().getName(), "Target Object is null.");
        }
        switch (this.mMode) {
            case 1: {
                this.invokeSetter(invokeInstance, this.mValue);
                break;
            }
            case 2: {
                this.mEditor.setAsText(this.mValue);
                retObj = ServiceManagerFactory.getServiceObject((ServiceName)this.mEditor.getValue());
                this.invokeSetter(invokeInstance, retObj);
                break;
            }
            case 3: {
                if (this.mStepMethod != null) {
                    Object obj = execBlInstanceHash.get(this.mRefStepName);
                    retObj = this.mStepMethod.invoke(obj, null);
                } else {
                    retObj = execBlInstanceHash.get(this.mRefStepName);
                }
                this.invokeSetter(invokeInstance, retObj);
                break;
            }
            case 4: {
                Object tmpObj = rm.getResource(this.mValue);
                retObj = this.mIsTransactionResourceSetter ? tmpObj : ((TransactionResource)tmpObj).getObject();
                this.invokeSetter(invokeInstance, retObj);
                break;
            }
            case 5: {
                if (this.mValue != null && this.mValue.length() > 0) {
                    if (inputObj.getClass().isAssignableFrom(Map.class)) {
                        Map tmp = (Map)inputObj;
                        inputObj = tmp.get(this.mValue);
                    } else {
                        Class<?> clazz1 = inputObj.getClass();
                        Method method1 = null;
                        method1 = clazz1.getMethod(this.mValue, null);
                        inputObj = method1.invoke(inputObj, null);
                    }
                }
                this.invokeSetter(invokeInstance, inputObj);
            }
        }
    }

    private void invokeSetter(Object invokeTarget, Object argObj) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        Set keys;
        Object[] objAry = new Object[]{argObj};
        Method msd = null;
        Journal jnl = this.mCallBack.getJournal();
        if (jnl != null) {
            if (argObj != null) {
                jnl.addInfo(this.mSetterName, argObj.toString());
            } else {
                jnl.addInfo(this.mSetterName, C_VALUE_NULL);
            }
        }
        if (this.mMode == 1) {
            Iterator ite;
            if (this.mParamHash.size() == 1 && (ite = (keys = this.mParamHash.keySet()).iterator()).hasNext()) {
                Class cls = (Class)ite.next();
                PropertyEditor pe = this.mCallBack.findPropEditor(cls);
                pe.setAsText((String)argObj);
                objAry[0] = pe.getValue();
                msd = (Method)this.mParamHash.get(cls);
            }
        } else if (this.mMode == 5) {
            keys = this.mParamHash.keySet();
            Iterator ite = keys.iterator();
            if (ite.hasNext()) {
                Class cls = (Class)ite.next();
                msd = (Method)this.mParamHash.get(cls);
            }
        } else if (this.mParamHash.size() > 0) {
            if (argObj != null) {
                msd = (Method)this.mParamHash.get(argObj.getClass());
                if (msd == null) {
                    keys = this.mParamHash.keySet();
                    Iterator ite = keys.iterator();
                    while (ite.hasNext()) {
                        Class cls = (Class)ite.next();
                        if (!cls.isAssignableFrom(argObj.getClass())) continue;
                        msd = (Method)this.mParamHash.get(cls);
                        break;
                    }
                }
            } else {
                keys = this.mParamHash.keySet();
                Iterator ite = keys.iterator();
                if (ite.hasNext()) {
                    Class cls = (Class)ite.next();
                    msd = (Method)this.mParamHash.get(cls);
                }
            }
        }
        if (msd == null && this.mMapFlg) {
            Map map = (Map)invokeTarget;
            map.put(this.mSetterName, argObj);
        } else if (msd != null) {
            msd.invoke(invokeTarget, objAry);
        } else {
            throw new InvalidConfigurationException("Fail to set Attribute [" + this.mSetterName + "]" + " param class is " + argObj.getClass());
        }
    }

    private String getAttMustBeSpecified(Element elem, String attName) {
        String ret = elem.getAttribute(attName);
        if (ret != null && ret.length() > 0) {
            return ret;
        }
        throw new InvalidConfigurationException("Fail to get Attribute [" + attName + "] ." + "Tag name is " + elem.getTagName());
    }
}

