/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.beans;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import jp.ossc.nimbus.beans.NoSuchPropertyException;
import jp.ossc.nimbus.beans.NoSuchReadablePropertyException;
import jp.ossc.nimbus.beans.NoSuchWritablePropertyException;
import jp.ossc.nimbus.beans.Property;

public class SimpleProperty
implements Property,
Serializable {
    private static final String MSG_00001 = "Length of property literal must be more than 1.";
    protected static final Object[] NULL_ARGS = new Object[0];
    protected static final String MAP_GET_METHOD_NAME = "get";
    protected static final Class[] MAP_GET_METHOD_ARGS = new Class[]{String.class};
    protected static final String MAP_SET_METHOD_NAME = "put";
    protected static final Class[] MAP_SET_METHOD_ARGS = new Class[]{String.class, Object.class};
    protected String property;
    protected transient Map getMethodCache = new HashMap();
    protected transient Map setMethodCache = new HashMap();

    public SimpleProperty() {
    }

    public SimpleProperty(String prop) throws IllegalArgumentException {
        this.setPropertyName(prop);
    }

    public void parse(String prop) throws IllegalArgumentException {
        this.setPropertyName(prop);
    }

    public String getPropertyName() {
        return this.property;
    }

    protected void setPropertyName(String prop) throws IllegalArgumentException {
        if (prop == null || prop.length() == 0) {
            throw new IllegalArgumentException(MSG_00001);
        }
        this.property = prop;
    }

    public Class getPropertyType(Object obj) throws NoSuchPropertyException {
        return this.getPropertyType(obj.getClass());
    }

    public Class getPropertyType(Class clazz) throws NoSuchPropertyException {
        if (this.property == null) {
            throw new NoSuchPropertyException(clazz, this.property);
        }
        PropertyDescriptor descriptor = null;
        try {
            descriptor = this.getPropertyDescriptor(clazz);
        }
        catch (NoSuchPropertyException e) {
            if (Map.class.isAssignableFrom(clazz)) {
                return Object.class;
            }
            throw e;
        }
        return descriptor.getPropertyType();
    }

    public boolean isReadable(Object obj) {
        return this.isReadable(obj.getClass());
    }

    public boolean isReadable(Class clazz) {
        if (this.property == null) {
            return false;
        }
        if (Map.class.isAssignableFrom(clazz)) {
            return true;
        }
        Method readMethod = null;
        if (this.getMethodCache.containsKey(clazz)) {
            return true;
        }
        PropertyDescriptor descriptor = null;
        try {
            descriptor = this.getPropertyDescriptor(clazz);
        }
        catch (NoSuchPropertyException e) {
            return false;
        }
        readMethod = descriptor.getReadMethod();
        if (readMethod == null || readMethod.getParameterTypes().length != 0) {
            return false;
        }
        this.getMethodCache.put(clazz, readMethod);
        return true;
    }

    public boolean isWritable(Object obj, Class clazz) {
        return this.isWritable(obj.getClass());
    }

    public boolean isWritable(Object obj, Object value) {
        return this.isWritable(obj.getClass());
    }

    public boolean isWritable(Class clazz) {
        if (this.property == null) {
            return false;
        }
        if (Map.class.isAssignableFrom(clazz)) {
            return true;
        }
        Method writeMethod = null;
        if (this.setMethodCache.containsKey(clazz)) {
            return true;
        }
        PropertyDescriptor descriptor = null;
        try {
            descriptor = this.getPropertyDescriptor(clazz);
        }
        catch (NoSuchPropertyException e) {
            return false;
        }
        writeMethod = descriptor.getWriteMethod();
        if (writeMethod == null || writeMethod.getParameterTypes().length != 1) {
            return false;
        }
        this.setMethodCache.put(clazz, writeMethod);
        return true;
    }

    public Object getProperty(Object obj) throws NoSuchPropertyException, InvocationTargetException {
        if (this.property == null) {
            throw new NoSuchPropertyException(obj.getClass(), this.property);
        }
        try {
            Class<?> clazz = obj.getClass();
            Method readMethod = null;
            if (this.getMethodCache.containsKey(clazz)) {
                readMethod = (Method)this.getMethodCache.get(clazz);
            } else {
                PropertyDescriptor descriptor = this.getPropertyDescriptor(obj);
                readMethod = descriptor.getReadMethod();
                if (readMethod == null || readMethod.getParameterTypes().length != 0) {
                    throw new NoSuchReadablePropertyException(clazz, this.property);
                }
                this.getMethodCache.put(clazz, readMethod);
            }
            try {
                return readMethod.invoke(obj, NULL_ARGS);
            }
            catch (IllegalAccessException e) {
                throw new NoSuchPropertyException(clazz, this.property, e);
            }
            catch (IllegalArgumentException e) {
                throw new NoSuchPropertyException(clazz, this.property, e);
            }
        }
        catch (NoSuchPropertyException e) {
            if (obj instanceof Map) {
                return ((Map)obj).get(this.property);
            }
            throw e;
        }
    }

    public void setProperty(Object obj, Object value) throws NoSuchPropertyException, InvocationTargetException {
        if (this.property == null) {
            throw new NoSuchPropertyException(obj.getClass(), this.property);
        }
        Class<?> clazz = obj.getClass();
        Method writeMethod = null;
        if (this.setMethodCache.containsKey(clazz)) {
            writeMethod = (Method)this.setMethodCache.get(clazz);
        } else {
            PropertyDescriptor descriptor = null;
            try {
                descriptor = this.getPropertyDescriptor(obj);
            }
            catch (NoSuchPropertyException e) {
                if (obj instanceof Map) {
                    ((Map)obj).put(this.property, value);
                    return;
                }
                throw e;
            }
            writeMethod = descriptor.getWriteMethod();
            if (writeMethod == null || writeMethod.getParameterTypes().length != 1) {
                if (obj instanceof Map) {
                    ((Map)obj).put(this.property, value);
                    return;
                }
                throw new NoSuchWritablePropertyException(clazz, this.property);
            }
            this.setMethodCache.put(clazz, writeMethod);
        }
        try {
            writeMethod.invoke(obj, value);
        }
        catch (IllegalAccessException e) {
            throw new NoSuchPropertyException(clazz, this.property, e);
        }
        catch (IllegalArgumentException e) {
            throw new NoSuchPropertyException(clazz, this.property, e);
        }
    }

    public Method getReadMethod(Object obj) throws NoSuchPropertyException, InvocationTargetException {
        return this.getReadMethod(obj.getClass());
    }

    public Method getReadMethod(Class clazz) throws NoSuchPropertyException, InvocationTargetException {
        if (this.property == null) {
            throw new NoSuchPropertyException(clazz, this.property);
        }
        try {
            Method readMethod = null;
            if (this.getMethodCache.containsKey(clazz)) {
                readMethod = (Method)this.getMethodCache.get(clazz);
            } else {
                PropertyDescriptor descriptor = this.getPropertyDescriptor(clazz);
                readMethod = descriptor.getReadMethod();
                if (readMethod == null || readMethod.getParameterTypes().length != 0) {
                    throw new NoSuchReadablePropertyException(clazz, this.property);
                }
                this.getMethodCache.put(clazz, readMethod);
            }
            return readMethod;
        }
        catch (NoSuchPropertyException e) {
            if (Map.class.isAssignableFrom(clazz)) {
                try {
                    return Map.class.getMethod(MAP_GET_METHOD_NAME, MAP_GET_METHOD_ARGS);
                }
                catch (NoSuchMethodException ee) {
                    throw e;
                }
            }
            throw e;
        }
    }

    public Method getWriteMethod(Object obj) throws NoSuchPropertyException, InvocationTargetException {
        return this.getWriteMethod(obj.getClass());
    }

    public Method getWriteMethod(Class clazz) throws NoSuchPropertyException, InvocationTargetException {
        if (this.property == null) {
            throw new NoSuchPropertyException(clazz, this.property);
        }
        Method writeMethod = null;
        if (this.setMethodCache.containsKey(clazz)) {
            writeMethod = (Method)this.setMethodCache.get(clazz);
        } else {
            try {
                PropertyDescriptor descriptor = this.getPropertyDescriptor(clazz);
                writeMethod = descriptor.getWriteMethod();
                if (writeMethod == null || writeMethod.getParameterTypes().length != 1) {
                    throw new NoSuchWritablePropertyException(clazz, this.property);
                }
                this.setMethodCache.put(clazz, writeMethod);
            }
            catch (NoSuchPropertyException e) {
                if (Map.class.isAssignableFrom(clazz)) {
                    try {
                        return Map.class.getMethod(MAP_SET_METHOD_NAME, MAP_SET_METHOD_ARGS);
                    }
                    catch (NoSuchMethodException ee) {
                        throw e;
                    }
                }
                throw e;
            }
        }
        return writeMethod;
    }

    public static SimpleProperty[] getProperties(Object bean) {
        return SimpleProperty.getProperties(bean.getClass());
    }

    public static SimpleProperty[] getProperties(Class clazz) {
        Set props = new HashSet();
        if (SimpleProperty.isAccessableClass(clazz)) {
            props = SimpleProperty.getProperties(clazz, props);
        } else {
            Class<?>[] interfaces = clazz.getInterfaces();
            for (int i = 0; i < interfaces.length; ++i) {
                if (!SimpleProperty.isAccessableClass(interfaces[i])) continue;
                props = SimpleProperty.getProperties(interfaces[i], props);
            }
        }
        return props.toArray(new SimpleProperty[props.size()]);
    }

    public static Set getPropertyNames(Object bean) {
        return SimpleProperty.getPropertyNames(bean.getClass());
    }

    public static Set getPropertyNames(Class clazz) {
        Set props = new HashSet();
        if (SimpleProperty.isAccessableClass(clazz)) {
            props = SimpleProperty.getPropertyNames(clazz, props);
        } else {
            Class<?>[] interfaces = clazz.getInterfaces();
            for (int i = 0; i < interfaces.length; ++i) {
                if (!SimpleProperty.isAccessableClass(interfaces[i])) continue;
                props = SimpleProperty.getPropertyNames(interfaces[i], props);
            }
        }
        return props;
    }

    private static Set getPropertyNames(Class clazz, Set props) {
        BeanInfo beanInfo = null;
        try {
            beanInfo = Introspector.getBeanInfo(clazz);
        }
        catch (IntrospectionException e) {
            return props;
        }
        PropertyDescriptor[] descriptors = beanInfo.getPropertyDescriptors();
        if (descriptors == null) {
            return props;
        }
        for (int i = 0; i < descriptors.length; ++i) {
            props.add(descriptors[i].getName());
        }
        return props;
    }

    private static Set getProperties(Class clazz, Set props) {
        BeanInfo beanInfo = null;
        try {
            beanInfo = Introspector.getBeanInfo(clazz);
        }
        catch (IntrospectionException e) {
            return props;
        }
        PropertyDescriptor[] descriptors = beanInfo.getPropertyDescriptors();
        if (descriptors == null) {
            return props;
        }
        for (int i = 0; i < descriptors.length; ++i) {
            props.add(new SimpleProperty(descriptors[i].getName()));
        }
        return props;
    }

    protected PropertyDescriptor getPropertyDescriptor(Object obj) throws NoSuchPropertyException {
        Class<?> clazz = obj.getClass();
        if (SimpleProperty.isAccessableClass(clazz)) {
            return this.getPropertyDescriptor(clazz);
        }
        Class<?>[] interfaces = clazz.getInterfaces();
        for (int i = 0; i < interfaces.length; ++i) {
            if (!SimpleProperty.isAccessableClass(interfaces[i])) continue;
            try {
                return this.getPropertyDescriptor(interfaces[i]);
            }
            catch (NoSuchPropertyException e) {
                // empty catch block
            }
        }
        throw new NoSuchPropertyException(clazz, this.property);
    }

    protected static boolean isAccessableClass(Class clazz) {
        int modifier = clazz.getModifiers();
        return Modifier.isPublic(modifier) || (Modifier.isProtected(modifier) || !Modifier.isPublic(modifier) && !Modifier.isProtected(modifier) && !Modifier.isPrivate(modifier)) && SimpleProperty.class.getPackage().equals(clazz.getPackage());
    }

    protected PropertyDescriptor getPropertyDescriptor(Class clazz) throws NoSuchPropertyException {
        BeanInfo beanInfo = null;
        try {
            beanInfo = Introspector.getBeanInfo(clazz);
        }
        catch (IntrospectionException e) {
            throw new NoSuchPropertyException(clazz, this.property, e);
        }
        PropertyDescriptor[] descriptors = beanInfo.getPropertyDescriptors();
        if (descriptors == null) {
            throw new NoSuchPropertyException(clazz, this.property);
        }
        String prop = this.property;
        int len = prop.length();
        if (len != 0 && Character.isUpperCase(prop.charAt(0))) {
            prop = len > 1 ? Character.toLowerCase(prop.charAt(0)) + prop.substring(1) : prop.toLowerCase();
        }
        for (int i = 0; i < descriptors.length; ++i) {
            if (!prop.equals(descriptors[i].getName()) && !this.property.equals(descriptors[i].getName())) continue;
            return descriptors[i];
        }
        throw new NoSuchPropertyException(clazz, this.property);
    }

    public String toString() {
        return "SimpleProperty{" + this.property + "}";
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.getMethodCache = new HashMap();
        this.setMethodCache = new HashMap();
    }
}

