/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.queue;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import jp.ossc.nimbus.core.ServiceBase;
import jp.ossc.nimbus.core.ServiceManagerFactory;
import jp.ossc.nimbus.core.ServiceName;
import jp.ossc.nimbus.lang.IllegalServiceStateException;
import jp.ossc.nimbus.service.cache.Cache;
import jp.ossc.nimbus.service.cache.CacheRemoveListener;
import jp.ossc.nimbus.service.cache.CachedReference;
import jp.ossc.nimbus.service.queue.DefaultQueueServiceMBean;
import jp.ossc.nimbus.service.queue.Queue;

public class DefaultQueueService
extends ServiceBase
implements Queue,
CacheRemoveListener,
DefaultQueueServiceMBean,
Serializable {
    private List queueElements;
    private int initialCapacity = -1;
    private int capacityIncrement = -1;
    private ServiceName cacheServiceName;
    private Cache cache;
    private List waitThreads;
    private Set wakeUpThreads;
    private long sleepTime = 10000L;
    private volatile boolean fourceEndFlg = false;
    private long pushCount = 0L;
    private long getCount = 0L;

    public void setInitialCapacity(int initial) {
        this.initialCapacity = initial;
    }

    public int getInitialCapacity() {
        return this.initialCapacity;
    }

    public void setCapacityIncrement(int increment) {
        this.capacityIncrement = increment;
    }

    public int getCapacityIncrement() {
        return this.capacityIncrement;
    }

    public void setCacheServiceName(ServiceName name) {
        this.cacheServiceName = name;
    }

    public ServiceName getCacheServiceName() {
        return this.cacheServiceName;
    }

    public void setSleepTime(long millis) {
        this.sleepTime = millis;
    }

    public long getSleepTime() {
        return this.sleepTime;
    }

    public void createService() throws Exception {
        this.waitThreads = new Vector();
        this.wakeUpThreads = Collections.synchronizedSet(new HashSet());
    }

    public void startService() throws Exception {
        this.accept();
        if (this.queueElements == null) {
            this.queueElements = this.initialCapacity >= 0 ? (this.capacityIncrement >= 0 ? new Vector(this.initialCapacity, this.capacityIncrement) : new Vector(this.initialCapacity)) : new Vector();
        }
        if (this.cacheServiceName != null) {
            this.cache = (Cache)ServiceManagerFactory.getServiceObject(this.cacheServiceName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopService() throws Exception {
        this.release();
        if (this.waitThreads != null) {
            while (true) {
                Thread waitThread = null;
                List list = this.waitThreads;
                synchronized (list) {
                    if (this.waitThreads.size() == 0) {
                        break;
                    }
                    waitThread = (Thread)this.waitThreads.get(0);
                    this.wakeUpThreads.add(waitThread);
                    waitThread.interrupt();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroyService() throws Exception {
        this.queueElements.clear();
        this.queueElements = null;
        this.cache = null;
        Collection collection = this.waitThreads;
        synchronized (collection) {
            this.waitThreads = null;
        }
        collection = this.wakeUpThreads;
        synchronized (collection) {
            this.wakeUpThreads = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void push(Object item) {
        if (this.getState() != 3 || this.fourceEndFlg) {
            throw new IllegalServiceStateException(this);
        }
        if (this.cache == null) {
            this.queueElements.add(item);
        } else {
            CachedReference ref = this.cache.add(item);
            if (ref != null) {
                ref.addCacheRemoveListener(this);
                this.queueElements.add(ref);
            } else {
                this.queueElements.add(item);
            }
        }
        ++this.pushCount;
        if (this.waitThreads != null) {
            List list = this.waitThreads;
            synchronized (list) {
                Thread waitThread;
                if (this.waitThreads.size() != 0 && !this.wakeUpThreads.contains(waitThread = (Thread)this.waitThreads.get(0))) {
                    this.wakeUpThreads.add(waitThread);
                    waitThread.interrupt();
                }
            }
        }
    }

    public Object get(long timeOutMs) {
        return this.getQueueElement(timeOutMs, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Object getQueueElement(long timeOutMs, boolean isRemove) {
        Object object;
        Thread current;
        block21: {
            Object var9_8;
            block20: {
                List list;
                List list2;
                block18: {
                    current = Thread.currentThread();
                    long processTime = 0L;
                    try {
                        if (this.waitThreads != null) {
                            list2 = this.waitThreads;
                            synchronized (list2) {
                                this.waitThreads.add(current);
                                this.wakeUpThreads.add(current);
                            }
                        }
                        while (!(timeOutMs >= 0L && timeOutMs <= processTime || this.size() != 0 || this.fourceEndFlg)) {
                            long proc;
                            block19: {
                                if (this.fourceEndFlg) {
                                    list2 = null;
                                    Object var12_9 = null;
                                    if (this.waitThreads == null) return list2;
                                    list = this.waitThreads;
                                    break block18;
                                }
                                proc = 0L;
                                if (timeOutMs >= 0L) {
                                    proc = System.currentTimeMillis();
                                }
                                try {
                                    if (!Thread.interrupted()) {
                                        this.wakeUpThreads.remove(current);
                                        Thread.sleep(timeOutMs >= 0L ? timeOutMs - processTime : this.sleepTime);
                                        this.wakeUpThreads.add(current);
                                    }
                                }
                                catch (InterruptedException e) {
                                    Thread.interrupted();
                                    if (this.wakeUpThreads.contains(current)) break block19;
                                    Object var10_19 = null;
                                    Object var12_10 = null;
                                    if (this.waitThreads == null) return var10_19;
                                    List list3 = this.waitThreads;
                                    synchronized (list3) {
                                        this.waitThreads.remove(current);
                                        this.wakeUpThreads.remove(current);
                                        return var10_19;
                                    }
                                }
                            }
                            if (timeOutMs >= 0L) {
                                proc = System.currentTimeMillis() - proc;
                                processTime += proc;
                            }
                            if (this.queueElements != null && this.size() > 0 && this.waitThreads.size() != 0 && this.waitThreads.get(0) == current) break;
                            if (!this.fourceEndFlg) continue;
                            var9_8 = null;
                            break block20;
                        }
                        Object ret = this.getQueueElement(isRemove);
                        ++this.getCount;
                        object = ret;
                        break block21;
                    }
                    catch (Throwable throwable) {
                        Object var12_13 = null;
                        if (this.waitThreads == null) throw throwable;
                        List list4 = this.waitThreads;
                        synchronized (list4) {
                            this.waitThreads.remove(current);
                            this.wakeUpThreads.remove(current);
                            throw throwable;
                        }
                    }
                }
                synchronized (list) {
                    this.waitThreads.remove(current);
                    this.wakeUpThreads.remove(current);
                    return list2;
                }
            }
            Object var12_11 = null;
            if (this.waitThreads == null) return var9_8;
            List list = this.waitThreads;
            synchronized (list) {
                this.waitThreads.remove(current);
                this.wakeUpThreads.remove(current);
                return var9_8;
            }
        }
        Object var12_12 = null;
        if (this.waitThreads == null) return object;
        List list = this.waitThreads;
        synchronized (list) {
            this.waitThreads.remove(current);
            this.wakeUpThreads.remove(current);
            return object;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object getQueueElement(boolean isRemove) {
        if (this.queueElements == null || this.size() == 0) {
            return null;
        }
        Object element = null;
        List list = this.queueElements;
        synchronized (list) {
            if (this.size() != 0) {
                element = isRemove ? this.queueElements.remove(0) : this.queueElements.get(0);
            }
        }
        if (element == null) {
            return null;
        }
        if (this.cache == null) {
            return element;
        }
        if (element instanceof CachedReference) {
            CachedReference ref = element;
            if (ref != null) {
                Object obj = ref.get();
                if (isRemove) {
                    this.cache.remove(ref);
                }
                return obj;
            }
            return null;
        }
        return element;
    }

    public Object get() {
        return this.get(-1L);
    }

    public Object peek(long timeOutMs) {
        return this.getQueueElement(timeOutMs, false);
    }

    public Object peek() {
        return this.peek(-1L);
    }

    public void remove(Object item) {
        if (this.cache == null) {
            this.queueElements.remove(item);
        } else {
            Object[] elements = this.queueElements.toArray();
            for (int i = 0; i < elements.length; ++i) {
                Object element = elements[i];
                if (element instanceof CachedReference) {
                    CachedReference ref = (CachedReference)element;
                    Object obj = ref.get(this, false);
                    if ((item != null || obj != null) && (item == null || !item.equals(obj))) continue;
                    this.cache.remove(ref);
                    break;
                }
                if ((item != null || element != null) && (item == null || !item.equals(element))) continue;
                this.queueElements.remove(element);
                break;
            }
        }
    }

    public void clear() {
        if (this.cache == null) {
            this.queueElements.clear();
        } else {
            Object[] elements = this.queueElements.toArray();
            for (int i = 0; i < elements.length; ++i) {
                Object element = elements[i];
                if (!(element instanceof CachedReference)) continue;
                CachedReference ref = (CachedReference)element;
                this.cache.remove(ref);
            }
            this.queueElements.clear();
        }
    }

    public int size() {
        if (this.queueElements == null) {
            return 0;
        }
        return this.queueElements.size();
    }

    public void accept() {
        this.fourceEndFlg = false;
    }

    public void release() {
        this.fourceEndFlg = true;
    }

    public List elements() {
        if (this.queueElements == null) {
            return new ArrayList();
        }
        return new ArrayList(this.queueElements);
    }

    public void removed(CachedReference ref) {
        if (this.queueElements == null) {
            return;
        }
        this.queueElements.remove(ref);
    }

    public int getSize() {
        return this.size();
    }

    public long getPushCount() {
        return this.pushCount;
    }

    public long getGetCount() {
        return this.getCount;
    }
}

