/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.resource;

import java.lang.reflect.Constructor;
import jp.ossc.nimbus.core.ServiceBase;
import jp.ossc.nimbus.core.ServiceManagerFactory;
import jp.ossc.nimbus.core.ServiceName;
import jp.ossc.nimbus.service.resource.DefaultPooledTransactionResource;
import jp.ossc.nimbus.service.resource.PooledResourceFactoryServiceMBean;
import jp.ossc.nimbus.service.resource.ResourceFactory;
import jp.ossc.nimbus.service.resource.TransactionResource;
import org.apache.commons.pool.ObjectPool;
import org.apache.commons.pool.PoolableObjectFactory;
import org.apache.commons.pool.impl.GenericObjectPool;

public class PooledResourceFactoryService
extends ServiceBase
implements ResourceFactory,
PooledResourceFactoryServiceMBean {
    private Class poolableObjectFactoryClass;
    private ServiceName poolableObjectFactoryServiceName;
    private GenericObjectPool pool;
    private int maxActive = 8;
    private int maxIdle = 8;
    private int minIdle = 0;
    private long maxWait = -1L;
    private long minEvictableIdleTime = 1800000L;
    private int numTestsPerEvictionRun = 3;
    private boolean isTestOnBorrow = false;
    private boolean isTestOnReturn = false;
    private boolean isTestWhileIdle = false;
    private long timeBetweenEvictionRuns = -1L;
    private String whenExhaustedActionName = "WHEN_EXHAUSTED_BLOCK";
    private byte whenExhaustedActionValue = 1;
    private Class pooledTransactionResourceClass = DefaultPooledTransactionResource.class;
    private Constructor transactionResourceConstructor;

    public void setPoolableObjectFactoryClass(Class clazz) {
        this.poolableObjectFactoryClass = clazz;
    }

    public Class getPoolableObjectFactoryClass() {
        return this.poolableObjectFactoryClass;
    }

    public void setPoolableObjectFactoryServiceName(ServiceName name) {
        this.poolableObjectFactoryServiceName = name;
    }

    public ServiceName getPoolableObjectFactoryServiceName() {
        return this.poolableObjectFactoryServiceName;
    }

    public void setMaxActive(int max) {
        this.maxActive = max;
    }

    public int getMaxActive() {
        return this.maxActive;
    }

    public void setMaxIdle(int max) {
        this.maxIdle = max;
    }

    public int getMaxIdle() {
        return this.maxIdle;
    }

    public void setMinIdle(int min) {
        this.minIdle = min;
    }

    public int getMinIdle() {
        return this.minIdle;
    }

    public void setMaxWaitTime(long maxMillis) {
        this.maxWait = maxMillis;
    }

    public long getMaxWaitTime() {
        return this.maxWait;
    }

    public void setMinEvictableIdleTime(long minMillis) {
        this.minEvictableIdleTime = minMillis;
    }

    public long getMinEvictableIdleTime() {
        return this.minEvictableIdleTime;
    }

    public void setNumTestsPerEvictionRun(int num) {
        this.numTestsPerEvictionRun = num;
    }

    public int getNumTestsPerEvictionRun() {
        return this.numTestsPerEvictionRun;
    }

    public void setTestOnBorrow(boolean isTest) {
        this.isTestOnBorrow = isTest;
    }

    public boolean isTestOnBorrow() {
        return this.isTestOnBorrow;
    }

    public void setTestOnReturn(boolean isTest) {
        this.isTestOnReturn = isTest;
    }

    public boolean isTestOnReturn() {
        return this.isTestOnReturn;
    }

    public void setTestWhileIdle(boolean isTest) {
        this.isTestWhileIdle = isTest;
    }

    public boolean isTestWhileIdle() {
        return this.isTestWhileIdle;
    }

    public void setTimeBetweenEvictionRuns(long millis) {
        this.timeBetweenEvictionRuns = millis;
    }

    public long getTimeBetweenEvictionRuns() {
        return this.timeBetweenEvictionRuns;
    }

    public void setWhenExhaustedAction(String action) throws IllegalArgumentException {
        if ("WHEN_EXHAUSTED_BLOCK".equals(action)) {
            this.whenExhaustedActionValue = 1;
        } else if ("WHEN_EXHAUSTED_BLOCK".equals(action)) {
            this.whenExhaustedActionValue = 0;
        } else if ("WHEN_EXHAUSTED_BLOCK".equals(action)) {
            this.whenExhaustedActionValue = (byte)2;
        } else {
            throw new IllegalArgumentException(action);
        }
        this.whenExhaustedActionName = action;
    }

    public String getWhenExhaustedAction() {
        return this.whenExhaustedActionName;
    }

    public void startService() throws Exception {
        PoolableObjectFactory factory = null;
        if (this.poolableObjectFactoryClass != null) {
            factory = (PoolableObjectFactory)this.poolableObjectFactoryClass.newInstance();
        } else if (this.poolableObjectFactoryServiceName != null) {
            factory = (PoolableObjectFactory)ServiceManagerFactory.getServiceObject(this.poolableObjectFactoryServiceName);
        } else {
            throw new IllegalArgumentException("poolableObjectFactoryClass or poolableObjectFactoryServiceName must be specified.");
        }
        if (this.pooledTransactionResourceClass == null) {
            throw new IllegalArgumentException("pooledTransactionResourceClass must be specified.");
        }
        this.transactionResourceConstructor = this.pooledTransactionResourceClass.getConstructor(ObjectPool.class);
        this.pool = new GenericObjectPool(factory);
        this.pool.setMaxActive(this.maxActive);
        this.pool.setMaxIdle(this.maxIdle);
        this.pool.setMinIdle(this.minIdle);
        this.pool.setMaxWait(this.maxWait);
        this.pool.setMinEvictableIdleTimeMillis(this.minEvictableIdleTime);
        this.pool.setNumTestsPerEvictionRun(this.numTestsPerEvictionRun);
        this.pool.setTestOnBorrow(this.isTestOnBorrow);
        this.pool.setTestOnReturn(this.isTestOnReturn);
        this.pool.setTestWhileIdle(this.isTestWhileIdle);
        this.pool.setTimeBetweenEvictionRunsMillis(this.timeBetweenEvictionRuns);
        this.pool.setWhenExhaustedAction(this.whenExhaustedActionValue);
    }

    public void stopService() throws Exception {
        if (this.pool != null) {
            this.pool.close();
            this.pool = null;
        }
    }

    public TransactionResource makeResource(String key) throws Exception {
        return (TransactionResource)this.transactionResourceConstructor.newInstance(this.pool);
    }

    public void clear() throws Exception {
        if (this.pool != null) {
            this.pool.clear();
        }
    }

    public int getActiveNum() {
        return this.pool == null ? 0 : this.pool.getNumActive();
    }

    public int getIdleNum() {
        return this.pool == null ? 0 : this.pool.getNumIdle();
    }
}

