/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.core;

import java.io.Serializable;
import jp.ossc.nimbus.core.DeploymentException;
import jp.ossc.nimbus.core.MetaData;
import jp.ossc.nimbus.core.ObjectMetaData;
import jp.ossc.nimbus.core.ServiceRefMetaData;
import org.w3c.dom.Element;

public class FieldMetaData
extends MetaData
implements Serializable {
    public static final String FIELD_TAG_NAME = "field";
    protected static final String NAME_ATTRIBUTE_NAME = "name";
    protected static final String TYPE_ATTRIBUTE_NAME = "type";
    protected String name;
    protected String type;
    protected Object value;

    public FieldMetaData(ObjectMetaData parent) {
        super(parent);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public Object getValue() {
        return this.value;
    }

    public void setValue(Object value) {
        this.value = value;
    }

    public void importXML(Element element) throws DeploymentException {
        super.importXML(element);
        if (!element.getTagName().equals(FIELD_TAG_NAME)) {
            throw new DeploymentException("Tag must be field : " + element.getTagName());
        }
        this.name = FieldMetaData.getUniqueAttribute(element, NAME_ATTRIBUTE_NAME);
        this.type = FieldMetaData.getOptionalAttribute(element, TYPE_ATTRIBUTE_NAME);
        Element serviceRefElement = FieldMetaData.getOptionalChild(element, "service-ref");
        if (serviceRefElement != null) {
            ServiceRefMetaData serviceRefData = new ServiceRefMetaData(this, ((ObjectMetaData)this.getParent()).getManagerName());
            serviceRefData.importXML(serviceRefElement);
            this.value = serviceRefData;
            return;
        }
        Element objectElement = FieldMetaData.getOptionalChild(element, "object");
        if (objectElement != null) {
            ObjectMetaData objectData = new ObjectMetaData(((ObjectMetaData)this.getParent()).getServiceLoader(), this, ((ObjectMetaData)this.getParent()).getManagerName());
            objectData.importXML(objectElement);
            this.value = objectData;
            return;
        }
        this.value = FieldMetaData.getElementContent(element);
    }
}

