/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.core;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import jp.ossc.nimbus.core.ArgumentMetaData;
import jp.ossc.nimbus.core.DeploymentException;
import jp.ossc.nimbus.core.MetaData;
import jp.ossc.nimbus.core.ObjectMetaData;
import jp.ossc.nimbus.core.Service;
import org.w3c.dom.Element;

public class InvokeMetaData
extends MetaData
implements Serializable {
    public static final String INVOKE_TAG_NAME = "invoke";
    protected static final String NAME_ATTRIBUTE_NAME = "name";
    protected static final String CALL_STATE_ATTRIBUTE_NAME = "callState";
    protected String name;
    protected final List arguments = new ArrayList();
    protected String callState = Service.STATES[1];
    protected int callStateValue = 1;

    public InvokeMetaData(ObjectMetaData parent) {
        super(parent);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Collection getArguments() {
        return this.arguments;
    }

    public void addArgument(ArgumentMetaData arg) {
        this.arguments.add(arg);
    }

    public String getCallState() {
        return this.callState;
    }

    public void setCallState(String state) throws IllegalArgumentException {
        boolean isMatch = false;
        for (int i = 0; i < Service.STATES.length; ++i) {
            if (!Service.STATES[i].equals(state)) continue;
            this.callStateValue = i;
            this.callState = state;
            isMatch = true;
            break;
        }
        if (!isMatch) {
            throw new IllegalArgumentException("illegal call state : " + state);
        }
    }

    public int getCallStateValue() {
        return this.callStateValue;
    }

    public void importXML(Element element) throws DeploymentException {
        super.importXML(element);
        if (!element.getTagName().equals(INVOKE_TAG_NAME)) {
            throw new DeploymentException("Tag must be invoke : " + element.getTagName());
        }
        this.name = InvokeMetaData.getUniqueAttribute(element, NAME_ATTRIBUTE_NAME);
        Iterator argElements = InvokeMetaData.getChildrenByTagName(element, "argument");
        while (argElements.hasNext()) {
            ArgumentMetaData argData = new ArgumentMetaData(this, (ObjectMetaData)this.getParent());
            argData.importXML((Element)argElements.next());
            this.addArgument(argData);
        }
        this.setCallState(InvokeMetaData.getOptionalAttribute(element, CALL_STATE_ATTRIBUTE_NAME));
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append(super.toString());
        buf.append('{');
        buf.append(NAME_ATTRIBUTE_NAME);
        buf.append('=');
        buf.append(this.getName());
        if (this.arguments.size() != 0) {
            buf.append(',');
            Iterator args = this.arguments.iterator();
            while (args.hasNext()) {
                buf.append(args.next());
                if (!args.hasNext()) continue;
                buf.append(',');
            }
        }
        buf.append('}');
        return buf.toString();
    }
}

