/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.beancontrol;

import java.beans.PropertyEditor;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import jp.ossc.nimbus.beans.NoSuchPropertyException;
import jp.ossc.nimbus.beans.Property;
import jp.ossc.nimbus.beans.PropertyFactory;
import jp.ossc.nimbus.beans.ServiceNameEditor;
import jp.ossc.nimbus.core.DeploymentException;
import jp.ossc.nimbus.core.MetaData;
import jp.ossc.nimbus.core.NimbusClassLoader;
import jp.ossc.nimbus.core.NimbusEntityResolver;
import jp.ossc.nimbus.core.ServiceManagerFactory;
import jp.ossc.nimbus.core.ServiceName;
import jp.ossc.nimbus.core.Utility;
import jp.ossc.nimbus.service.beancontrol.BeanFlowInvokerAccess;
import jp.ossc.nimbus.service.beancontrol.BeanFlowInvokerFactoryCallBack;
import jp.ossc.nimbus.service.beancontrol.interfaces.BeanControlUncheckedException;
import jp.ossc.nimbus.service.beancontrol.interfaces.InvalidConfigurationException;
import jp.ossc.nimbus.service.beancontrol.resource.ResourceManager;
import jp.ossc.nimbus.service.journal.Journal;
import jp.ossc.nimbus.service.resource.TransactionResource;
import jp.ossc.nimbus.service.semaphore.MemorySemaphore;
import jp.ossc.nimbus.service.semaphore.Semaphore;
import org.apache.commons.jexl.Expression;
import org.apache.commons.jexl.ExpressionFactory;
import org.apache.commons.jexl.JexlContext;
import org.apache.commons.jexl.JexlHelper;
import org.w3c.dom.Element;

public class BeanFlowInvokerAccessImpl2
implements BeanFlowInvokerAccess {
    private static final String ARRAY_CLASS_SUFFIX = "[]";
    private static final String ALIAS_ELEMENT = "alias";
    private static final String RESOURCE_ELEMENT = "resource";
    private static final String RESOURCE_REF_ELEMENT = "resource-ref";
    private static final String STEP_ELEMENT = "step";
    private static final String SWITCH_ELEMENT = "switch";
    private static final String CASE_ELEMENT = "case";
    private static final String DEFAULT_ELEMENT = "default";
    private static final String IF_ELEMENT = "if";
    private static final String TARGET_ELEMENT = "target";
    private static final String INPUT_ELEMENT = "input";
    private static final String RESULT_ELEMENT = "result";
    private static final String THIS_ELEMENT = "this";
    private static final String CALL_FLOW_ELEMENT = "callflow";
    private static final String STEP_REF_ELEMENT = "step-ref";
    private static final String RETURN_ELEMENT = "return";
    private static final String FOR_ELEMENT = "for";
    private static final String VAR_ELEMENT = "var";
    private static final String CONTINUE_ELEMENT = "continue";
    private static final String BREAK_ELEMENT = "break";
    private static final String NAME_ATTRIBUTE = "name";
    private static final String KEY_ATTRIBUTE = "key";
    private static final String SERVICE_ATTRIBUTE = "service";
    private static final String TRANCONTROL_ATTRIBUTE = "trancontrol";
    private static final String TRANCLOSE_ATTRIBUTE = "tranclose";
    private static final String TEST_ATTRIBUTE = "test";
    private static final String BEGIN_ATTRIBUTE = "begin";
    private static final String END_ATTRIBUTE = "end";
    private static final String VAR_ATTRIBUTE = "var";
    private static final String RAW_ATTRIBUTE = "raw";
    private static final String MAX_RUN_THREADS_ATTRIBUTE = "maxRunThreads";
    private static final String MAX_WAIT_THREADS_ATTRIBUTE = "maxWaitThreads";
    private static final String TIMEOUT_ATTRIBUTE = "timeout";
    private static final String JOURNAL_KEY_FLOW_NAME = "flowName";
    private static final String JOURNAL_KEY_FLOW = "flow";
    private static final String JOURNAL_KEY_RESOURCE = "resource";
    protected String flowName;
    protected List aliasNames = new ArrayList();
    protected Map resources;
    protected List jobSteps;
    protected Semaphore semaphore;
    protected long timeout = 300000L;
    protected int maxWaitCount = -1;
    protected BeanFlowInvokerFactoryCallBack factoryCallBack;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Object;

    public void fillInstance(Element element, BeanFlowInvokerFactoryCallBack callBack) {
        try {
            String maxWaitCountStr;
            String timeoutStr;
            this.factoryCallBack = callBack;
            this.flowName = MetaData.getUniqueAttribute(element, NAME_ATTRIBUTE);
            String maxThreadsStr = MetaData.getOptionalAttribute(element, MAX_RUN_THREADS_ATTRIBUTE);
            if (maxThreadsStr != null) {
                try {
                    int maxThreads = Integer.parseInt(maxThreadsStr);
                    this.semaphore = new MemorySemaphore();
                    this.semaphore.setResourceCapacity(maxThreads);
                    this.semaphore.accept();
                }
                catch (NumberFormatException e) {
                    throw new InvalidConfigurationException("maxThreads is number " + maxThreadsStr);
                }
            }
            if ((timeoutStr = MetaData.getOptionalAttribute(element, TIMEOUT_ATTRIBUTE)) != null) {
                try {
                    this.timeout = Long.parseLong(timeoutStr);
                }
                catch (NumberFormatException e) {
                    throw new InvalidConfigurationException("timeout is number " + timeoutStr);
                }
            }
            if ((maxWaitCountStr = MetaData.getOptionalAttribute(element, MAX_WAIT_THREADS_ATTRIBUTE)) != null) {
                try {
                    this.maxWaitCount = Integer.parseInt(maxWaitCountStr);
                }
                catch (NumberFormatException e) {
                    throw new InvalidConfigurationException("maxWaitThreads is number " + maxWaitCountStr);
                }
            }
            Iterator aliasElements = MetaData.getChildrenByTagName(element, ALIAS_ELEMENT);
            while (aliasElements.hasNext()) {
                this.aliasNames.add(MetaData.getUniqueAttribute((Element)aliasElements.next(), NAME_ATTRIBUTE));
            }
            ServiceNameEditor editor = new ServiceNameEditor();
            Iterator resourceElements = MetaData.getChildrenByTagName(element, "resource");
            while (resourceElements.hasNext()) {
                Element resourceElement = (Element)resourceElements.next();
                String name = MetaData.getUniqueAttribute(resourceElement, NAME_ATTRIBUTE);
                String key = MetaData.getOptionalAttribute(resourceElement, KEY_ATTRIBUTE);
                String serviceNameStr = MetaData.getUniqueAttribute(resourceElement, SERVICE_ATTRIBUTE);
                editor.setAsText(serviceNameStr);
                ServiceName serviceName = (ServiceName)editor.getValue();
                boolean isTranControl = MetaData.getOptionalBooleanAttribute(resourceElement, TRANCONTROL_ATTRIBUTE);
                boolean isTranClose = MetaData.getOptionalBooleanAttribute(resourceElement, TRANCLOSE_ATTRIBUTE, true);
                ResourceInfo resourceInfo = new ResourceInfo();
                resourceInfo.name = name;
                resourceInfo.key = key;
                resourceInfo.serviceName = serviceName;
                resourceInfo.isTranControl = isTranControl;
                resourceInfo.isTranClose = isTranClose;
                if (this.resources == null) {
                    this.resources = new HashMap();
                }
                this.resources.put(name, resourceInfo);
            }
            Iterator children = MetaData.getChildrenWithoutTagName(element, new String[]{ALIAS_ELEMENT, "resource"});
            while (children.hasNext()) {
                Element currentElement = (Element)children.next();
                String tagName = currentElement.getTagName();
                MetaData stepObj = null;
                if (STEP_ELEMENT.equals(tagName)) {
                    StepMetaData step = new StepMetaData();
                    step.importXML(currentElement);
                    stepObj = step;
                } else if (CALL_FLOW_ELEMENT.equals(tagName)) {
                    CallFlowMetaData callFlowData = new CallFlowMetaData();
                    callFlowData.importXML(currentElement);
                    stepObj = callFlowData;
                } else if (SWITCH_ELEMENT.equals(tagName)) {
                    SwitchMetaData sw = new SwitchMetaData();
                    sw.importXML(currentElement);
                    stepObj = sw;
                } else if (IF_ELEMENT.equals(tagName)) {
                    IfMetaData ifData = new IfMetaData();
                    ifData.importXML(currentElement);
                    stepObj = ifData;
                } else if (FOR_ELEMENT.equals(tagName)) {
                    ForMetaData forData = new ForMetaData();
                    forData.importXML(currentElement);
                    stepObj = forData;
                } else {
                    throw new DeploymentException("Invalid child tag of flow tag : " + tagName);
                }
                if (stepObj == null) continue;
                if (this.jobSteps == null) {
                    this.jobSteps = new ArrayList();
                }
                this.jobSteps.add(stepObj);
            }
        }
        catch (DeploymentException e) {
            throw new InvalidConfigurationException(e);
        }
    }

    public String getFlowName() {
        return this.flowName;
    }

    public List getAiliasFlowNames() {
        return this.aliasNames;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object invokeFlow(Object input) throws Exception {
        Object output = null;
        if (this.factoryCallBack.isManageExecBeanFlow()) {
            this.factoryCallBack.addExcecFlowName(this.flowName);
        }
        FlowContext flowContext = null;
        Journal journal = this.factoryCallBack.getJournal();
        try {
            if (this.semaphore != null) {
                this.semaphore.getResource(this.timeout, this.maxWaitCount);
            }
            if (journal != null) {
                journal.addStartStep(JOURNAL_KEY_FLOW);
                journal.addInfo(JOURNAL_KEY_FLOW_NAME, this.flowName);
            }
            ResourceManager rm = this.factoryCallBack.createResourceManager();
            HashMap execBeanMap = new HashMap();
            if (this.resources != null) {
                Iterator ite = this.resources.keySet().iterator();
                while (ite.hasNext()) {
                    String name = (String)ite.next();
                    ResourceInfo resourceInfo = (ResourceInfo)this.resources.get(name);
                    rm.addResource(name, resourceInfo.key, resourceInfo.serviceName, resourceInfo.isTranControl, resourceInfo.isTranClose);
                    if (journal == null) continue;
                    journal.addInfo("resource", name);
                }
            }
            flowContext = new FlowContext(input, rm);
            try {
                if (this.jobSteps != null) {
                    Step jobStep;
                    StepContext stepContext;
                    int max = this.jobSteps.size();
                    for (int i = 0; i < max && (stepContext = (jobStep = (Step)this.jobSteps.get(i)).invokeStep(flowContext)) != null; ++i) {
                    }
                }
            }
            catch (InvocationTargetException e) {
                Throwable th = e.getTargetException();
                this.endJob(th, rm, this.flowName);
                if (th instanceof Exception) {
                    Exception ee = (Exception)th;
                    throw ee;
                }
                throw new BeanControlUncheckedException("Target Error occured", th);
            }
            catch (Throwable th) {
                this.endJob(th, rm, this.flowName);
                throw new BeanControlUncheckedException("Target Error occured", th);
            }
            this.endJob(null, rm, this.flowName);
            Object var12_15 = null;
            if (journal != null) {
                journal.addEndStep();
            }
            if (this.semaphore != null) {
                this.semaphore.freeResource();
            }
        }
        catch (Throwable throwable) {
            Object var12_16 = null;
            if (journal != null) {
                journal.addEndStep();
            }
            if (this.semaphore != null) {
                this.semaphore.freeResource();
            }
            throw throwable;
        }
        return flowContext.current.result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void endJob(Throwable e, ResourceManager rm, String name) {
        try {
            if (e == null) {
                rm.commitAllResources();
            } else {
                rm.rollbbackAllResources();
            }
            Object var5_4 = null;
            if (this.factoryCallBack.isManageExecBeanFlow()) {
                this.factoryCallBack.removeExecList(name);
            }
            rm.terminateResourceManager();
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            if (this.factoryCallBack.isManageExecBeanFlow()) {
                this.factoryCallBack.removeExecList(name);
            }
            rm.terminateResourceManager();
            throw throwable;
        }
    }

    private String replaceProperty(String textValue) {
        textValue = Utility.replaceServiceLoderConfig(textValue, this.factoryCallBack.getServiceLoader().getConfig());
        textValue = Utility.replaceManagerProperty(this.factoryCallBack.getServiceManager(), textValue);
        textValue = Utility.replaceServerProperty(textValue);
        textValue = Utility.replaceSystemProperty(textValue);
        return textValue;
    }

    private Class convertStringToClass(String typeStr) throws ClassNotFoundException {
        Class<Comparable<Byte>> type = null;
        if (typeStr != null) {
            if (Byte.TYPE.getName().equals(typeStr)) {
                type = Byte.TYPE;
            } else if (Character.TYPE.getName().equals(typeStr)) {
                type = Character.TYPE;
            } else if (Short.TYPE.getName().equals(typeStr)) {
                type = Short.TYPE;
            } else if (Integer.TYPE.getName().equals(typeStr)) {
                type = Integer.TYPE;
            } else if (Long.TYPE.getName().equals(typeStr)) {
                type = Long.TYPE;
            } else if (Float.TYPE.getName().equals(typeStr)) {
                type = Float.TYPE;
            } else if (Double.TYPE.getName().equals(typeStr)) {
                type = Double.TYPE;
            } else if (Boolean.TYPE.getName().equals(typeStr)) {
                type = Boolean.TYPE;
            } else if (typeStr.endsWith(ARRAY_CLASS_SUFFIX) && typeStr.length() > 2) {
                Class elementType = this.convertStringToClass(typeStr.substring(0, typeStr.length() - 2));
                type = Array.newInstance(elementType, 0).getClass();
            } else {
                type = Class.forName(typeStr, true, NimbusClassLoader.getInstance());
            }
        }
        return type;
    }

    static {
        NimbusEntityResolver.registerDTD("-//Nimbus//DTD Nimbus Bean Flow 1.0//JA", "jp/ossc/nimbus/service/beancontrol/beanflow_1_0.dtd");
    }

    private class Test {
        public List properties;
        public Expression expression;
        public List keyList = new ArrayList();
        private static final String INPUT = "input";
        private static final String VAR = "var";
        private static final String TARGET = "target";
        private static final String RESULT = "result";
        private static final String DELIMITER = "@";

        public Test(String cond) throws Exception {
            this.properties = new ArrayList();
            StringTokenizer token = new StringTokenizer(cond, DELIMITER, true);
            boolean keyFlg = false;
            String beforeToken = null;
            StringBuffer condBuf = new StringBuffer();
            while (token.hasMoreTokens()) {
                String str = token.nextToken();
                if (!keyFlg) {
                    if (DELIMITER.equals(str)) {
                        keyFlg = true;
                    } else {
                        condBuf.append(str);
                    }
                } else if (DELIMITER.equals(str)) {
                    keyFlg = false;
                    if (beforeToken != null) {
                        String tmpKey = "_evaluatectgyserv" + this.keyList.size();
                        this.keyList.add(tmpKey);
                        condBuf.append(tmpKey);
                        if (!beforeToken.startsWith("input") && !beforeToken.startsWith("var")) {
                            int index = 0;
                            int dotIndex = beforeToken.indexOf(46);
                            int braket1Index = beforeToken.indexOf(40);
                            int braket2Index = beforeToken.indexOf(91);
                            if (dotIndex == -1 && braket1Index == -1 && braket2Index == -1) {
                                beforeToken = beforeToken + '.' + "result";
                            } else {
                                String tmp;
                                if (dotIndex == beforeToken.length() - 1 || braket1Index == beforeToken.length() - 1 || braket2Index == beforeToken.length() - 1) {
                                    throw new DeploymentException("Invalid key of test : " + beforeToken);
                                }
                                index = dotIndex;
                                if (index == -1 || braket1Index != -1 && index > braket1Index) {
                                    index = braket1Index;
                                }
                                if (index == -1 || braket2Index != -1 && index > braket2Index) {
                                    index = braket2Index;
                                }
                                if (!((tmp = beforeToken.substring(index + 1)).startsWith("target.") || tmp.startsWith("target(") || tmp.startsWith("target[") || tmp.startsWith("result.") || tmp.startsWith("result(") || tmp.startsWith("result["))) {
                                    beforeToken = beforeToken.substring(0, index) + '.' + "result" + beforeToken.substring(index);
                                }
                            }
                        }
                        this.properties.add(PropertyFactory.createProperty(beforeToken));
                    } else {
                        condBuf.append(str);
                    }
                }
                beforeToken = str;
            }
            if (this.keyList.size() == 0) {
                throw new IllegalArgumentException(cond);
            }
            this.expression = ExpressionFactory.createExpression((String)condBuf.toString());
            this.evaluate("");
        }

        public boolean evaluate(Object object) throws Exception {
            JexlContext jexlContext = JexlHelper.createContext();
            int size = this.keyList.size();
            for (int i = 0; i < size; ++i) {
                String keyString = (String)this.keyList.get(i);
                Property property = (Property)this.properties.get(i);
                Object val = null;
                try {
                    val = property.getProperty(object);
                }
                catch (NoSuchPropertyException e) {
                }
                catch (InvocationTargetException e) {
                    // empty catch block
                }
                jexlContext.getVars().put(keyString, val);
            }
            Object exp = this.expression.evaluate(jexlContext);
            if (exp instanceof Boolean) {
                return (Boolean)exp;
            }
            throw new IllegalArgumentException("expression is not boolean : " + this.expression.getExpression());
        }
    }

    public class StepContext {
        public Object target;
        public Object result;
        public boolean isContinue = false;

        public Object getTarget() {
            return this.target;
        }

        public Object getResult() {
            return this.result;
        }
    }

    public class FlowContext
    extends HashMap {
        public Object input;
        public ResourceManager resourceManager;
        public StepContext current;
        private Map vars;

        public FlowContext(Object in, ResourceManager rm) {
            this.input = in;
            this.resourceManager = rm;
        }

        public Object getInput() {
            return this.input;
        }

        public Object getVar(String name) {
            if (this.vars == null) {
                return null;
            }
            return this.vars.get(name);
        }

        public void setVar(String name, Object var) {
            if (this.vars == null) {
                this.vars = new HashMap();
            }
            this.vars.put(name, var);
        }
    }

    private class IfMetaData
    extends MetaData
    implements Step {
        private Test test;
        private List steps;
        private boolean isContinue;

        public void importXML(Element element) throws DeploymentException {
            String tagName = element.getTagName();
            if (!BeanFlowInvokerAccessImpl2.DEFAULT_ELEMENT.equals(tagName)) {
                String testAttribute = IfMetaData.getUniqueAttribute(element, BeanFlowInvokerAccessImpl2.TEST_ATTRIBUTE);
                try {
                    this.test = new Test(testAttribute);
                }
                catch (Exception e) {
                    throw new DeploymentException(e);
                }
            }
            boolean isReturn = false;
            Iterator children = IfMetaData.getChildren(element);
            while (children.hasNext()) {
                Element currentElement = (Element)children.next();
                tagName = currentElement.getTagName();
                if (isReturn) {
                    throw new DeploymentException("Unreachable element : " + tagName);
                }
                MetaData stepObj = null;
                if (BeanFlowInvokerAccessImpl2.STEP_ELEMENT.equals(tagName)) {
                    StepMetaData step = new StepMetaData();
                    step.importXML(currentElement);
                    stepObj = step;
                } else if (BeanFlowInvokerAccessImpl2.SWITCH_ELEMENT.equals(tagName)) {
                    SwitchMetaData sw = new SwitchMetaData();
                    sw.importXML(currentElement);
                    stepObj = sw;
                } else if (BeanFlowInvokerAccessImpl2.IF_ELEMENT.equals(tagName)) {
                    IfMetaData ifData = new IfMetaData();
                    ifData.importXML(currentElement);
                    stepObj = ifData;
                } else if (BeanFlowInvokerAccessImpl2.FOR_ELEMENT.equals(tagName)) {
                    ForMetaData forData = new ForMetaData();
                    forData.importXML(currentElement);
                    stepObj = forData;
                } else if (BeanFlowInvokerAccessImpl2.CALL_FLOW_ELEMENT.equals(tagName)) {
                    CallFlowMetaData callFlowData = new CallFlowMetaData();
                    callFlowData.importXML(currentElement);
                    stepObj = callFlowData;
                } else if (BeanFlowInvokerAccessImpl2.BREAK_ELEMENT.equals(tagName)) {
                    isReturn = true;
                } else if (BeanFlowInvokerAccessImpl2.CONTINUE_ELEMENT.equals(tagName)) {
                    isReturn = true;
                    this.isContinue = true;
                } else if (BeanFlowInvokerAccessImpl2.RETURN_ELEMENT.equals(tagName)) {
                    isReturn = true;
                } else {
                    throw new DeploymentException("Invalid child tag of if : " + tagName);
                }
                if (this.steps == null) {
                    this.steps = new ArrayList();
                }
                this.steps.add(stepObj);
            }
            if (this.steps == null) {
                throw new DeploymentException("if body is empty.");
            }
        }

        public boolean isMatch(FlowContext context) throws Exception {
            return this.test == null ? true : this.test.evaluate(context);
        }

        public StepContext invokeStep(FlowContext context) throws Exception {
            StepContext stepContext = null;
            if (this.isMatch(context)) {
                Iterator itr = this.steps.iterator();
                while (itr.hasNext()) {
                    Step step = (Step)itr.next();
                    if (step == null) {
                        if (this.isContinue) {
                            if (stepContext == null) {
                                stepContext = new StepContext();
                            }
                            stepContext.isContinue = true;
                        } else {
                            return null;
                        }
                    }
                    if ((stepContext = step.invokeStep(context)) != null) continue;
                    return null;
                }
            } else {
                stepContext = new StepContext();
            }
            return stepContext;
        }
    }

    private class SwitchMetaData
    extends MetaData
    implements Step {
        private List cases = new ArrayList();
        private IfMetaData defaultData;

        public void importXML(Element element) throws DeploymentException {
            Iterator children = SwitchMetaData.getChildren(element);
            while (children.hasNext()) {
                IfMetaData ifData;
                Element currentElement = (Element)children.next();
                String tagName = currentElement.getTagName();
                if (BeanFlowInvokerAccessImpl2.CASE_ELEMENT.equals(tagName)) {
                    ifData = new IfMetaData();
                    ifData.importXML(currentElement);
                    this.cases.add(ifData);
                    continue;
                }
                if (BeanFlowInvokerAccessImpl2.DEFAULT_ELEMENT.equals(tagName)) {
                    ifData = new IfMetaData();
                    ifData.importXML(currentElement);
                    this.defaultData = ifData;
                    continue;
                }
                throw new DeploymentException("Invalid child tag of switch : " + tagName);
            }
            if (this.cases.size() == 0) {
                throw new DeploymentException("Case tag dose not exist.");
            }
        }

        public StepContext invokeStep(FlowContext context) throws Exception {
            Iterator itr = this.cases.iterator();
            while (itr.hasNext()) {
                IfMetaData ifData = (IfMetaData)itr.next();
                if (!ifData.isMatch(context)) continue;
                return ifData.invokeStep(context);
            }
            if (this.defaultData == null) {
                return new StepContext();
            }
            return this.defaultData.invokeStep(context);
        }
    }

    private class ForMetaData
    extends MetaData
    implements Step {
        private MetaData targetData;
        private String varName;
        private int begin = 0;
        private int end = -1;
        private List steps;

        public void importXML(Element element) throws DeploymentException {
            Element targetElement;
            Element childElement;
            String tagName;
            String endStr;
            this.varName = ForMetaData.getUniqueAttribute(element, "var");
            String beginStr = ForMetaData.getOptionalAttribute(element, BeanFlowInvokerAccessImpl2.BEGIN_ATTRIBUTE);
            if (beginStr != null) {
                try {
                    this.begin = Integer.parseInt(beginStr);
                }
                catch (NumberFormatException e) {
                    throw new DeploymentException(e);
                }
            }
            if ((endStr = ForMetaData.getOptionalAttribute(element, BeanFlowInvokerAccessImpl2.END_ATTRIBUTE)) != null) {
                try {
                    this.end = Integer.parseInt(endStr);
                }
                catch (NumberFormatException e) {
                    throw new DeploymentException(e);
                }
            }
            if (BeanFlowInvokerAccessImpl2.INPUT_ELEMENT.equals(tagName = (childElement = ForMetaData.getUniqueChild(targetElement = ForMetaData.getUniqueChild(element, BeanFlowInvokerAccessImpl2.TARGET_ELEMENT))).getTagName())) {
                this.targetData = new InputMetaData();
                this.targetData.importXML(childElement);
            } else if ("object".equals(tagName)) {
                this.targetData = new ObjectMetaData(this);
                this.targetData.importXML(childElement);
            } else if ("service-ref".equals(tagName)) {
                this.targetData = new ServiceRefMetaData(this);
                this.targetData.importXML(childElement);
            } else if (BeanFlowInvokerAccessImpl2.RESOURCE_REF_ELEMENT.equals(tagName)) {
                this.targetData = new ReourceRefMetaData();
                this.targetData.importXML(childElement);
            } else if (BeanFlowInvokerAccessImpl2.STEP_REF_ELEMENT.equals(tagName)) {
                this.targetData = new StepRefMetaData();
                this.targetData.importXML(childElement);
            } else if ("var".equals(tagName)) {
                this.targetData = new VarMetaData();
                this.targetData.importXML(childElement);
            } else {
                throw new DeploymentException("Invalid child tag of target tag : " + tagName);
            }
            Iterator children = ForMetaData.getChildrenWithoutTagName(element, new String[]{BeanFlowInvokerAccessImpl2.TARGET_ELEMENT});
            while (children.hasNext()) {
                Element currentElement = (Element)children.next();
                tagName = currentElement.getTagName();
                MetaData stepObj = null;
                if (BeanFlowInvokerAccessImpl2.STEP_ELEMENT.equals(tagName)) {
                    StepMetaData step = new StepMetaData();
                    step.importXML(currentElement);
                    stepObj = step;
                } else if (BeanFlowInvokerAccessImpl2.SWITCH_ELEMENT.equals(tagName)) {
                    SwitchMetaData sw = new SwitchMetaData();
                    sw.importXML(currentElement);
                    stepObj = sw;
                } else if (BeanFlowInvokerAccessImpl2.IF_ELEMENT.equals(tagName)) {
                    IfMetaData ifData = new IfMetaData();
                    ifData.importXML(currentElement);
                    stepObj = ifData;
                } else if (BeanFlowInvokerAccessImpl2.CALL_FLOW_ELEMENT.equals(tagName)) {
                    CallFlowMetaData callFlowData = new CallFlowMetaData();
                    callFlowData.importXML(currentElement);
                    stepObj = callFlowData;
                } else if (BeanFlowInvokerAccessImpl2.FOR_ELEMENT.equals(tagName)) {
                    ForMetaData forData = new ForMetaData();
                    forData.importXML(currentElement);
                    stepObj = forData;
                } else {
                    throw new DeploymentException("Invalid child tag of if : " + tagName);
                }
                if (this.steps == null) {
                    this.steps = new ArrayList();
                }
                if (stepObj == null) continue;
                this.steps.add(stepObj);
            }
            if (this.steps == null) {
                throw new DeploymentException("for body is empty.");
            }
        }

        public StepContext invokeStep(FlowContext context) throws Exception {
            Object target = ((ReturnValue)((Object)this.targetData)).getValue(context);
            if (target == null) {
                return new StepContext();
            }
            StepContext stepContext = null;
            if (target.getClass().isArray()) {
                int length = Array.getLength(target);
                if (this.begin < length) {
                    int max;
                    int n = max = this.end > 0 && this.end < length ? this.end : length;
                    block0: for (int i = this.begin; i < max; ++i) {
                        Object var = Array.get(target, i);
                        context.setVar(this.varName, var);
                        Iterator itr = this.steps.iterator();
                        while (itr.hasNext()) {
                            Step step = (Step)itr.next();
                            stepContext = step.invokeStep(context);
                            if (stepContext == null) {
                                return null;
                            }
                            if (!stepContext.isContinue) continue;
                            continue block0;
                        }
                    }
                }
            } else if (target instanceof ResultSet) {
                ResultSet resultSet = (ResultSet)target;
                int index = 0;
                while (resultSet.next()) {
                    context.setVar(this.varName, resultSet);
                    if (index >= this.begin) {
                        Iterator itr2 = this.steps.iterator();
                        while (itr2.hasNext()) {
                            Step step = (Step)itr2.next();
                            stepContext = step.invokeStep(context);
                            if (stepContext == null) {
                                return null;
                            }
                            if (!stepContext.isContinue) continue;
                            break;
                        }
                    }
                    if (this.end == -1 || index < this.end) {
                        ++index;
                        continue;
                    }
                    break;
                }
            } else {
                Collection col = (Collection)target;
                int index = 0;
                Iterator itr = col.iterator();
                while (itr.hasNext()) {
                    Object var = itr.next();
                    context.setVar(this.varName, var);
                    if (index >= this.begin) {
                        Iterator itr2 = this.steps.iterator();
                        while (itr2.hasNext()) {
                            Step step = (Step)itr2.next();
                            stepContext = step.invokeStep(context);
                            if (stepContext == null) {
                                return null;
                            }
                            if (!stepContext.isContinue) continue;
                            break;
                        }
                    }
                    if (this.end == -1 || index < this.end) {
                        ++index;
                        continue;
                    }
                    break;
                }
            }
            if (stepContext == null) {
                stepContext = new StepContext();
            }
            return stepContext;
        }
    }

    private class CallFlowMetaData
    extends MetaData
    implements Step {
        private String name;
        private ReturnValue inputData;

        public void importXML(Element element) throws DeploymentException {
            this.name = CallFlowMetaData.getUniqueAttribute(element, BeanFlowInvokerAccessImpl2.NAME_ATTRIBUTE);
            Element argElement = CallFlowMetaData.getOptionalChild(element, "argument");
            if (argElement != null) {
                ArgumentMetaData argData = new ArgumentMetaData(this, null);
                argData.importXML(argElement);
                this.inputData = argData;
            }
        }

        public StepContext invokeStep(FlowContext context) throws Exception {
            StepContext stepContext;
            context.current = stepContext = new StepContext();
            context.put(this.name, stepContext);
            Object input = null;
            if (this.inputData != null) {
                input = this.inputData.getValue(context);
            }
            stepContext.result = BeanFlowInvokerAccessImpl2.this.factoryCallBack.createFlow(this.name).invokeFlow(input);
            return stepContext;
        }
    }

    private class StepRefMetaData
    extends MetaData
    implements ReturnValue {
        private static final String TARGET = "target";
        private static final String RESULT = "result";
        private Property property;

        public void importXML(Element element) throws DeploymentException {
            String val = StepRefMetaData.getElementContent(element);
            if (val == null) {
                throw new DeploymentException("Content of step-result is null.");
            }
            int index = 0;
            int dotIndex = val.indexOf(46);
            int braket1Index = val.indexOf(40);
            int braket2Index = val.indexOf(91);
            if (dotIndex == -1 && braket1Index == -1 && braket2Index == -1) {
                val = val + '.' + "result";
            } else {
                String tmp;
                if (dotIndex == val.length() - 1 || braket1Index == val.length() - 1 || braket2Index == val.length() - 1) {
                    throw new DeploymentException("Invalid content of step-result : " + val);
                }
                index = dotIndex;
                if (index == -1 || braket1Index != -1 && index > braket1Index) {
                    index = braket1Index;
                }
                if (index == -1 || braket2Index != -1 && index > braket2Index) {
                    index = braket2Index;
                }
                if (!((tmp = val.substring(index + 1)).startsWith("target.") || tmp.startsWith("target(") || tmp.startsWith("target[") || tmp.startsWith("result.") || tmp.startsWith("result(") || tmp.startsWith("result["))) {
                    val = val.substring(0, index) + '.' + "result" + val.substring(index);
                }
            }
            try {
                this.property = PropertyFactory.createProperty(val);
            }
            catch (Exception e) {
                throw new DeploymentException(e);
            }
        }

        public Object getValue(FlowContext context) throws Exception {
            return this.property.getProperty(context);
        }
    }

    private class VarMetaData
    extends MetaData
    implements ReturnValue {
        private String name;
        private Property property;

        public void importXML(Element element) throws DeploymentException {
            String val = VarMetaData.getElementContent(element);
            if (val == null) {
                throw new DeploymentException("Var name is null.");
            }
            int dotIndex = val.indexOf(46);
            int braket1Index = val.indexOf(40);
            int braket2Index = val.indexOf(91);
            if (dotIndex == -1 && braket1Index == -1 && braket2Index == -1) {
                this.name = val;
            } else {
                int index = dotIndex;
                int index2 = dotIndex + 1;
                if (index == -1 || braket1Index != -1 && index > braket1Index) {
                    index = braket1Index;
                    index2 = braket1Index;
                }
                if (index == -1 || braket2Index != -1 && index > braket2Index) {
                    index = braket2Index;
                    index2 = braket2Index;
                }
                this.name = val.substring(0, index);
                if (index < val.length() - 1) {
                    String prop = val.substring(index2);
                    try {
                        this.property = PropertyFactory.createProperty(prop);
                    }
                    catch (Exception e) {
                        throw new DeploymentException(e);
                    }
                }
            }
        }

        public Object getValue(FlowContext context) throws Exception {
            Object var = context.getVar(this.name);
            if (var == null) {
                return null;
            }
            if (this.property == null) {
                return var;
            }
            return this.property.getProperty(var);
        }
    }

    private class ThisMetaData
    extends MetaData
    implements ReturnValue {
        private Property property;

        public void importXML(Element element) throws DeploymentException {
            String val = ThisMetaData.getElementContent(element);
            if (val != null && val.length() != 0) {
                try {
                    this.property = PropertyFactory.createProperty(val);
                }
                catch (Exception e) {
                    throw new DeploymentException(e);
                }
            }
        }

        public Object getValue(FlowContext context) throws Exception {
            Object target = context.current.target;
            if (target == null) {
                return null;
            }
            if (this.property == null) {
                return target;
            }
            return this.property.getProperty(target);
        }
    }

    private class ReourceRefMetaData
    extends MetaData
    implements ReturnValue {
        private String name;
        private boolean isRaw;

        public ReourceRefMetaData() {
            super(null);
        }

        public void importXML(Element element) throws DeploymentException {
            this.name = ReourceRefMetaData.getElementContent(element);
            if (this.name == null) {
                throw new DeploymentException("Resource name is null.");
            }
            this.isRaw = ReourceRefMetaData.getOptionalBooleanAttribute(element, BeanFlowInvokerAccessImpl2.RAW_ATTRIBUTE, false);
        }

        public Object getValue(FlowContext context) throws Exception {
            TransactionResource resource = (TransactionResource)context.resourceManager.getResource(this.name);
            return this.isRaw ? resource : resource.getObject();
        }
    }

    private class ServiceRefMetaData
    extends jp.ossc.nimbus.core.ServiceRefMetaData
    implements ReturnValue {
        public ServiceRefMetaData(MetaData parent) {
            super(parent);
        }

        public Object getValue(FlowContext context) throws Exception {
            return ServiceManagerFactory.getServiceObject(this.getManagerName(), this.getServiceName());
        }
    }

    private class InvokeMetaData
    extends jp.ossc.nimbus.core.InvokeMetaData
    implements ReturnValue {
        public InvokeMetaData() {
            super(null);
        }

        public void importXML(Element element) throws DeploymentException {
            if (!element.getTagName().equals("invoke")) {
                throw new DeploymentException("Tag must be invoke : " + element.getTagName());
            }
            this.name = InvokeMetaData.getUniqueAttribute(element, BeanFlowInvokerAccessImpl2.NAME_ATTRIBUTE);
            Iterator argElements = InvokeMetaData.getChildrenByTagName(element, "argument");
            while (argElements.hasNext()) {
                ArgumentMetaData argData = new ArgumentMetaData(this, null);
                argData.importXML((Element)argElements.next());
                this.addArgument(argData);
            }
        }

        public Object getValue(FlowContext context) throws Exception {
            Class<?> targetClass = context.current.target.getClass();
            ArrayList paramTypes = new ArrayList();
            ArrayList<Object> params = new ArrayList<Object>();
            Iterator argDatas = this.getArguments().iterator();
            while (argDatas.hasNext()) {
                ArgumentMetaData argData = (ArgumentMetaData)argDatas.next();
                Object arg = argData.getValue(context);
                params.add(arg);
                Class<?> typeClass = argData.getTypeClass();
                if (typeClass == null) {
                    if (arg == null) {
                        throw new InvalidConfigurationException("Type is unknown : " + argData);
                    }
                    typeClass = arg.getClass();
                }
                paramTypes.add(typeClass);
            }
            Method method = targetClass.getMethod(this.name, paramTypes.toArray(new Class[paramTypes.size()]));
            return method.invoke(context.current.target, params.toArray());
        }
    }

    private class AttributeMetaData
    extends jp.ossc.nimbus.core.AttributeMetaData
    implements ReturnValue,
    SetValue {
        public AttributeMetaData(ObjectMetaData parent) {
            super(parent);
        }

        public void importXML(Element element) throws DeploymentException {
            if (!element.getTagName().equals("attribute")) {
                throw new DeploymentException("Tag must be attribute : " + element.getTagName());
            }
            this.name = AttributeMetaData.getUniqueAttribute(element, BeanFlowInvokerAccessImpl2.NAME_ATTRIBUTE);
            this.type = AttributeMetaData.getOptionalAttribute(element, "type");
            Element serviceRefElement = AttributeMetaData.getOptionalChild(element, "service-ref");
            if (serviceRefElement != null) {
                ServiceRefMetaData serviceRefData = new ServiceRefMetaData(this);
                serviceRefData.importXML(serviceRefElement);
                this.value = serviceRefData;
                return;
            }
            Element objectElement = AttributeMetaData.getOptionalChild(element, "object");
            if (objectElement != null) {
                ObjectMetaData objectData = new ObjectMetaData(this);
                objectData.importXML(objectElement);
                this.value = objectData;
                return;
            }
            Element inputElement = AttributeMetaData.getOptionalChild(element, BeanFlowInvokerAccessImpl2.INPUT_ELEMENT);
            if (inputElement != null) {
                InputMetaData inputData = new InputMetaData();
                inputData.importXML(inputElement);
                this.value = inputData;
                return;
            }
            Element stepRefElement = AttributeMetaData.getOptionalChild(element, BeanFlowInvokerAccessImpl2.STEP_REF_ELEMENT);
            if (stepRefElement != null) {
                StepRefMetaData stepRefData = new StepRefMetaData();
                stepRefData.importXML(stepRefElement);
                this.value = stepRefData;
                return;
            }
            Element thisElement = AttributeMetaData.getOptionalChild(element, BeanFlowInvokerAccessImpl2.THIS_ELEMENT);
            if (thisElement != null) {
                ThisMetaData thisData = new ThisMetaData();
                thisData.importXML(thisElement);
                this.value = thisData;
                return;
            }
            Element resourceRefElement = AttributeMetaData.getOptionalChild(element, BeanFlowInvokerAccessImpl2.RESOURCE_REF_ELEMENT);
            if (resourceRefElement != null) {
                ReourceRefMetaData resourceRefData = new ReourceRefMetaData();
                resourceRefData.importXML(resourceRefElement);
                this.value = resourceRefData;
                return;
            }
            Element varElement = AttributeMetaData.getOptionalChild(element, "var");
            if (varElement != null) {
                VarMetaData varData = new VarMetaData();
                varData.importXML(varElement);
                this.value = varData;
                return;
            }
            this.value = AttributeMetaData.getElementContent(element);
        }

        public void setValue(FlowContext context) throws Exception {
            String name = this.getName();
            Object value = this.getValue();
            Property prop = PropertyFactory.createProperty(name);
            if (value instanceof ReturnValue) {
                value = ((ReturnValue)value).getValue(context);
            } else {
                PropertyEditor editor;
                Class type = null;
                type = this.getType() != null ? BeanFlowInvokerAccessImpl2.this.convertStringToClass(this.getType()) : prop.getPropertyType(context.current.target);
                if (type == null || (class$java$lang$Object == null ? (class$java$lang$Object = BeanFlowInvokerAccessImpl2.class$("java.lang.Object")) : class$java$lang$Object).equals(type)) {
                    Class clazz = type = class$java$lang$String == null ? (class$java$lang$String = BeanFlowInvokerAccessImpl2.class$("java.lang.String")) : class$java$lang$String;
                }
                if ((editor = BeanFlowInvokerAccessImpl2.this.factoryCallBack.findPropEditor(type)) == null) {
                    throw new InvalidConfigurationException("PropertyEditor not found : " + type.getName());
                }
                editor.setAsText(BeanFlowInvokerAccessImpl2.this.replaceProperty((String)value));
                value = editor.getValue();
            }
            prop.setProperty(context.current.target, value);
        }

        public Object getValue(FlowContext context) throws Exception {
            String name = this.getName();
            Property prop = PropertyFactory.createProperty(name);
            return prop.getProperty(context.current.target);
        }
    }

    private class FieldMetaData
    extends jp.ossc.nimbus.core.FieldMetaData
    implements ReturnValue,
    SetValue {
        public FieldMetaData(ObjectMetaData parent) {
            super(parent);
        }

        public void importXML(Element element) throws DeploymentException {
            if (!element.getTagName().equals("field")) {
                throw new DeploymentException("Tag must be field : " + element.getTagName());
            }
            this.name = FieldMetaData.getUniqueAttribute(element, BeanFlowInvokerAccessImpl2.NAME_ATTRIBUTE);
            this.type = FieldMetaData.getOptionalAttribute(element, "type");
            Element serviceRefElement = FieldMetaData.getOptionalChild(element, "service-ref");
            if (serviceRefElement != null) {
                ServiceRefMetaData serviceRefData = new ServiceRefMetaData(this);
                serviceRefData.importXML(serviceRefElement);
                this.value = serviceRefData;
                return;
            }
            Element objectElement = FieldMetaData.getOptionalChild(element, "object");
            if (objectElement != null) {
                ObjectMetaData objectData = new ObjectMetaData(this);
                objectData.importXML(objectElement);
                this.value = objectData;
                return;
            }
            Element inputElement = FieldMetaData.getOptionalChild(element, BeanFlowInvokerAccessImpl2.INPUT_ELEMENT);
            if (inputElement != null) {
                InputMetaData inputData = new InputMetaData();
                inputData.importXML(inputElement);
                this.value = inputData;
                return;
            }
            Element stepRefElement = FieldMetaData.getOptionalChild(element, BeanFlowInvokerAccessImpl2.STEP_REF_ELEMENT);
            if (stepRefElement != null) {
                StepRefMetaData stepRefData = new StepRefMetaData();
                stepRefData.importXML(stepRefElement);
                this.value = stepRefData;
                return;
            }
            Element thisElement = FieldMetaData.getOptionalChild(element, BeanFlowInvokerAccessImpl2.THIS_ELEMENT);
            if (thisElement != null) {
                ThisMetaData thisData = new ThisMetaData();
                thisData.importXML(thisElement);
                this.value = thisData;
                return;
            }
            Element resourceRefElement = FieldMetaData.getOptionalChild(element, BeanFlowInvokerAccessImpl2.RESOURCE_REF_ELEMENT);
            if (resourceRefElement != null) {
                ReourceRefMetaData resourceRefData = new ReourceRefMetaData();
                resourceRefData.importXML(resourceRefElement);
                this.value = resourceRefData;
                return;
            }
            Element varElement = FieldMetaData.getOptionalChild(element, "var");
            if (varElement != null) {
                VarMetaData varData = new VarMetaData();
                varData.importXML(varElement);
                this.value = varData;
                return;
            }
            this.value = FieldMetaData.getElementContent(element);
        }

        public void setValue(FlowContext context) throws Exception {
            String name = this.getName();
            Class<?> targetClazz = context.current.target.getClass();
            Field f = null;
            try {
                f = targetClazz.getField(name);
            }
            catch (NoSuchFieldException e) {
                if (name.length() != 0 && Character.isUpperCase(name.charAt(0))) {
                    StringBuffer tmpName = new StringBuffer();
                    tmpName.append(Character.toLowerCase(name.charAt(0)));
                    if (name.length() > 1) {
                        tmpName.append(name.substring(1));
                    }
                    f = targetClazz.getField(tmpName.toString());
                }
                throw e;
            }
            Object value = this.getValue();
            if (value instanceof ReturnValue) {
                value = ((ReturnValue)value).getValue(context);
            } else {
                PropertyEditor editor;
                Class type = null;
                type = this.getType() != null ? BeanFlowInvokerAccessImpl2.this.convertStringToClass(this.getType()) : f.getType();
                if (type == null || (class$java$lang$Object == null ? (class$java$lang$Object = BeanFlowInvokerAccessImpl2.class$("java.lang.Object")) : class$java$lang$Object).equals(type)) {
                    Class clazz = type = class$java$lang$String == null ? (class$java$lang$String = BeanFlowInvokerAccessImpl2.class$("java.lang.String")) : class$java$lang$String;
                }
                if ((editor = BeanFlowInvokerAccessImpl2.this.factoryCallBack.findPropEditor(type)) == null) {
                    throw new InvalidConfigurationException("PropertyEditor not found : " + type.getName());
                }
                editor.setAsText(BeanFlowInvokerAccessImpl2.this.replaceProperty((String)value));
                value = editor.getValue();
            }
            f.set(context.current.target, value);
        }

        public Object getValue(FlowContext context) throws Exception {
            String name = this.getName();
            Class<?> targetClazz = context.current.target.getClass();
            Field f = null;
            try {
                f = targetClazz.getField(name);
            }
            catch (NoSuchFieldException e) {
                if (name.length() != 0 && Character.isUpperCase(name.charAt(0))) {
                    StringBuffer tmpName = new StringBuffer();
                    tmpName.append(Character.toLowerCase(name.charAt(0)));
                    if (name.length() > 1) {
                        tmpName.append(name.substring(1));
                    }
                    f = targetClazz.getField(tmpName.toString());
                }
                throw e;
            }
            return f.get(context.current.target);
        }
    }

    private class ArgumentMetaData
    extends jp.ossc.nimbus.core.ArgumentMetaData
    implements ReturnValue {
        public ArgumentMetaData(MetaData parent, ObjectMetaData objData) {
            super(parent, objData);
        }

        public Class getTypeClass() throws Exception {
            if (this.type != null) {
                return BeanFlowInvokerAccessImpl2.this.convertStringToClass(this.type);
            }
            if (this.valueType != null) {
                return BeanFlowInvokerAccessImpl2.this.convertStringToClass(this.valueType);
            }
            if (this.value instanceof String) {
                return class$java$lang$String == null ? (class$java$lang$String = BeanFlowInvokerAccessImpl2.class$("java.lang.String")) : class$java$lang$String;
            }
            return null;
        }

        public void importXML(Element element) throws DeploymentException {
            if (!element.getTagName().equals("argument")) {
                throw new DeploymentException("Tag must be argument : " + element.getTagName());
            }
            this.type = ArgumentMetaData.getOptionalAttribute(element, "type");
            this.valueType = ArgumentMetaData.getOptionalAttribute(element, "valueType");
            this.isNullValue = ArgumentMetaData.getOptionalBooleanAttribute(element, "nullValue", false);
            Element serviceRefElement = ArgumentMetaData.getOptionalChild(element, "service-ref");
            if (serviceRefElement != null) {
                ServiceRefMetaData serviceRefData = new ServiceRefMetaData(this);
                serviceRefData.importXML(serviceRefElement);
                this.value = serviceRefData;
                return;
            }
            Element objectElement = ArgumentMetaData.getOptionalChild(element, "object");
            if (objectElement != null) {
                ObjectMetaData objectData = new ObjectMetaData(this);
                objectData.importXML(objectElement);
                this.value = objectData;
                return;
            }
            Element inputElement = ArgumentMetaData.getOptionalChild(element, BeanFlowInvokerAccessImpl2.INPUT_ELEMENT);
            if (inputElement != null) {
                InputMetaData inputData = new InputMetaData();
                inputData.importXML(inputElement);
                this.value = inputData;
                return;
            }
            Element stepRefElement = ArgumentMetaData.getOptionalChild(element, BeanFlowInvokerAccessImpl2.STEP_REF_ELEMENT);
            if (stepRefElement != null) {
                StepRefMetaData stepRefData = new StepRefMetaData();
                stepRefData.importXML(stepRefElement);
                this.value = stepRefData;
                return;
            }
            Element thisElement = ArgumentMetaData.getOptionalChild(element, BeanFlowInvokerAccessImpl2.THIS_ELEMENT);
            if (thisElement != null) {
                ThisMetaData thisData = new ThisMetaData();
                thisData.importXML(thisElement);
                this.value = thisData;
                return;
            }
            Element resourceRefElement = ArgumentMetaData.getOptionalChild(element, BeanFlowInvokerAccessImpl2.RESOURCE_REF_ELEMENT);
            if (resourceRefElement != null) {
                ReourceRefMetaData resourceRefData = new ReourceRefMetaData();
                resourceRefData.importXML(resourceRefElement);
                this.value = resourceRefData;
                return;
            }
            Element varElement = ArgumentMetaData.getOptionalChild(element, "var");
            if (varElement != null) {
                VarMetaData varData = new VarMetaData();
                varData.importXML(varElement);
                this.value = varData;
                return;
            }
            this.value = ArgumentMetaData.getElementContent(element);
        }

        public Object getValue(FlowContext context) throws Exception {
            if (this.isNullValue) {
                return null;
            }
            if (this.value instanceof ReturnValue) {
                return ((ReturnValue)this.value).getValue(context);
            }
            Class typeClass = this.getTypeClass();
            if (typeClass == null) {
                throw new InvalidConfigurationException("Type is unknown : " + this);
            }
            PropertyEditor editor = BeanFlowInvokerAccessImpl2.this.factoryCallBack.findPropEditor(typeClass);
            if (editor == null) {
                throw new InvalidConfigurationException("PropertyEditor not found : " + typeClass.getName());
            }
            editor.setAsText(BeanFlowInvokerAccessImpl2.this.replaceProperty((String)this.value));
            return editor.getValue();
        }
    }

    private class ConstructorMetaData
    extends jp.ossc.nimbus.core.ConstructorMetaData
    implements ReturnValue {
        public ConstructorMetaData(ObjectMetaData parent) {
            super(parent);
        }

        public void importXML(Element element) throws DeploymentException {
            if (!element.getTagName().equals("constructor")) {
                throw new DeploymentException("Tag must be constructor : " + element.getTagName());
            }
            Iterator argElements = ConstructorMetaData.getChildrenByTagName(element, "argument");
            while (argElements.hasNext()) {
                ArgumentMetaData argData = new ArgumentMetaData(this, (ObjectMetaData)this.getParent());
                argData.importXML((Element)argElements.next());
                this.addArgument(argData);
            }
        }

        public Object getValue(FlowContext context) throws Exception {
            ObjectMetaData objectData = (ObjectMetaData)this.getParent();
            Class clazz = objectData.getObjectClass();
            if (clazz.isArray()) {
                Class<?> elementType = clazz.getComponentType();
                Collection argCollection = this.getArguments();
                Object argVals = Array.newInstance(elementType, argCollection.size());
                Iterator args = argCollection.iterator();
                int i = 0;
                while (args.hasNext()) {
                    ArgumentMetaData argData = (ArgumentMetaData)args.next();
                    Array.set(argVals, i, argData.getValue(context));
                    ++i;
                }
                return argVals;
            }
            ArrayList paramTypes = new ArrayList();
            ArrayList<Object> params = new ArrayList<Object>();
            Iterator argDatas = this.getArguments().iterator();
            while (argDatas.hasNext()) {
                ArgumentMetaData argData = (ArgumentMetaData)argDatas.next();
                Object arg = argData.getValue(context);
                params.add(arg);
                Class<?> typeClass = argData.getTypeClass();
                if (typeClass == null) {
                    if (arg == null) {
                        throw new InvalidConfigurationException("Type is unknown : " + argData);
                    }
                    typeClass = arg.getClass();
                }
                paramTypes.add(typeClass);
            }
            Constructor c = clazz.getConstructor(paramTypes.toArray(new Class[paramTypes.size()]));
            return c.newInstance(params.toArray());
        }
    }

    private class ObjectMetaData
    extends jp.ossc.nimbus.core.ObjectMetaData
    implements ReturnValue {
        public ObjectMetaData(MetaData parent) {
            super(null, parent, null);
        }

        public void importXML(Element element) throws DeploymentException {
            if (!element.getTagName().equals("object")) {
                throw new DeploymentException("Tag must be object : " + element.getTagName());
            }
            this.code = ObjectMetaData.getUniqueAttribute(element, "code");
            Element constElement = ObjectMetaData.getOptionalChild(element, "constructor");
            if (constElement != null) {
                ConstructorMetaData constData = new ConstructorMetaData(this);
                constData.importXML(constElement);
                this.constructor = constData;
            }
            Iterator fieldElements = ObjectMetaData.getChildrenByTagName(element, "field");
            while (fieldElements.hasNext()) {
                if (this.getParent() instanceof StepMetaData) {
                    throw new DeploymentException("Invalid element : filed");
                }
                FieldMetaData fieldData = new FieldMetaData(this);
                fieldData.importXML((Element)fieldElements.next());
                this.addField(fieldData);
            }
            Iterator attributeElements = ObjectMetaData.getChildrenByTagName(element, "attribute");
            while (attributeElements.hasNext()) {
                if (this.getParent() instanceof StepMetaData) {
                    throw new DeploymentException("Invalid element : attribute");
                }
                AttributeMetaData attributeData = new AttributeMetaData(this);
                attributeData.importXML((Element)attributeElements.next());
                this.addAttribute(attributeData);
            }
            Iterator invokeElements = ObjectMetaData.getChildrenByTagName(element, "invoke");
            while (invokeElements.hasNext()) {
                if (this.getParent() instanceof StepMetaData) {
                    throw new DeploymentException("Invalid element : invoke");
                }
                InvokeMetaData invokeData = new InvokeMetaData();
                invokeData.importXML((Element)invokeElements.next());
                this.addInvoke(invokeData);
            }
        }

        public Class getObjectClass() throws Exception {
            return BeanFlowInvokerAccessImpl2.this.convertStringToClass(this.code);
        }

        public Object getValue(FlowContext context) throws Exception {
            if (this.constructor == null) {
                Class clazz = this.getObjectClass();
                if (clazz.isArray()) {
                    Class<?> elementType = clazz.getComponentType();
                    return Array.newInstance(elementType, 0);
                }
                return clazz.newInstance();
            }
            return ((ReturnValue)((Object)this.constructor)).getValue(context);
        }
    }

    private class InputMetaData
    extends MetaData
    implements ReturnValue {
        private Property property;

        public void importXML(Element element) throws DeploymentException {
            String val = InputMetaData.getElementContent(element);
            if (val != null && val.length() != 0) {
                try {
                    this.property = PropertyFactory.createProperty(val);
                }
                catch (Exception e) {
                    throw new DeploymentException(e);
                }
            }
        }

        public Object getValue(FlowContext context) throws Exception {
            Object input = context.input;
            if (input == null) {
                return null;
            }
            if (this.property == null) {
                return input;
            }
            return this.property.getProperty(input);
        }
    }

    private static interface SetValue {
        public void setValue(FlowContext var1) throws Exception;
    }

    private static interface ReturnValue {
        public Object getValue(FlowContext var1) throws Exception;
    }

    private class StepMetaData
    extends MetaData
    implements Step {
        private String name;
        private MetaData targetData;
        private List childDatas;
        private MetaData resultData;
        private Semaphore semaphore;
        private long timeout = 300000L;
        private int maxWaitCount = -1;

        public void importXML(Element element) throws DeploymentException {
            Element targetElement;
            String maxWaitCountStr;
            String timeoutStr;
            this.name = StepMetaData.getOptionalAttribute(element, BeanFlowInvokerAccessImpl2.NAME_ATTRIBUTE);
            String maxThreadsStr = MetaData.getOptionalAttribute(element, BeanFlowInvokerAccessImpl2.MAX_RUN_THREADS_ATTRIBUTE);
            if (maxThreadsStr != null) {
                try {
                    int maxThreads = Integer.parseInt(maxThreadsStr);
                    this.semaphore = new MemorySemaphore();
                    this.semaphore.setResourceCapacity(maxThreads);
                    this.semaphore.accept();
                }
                catch (NumberFormatException e) {
                    throw new InvalidConfigurationException("maxThreads is number " + maxThreadsStr);
                }
            }
            if ((timeoutStr = MetaData.getOptionalAttribute(element, BeanFlowInvokerAccessImpl2.TIMEOUT_ATTRIBUTE)) != null) {
                try {
                    this.timeout = Long.parseLong(timeoutStr);
                }
                catch (NumberFormatException e) {
                    throw new InvalidConfigurationException("timeout is number " + timeoutStr);
                }
            }
            if ((maxWaitCountStr = MetaData.getOptionalAttribute(element, BeanFlowInvokerAccessImpl2.MAX_WAIT_THREADS_ATTRIBUTE)) != null) {
                try {
                    this.maxWaitCount = Integer.parseInt(maxWaitCountStr);
                }
                catch (NumberFormatException e) {
                    throw new InvalidConfigurationException("maxWaitThreads is number " + maxWaitCountStr);
                }
            }
            if ((targetElement = StepMetaData.getOptionalChild(element, BeanFlowInvokerAccessImpl2.TARGET_ELEMENT)) == null) {
                this.targetData = new InputMetaData();
            } else {
                Element childElement = StepMetaData.getUniqueChild(targetElement);
                String tagName = childElement.getTagName();
                if (BeanFlowInvokerAccessImpl2.INPUT_ELEMENT.equals(tagName)) {
                    this.targetData = new InputMetaData();
                    this.targetData.importXML(childElement);
                } else if ("object".equals(tagName)) {
                    this.targetData = new ObjectMetaData(this);
                    this.targetData.importXML(childElement);
                } else if ("service-ref".equals(tagName)) {
                    this.targetData = new ServiceRefMetaData(this);
                    this.targetData.importXML(childElement);
                } else if (BeanFlowInvokerAccessImpl2.RESOURCE_REF_ELEMENT.equals(tagName)) {
                    this.targetData = new ReourceRefMetaData();
                    this.targetData.importXML(childElement);
                } else if (BeanFlowInvokerAccessImpl2.STEP_REF_ELEMENT.equals(tagName)) {
                    this.targetData = new StepRefMetaData();
                    this.targetData.importXML(childElement);
                } else if ("var".equals(tagName)) {
                    this.targetData = new VarMetaData();
                    this.targetData.importXML(childElement);
                } else {
                    throw new DeploymentException("Invalid child tag of target tag : " + tagName);
                }
            }
            Iterator children = StepMetaData.getChildrenWithoutTagName(element, new String[]{BeanFlowInvokerAccessImpl2.TARGET_ELEMENT, BeanFlowInvokerAccessImpl2.RESULT_ELEMENT});
            while (children.hasNext()) {
                if (this.childDatas == null) {
                    this.childDatas = new ArrayList();
                }
                Element childElement = (Element)children.next();
                String tagName = childElement.getTagName();
                MetaData childData = null;
                if ("attribute".equals(tagName)) {
                    childData = new AttributeMetaData(null);
                    childData.importXML(childElement);
                } else if ("field".equals(tagName)) {
                    childData = new FieldMetaData(null);
                    childData.importXML(childElement);
                } else if ("invoke".equals(tagName)) {
                    childData = new InvokeMetaData();
                    childData.importXML(childElement);
                } else {
                    throw new DeploymentException("Invalid child tag of step tag : " + tagName);
                }
                this.childDatas.add(childData);
            }
            Element resultElement = StepMetaData.getOptionalChild(element, BeanFlowInvokerAccessImpl2.RESULT_ELEMENT);
            if (resultElement != null) {
                Element retElement = StepMetaData.getUniqueChild(resultElement);
                String tagName = retElement.getTagName();
                if ("attribute".equals(tagName)) {
                    this.resultData = new AttributeMetaData(null);
                    this.resultData.importXML(retElement);
                } else if ("field".equals(tagName)) {
                    this.resultData = new FieldMetaData(null);
                    this.resultData.importXML(retElement);
                } else if ("invoke".equals(tagName)) {
                    this.resultData = new InvokeMetaData();
                    this.resultData.importXML(retElement);
                } else if (BeanFlowInvokerAccessImpl2.THIS_ELEMENT.equals(tagName)) {
                    this.resultData = new ThisMetaData();
                    this.resultData.importXML(retElement);
                } else if (BeanFlowInvokerAccessImpl2.INPUT_ELEMENT.equals(tagName)) {
                    this.resultData = new InputMetaData();
                    this.resultData.importXML(retElement);
                } else {
                    throw new DeploymentException("Invalid child tag of result tag : " + tagName);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public StepContext invokeStep(FlowContext context) throws Exception {
            StepContext stepContext = new StepContext();
            try {
                Object target;
                if (this.semaphore != null) {
                    this.semaphore.getResource(this.timeout, this.maxWaitCount);
                }
                context.current = stepContext;
                if (this.name != null) {
                    context.put(this.name, stepContext);
                }
                stepContext.target = target = ((ReturnValue)((Object)this.targetData)).getValue(context);
                if (this.childDatas != null) {
                    Iterator children = this.childDatas.iterator();
                    while (children.hasNext()) {
                        Object child = children.next();
                        if (child instanceof SetValue) {
                            ((SetValue)child).setValue(context);
                            continue;
                        }
                        if (!(child instanceof InvokeMetaData)) continue;
                        ((InvokeMetaData)child).getValue(context);
                    }
                }
                if (this.resultData != null) {
                    stepContext.result = ((ReturnValue)((Object)this.resultData)).getValue(context);
                }
                Object var7_6 = null;
                if (this.semaphore != null) {
                    this.semaphore.freeResource();
                }
            }
            catch (Throwable throwable) {
                Object var7_7 = null;
                if (this.semaphore != null) {
                    this.semaphore.freeResource();
                }
                throw throwable;
            }
            return stepContext;
        }
    }

    private static interface Step {
        public StepContext invokeStep(FlowContext var1) throws Exception;
    }

    private class ResourceInfo {
        public String name;
        public String key;
        public ServiceName serviceName;
        public boolean isTranControl;
        public boolean isTranClose;

        private ResourceInfo() {
        }
    }
}

