/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.codemaster;

import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.jms.JMSException;
import javax.jms.MapMessage;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.TopicSubscriber;
import jp.ossc.nimbus.core.ServiceBase;
import jp.ossc.nimbus.core.ServiceManagerFactory;
import jp.ossc.nimbus.core.ServiceName;
import jp.ossc.nimbus.ioc.Command;
import jp.ossc.nimbus.ioc.FacadeValue;
import jp.ossc.nimbus.ioc.FacadeValueAccess;
import jp.ossc.nimbus.lang.ServiceException;
import jp.ossc.nimbus.service.codemaster.CodeMasterFinder;
import jp.ossc.nimbus.service.codemaster.CodeMasterServiceMBean;
import jp.ossc.nimbus.service.codemaster.PartUpdate;
import jp.ossc.nimbus.service.ioccall.FacadeCaller;
import jp.ossc.nimbus.service.jms.JMSMessageConsumerFactory;
import jp.ossc.nimbus.service.sequence.Sequence;

public class CodeMasterService
extends ServiceBase
implements CodeMasterServiceMBean,
CodeMasterFinder,
MessageListener {
    private static final String C_REQUEST_ID = "REQUEST_ID";
    private static final String C_USER_ID = "USER_ID";
    private static final String FIND_DATE_KEY = "date";
    private static final String MASTER_DATA_KEY = "data";
    private ServiceName facadeCallerServiceName;
    private FacadeCaller facadeCaller;
    private String[] masterNames;
    private ServiceName jmsTopicSubscriberFactoryServiceName;
    private JMSMessageConsumerFactory jmsTopicSubscriberFactory;
    protected HashMap master;
    private ServiceName sequenceServiceName;
    private Sequence sequence;
    private String userId;

    public void setMasterNames(String[] names) {
        this.masterNames = names;
    }

    public String[] getMasterNames() {
        return this.masterNames;
    }

    public ServiceName getFacadeCallerServiceName() {
        return this.facadeCallerServiceName;
    }

    public void setFacadeCallerServiceName(ServiceName name) {
        this.facadeCallerServiceName = name;
    }

    public void setJMSTopicSubscriberFactoryServiceName(ServiceName name) {
        this.jmsTopicSubscriberFactoryServiceName = name;
    }

    public ServiceName getJMSTopicSubscriberFactoryServiceName() {
        return this.jmsTopicSubscriberFactoryServiceName;
    }

    public ServiceName getSequenceServiceName() {
        return this.sequenceServiceName;
    }

    public void setSequenceServiceName(ServiceName name) {
        this.sequenceServiceName = name;
    }

    public String getUserId() {
        return this.userId;
    }

    public void setUserId(String id) {
        this.userId = id;
    }

    public void setFacadeCaller(FacadeCaller caller) {
        this.facadeCaller = caller;
    }

    public void setSequence(Sequence sequence) {
        this.sequence = sequence;
    }

    public void setJMSMessageConsumerFactory(JMSMessageConsumerFactory factory) {
        this.jmsTopicSubscriberFactory = factory;
    }

    public void createService() throws Exception {
        this.master = new HashMap();
    }

    public void startService() throws Exception {
        if (this.facadeCallerServiceName != null) {
            this.facadeCaller = (FacadeCaller)ServiceManagerFactory.getServiceObject(this.facadeCallerServiceName);
        } else if (this.facadeCaller == null) {
            throw new IllegalArgumentException("Attribute : FacadeCallerServiceName or FacadeCaller is null");
        }
        if (this.jmsTopicSubscriberFactoryServiceName != null) {
            this.jmsTopicSubscriberFactory = (JMSMessageConsumerFactory)ServiceManagerFactory.getServiceObject(this.jmsTopicSubscriberFactoryServiceName);
        } else if (this.jmsTopicSubscriberFactory == null) {
            throw new IllegalArgumentException("Attribute : JMSTopicSubscriberFactoryServiceName or JMSMessageConsumerFactory is null");
        }
        if (this.sequenceServiceName != null) {
            this.sequence = (Sequence)((Object)ServiceManagerFactory.getService(this.sequenceServiceName));
        }
        this.initMasterHash();
        this.entryTopicListener();
    }

    public void stopService() throws Exception {
        if (this.master != null) {
            this.master.clear();
        }
    }

    public void destroyService() {
        this.master = null;
    }

    private void entryTopicListener() throws Exception {
        TopicSubscriber subscriber = (TopicSubscriber)this.jmsTopicSubscriberFactory.createConsumer();
        subscriber.setMessageListener((MessageListener)this);
        this.jmsTopicSubscriberFactory.getSessionFactory().getConnection().start();
    }

    private void initMasterHash() throws Exception {
        int status;
        this.master.clear();
        if (this.masterNames == null) {
            return;
        }
        FacadeValue value = FacadeValueAccess.createCommandsValue();
        for (int cnt = 0; cnt < this.masterNames.length; ++cnt) {
            TimeManageMaster tmp = new TimeManageMaster();
            tmp.setMasterName(this.masterNames[cnt]);
            Command cmd = FacadeValueAccess.createCommand(this.masterNames[cnt], null);
            this.master.put(this.masterNames[cnt], tmp);
            value.addCommand(cmd);
        }
        FacadeValue ret = null;
        if (this.userId != null) {
            value.putHeader(C_USER_ID, this.userId);
        }
        if (this.sequence != null) {
            value.putHeader(C_REQUEST_ID, this.sequence.increment());
        }
        if ((status = (ret = this.facadeCaller.syncFacadeCall(value)).getStatus()) == 0) {
            for (int cnt = 0; cnt < value.commandSize(); ++cnt) {
                Command tmp = (Command)value.getCommand(cnt);
                String key = tmp.getFlowKey();
                if (tmp.getOutputObject() == null) continue;
                TimeManageMaster mst = (TimeManageMaster)this.master.get(key);
                mst.addMaster(new Date(), tmp.getOutputObject());
            }
        } else if (ret.getExceptionCount() > 0) {
            Throwable[] th = ret.getExceptions();
            if (th[0] instanceof Exception) {
                throw (Exception)th[0];
            }
            throw (Error)th[0];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map getCodeMasters() throws ServiceException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        Date nowDate = new Date();
        Set keys = this.master.keySet();
        Iterator ite = keys.iterator();
        while (ite.hasNext()) {
            String key = (String)ite.next();
            TimeManageMaster tmp = null;
            HashMap hashMap = this.master;
            synchronized (hashMap) {
                tmp = (TimeManageMaster)this.master.get(key);
            }
            Object mst = tmp.getMaster(nowDate);
            map.put(key, mst);
        }
        return map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onMessage(Message msg) {
        block15: {
            if (!(msg instanceof MapMessage)) {
                this.getLogger().write("CMS__00003", msg.getClass());
                return;
            }
            MapMessage mapMsg = (MapMessage)msg;
            try {
                Enumeration en = mapMsg.getMapNames();
                FacadeValue value = FacadeValueAccess.createCommandsValue();
                while (en.hasMoreElements()) {
                    String key = (String)en.nextElement();
                    Object tmp = this.master.get(key);
                    if (tmp == null) continue;
                    Object addMsg = mapMsg.getObject(key);
                    Command cmd = null;
                    cmd = FacadeValueAccess.createCommand(key, addMsg);
                    value.addCommand(cmd);
                }
                if (value.commandSize() <= 0) break block15;
                FacadeValue ret = null;
                if (this.userId != null) {
                    value.putHeader(C_USER_ID, this.userId);
                }
                if (this.sequence != null) {
                    value.putHeader(C_REQUEST_ID, this.sequence.increment());
                }
                ret = this.facadeCaller.syncFacadeCall(value);
                for (int cnt = 0; cnt < ret.commandSize(); ++cnt) {
                    Command rec = (Command)ret.getCommand(cnt);
                    if (rec.getStatus() == 0) {
                        Object mst = rec.getOutputObject();
                        if (mst == null) {
                            this.getLogger().write("CMS__00001", new Object[]{rec.getFlowKey(), null});
                            continue;
                        }
                        TimeManageMaster tm = (TimeManageMaster)this.master.get(rec.getFlowKey());
                        Date effectDt = null;
                        if (mst instanceof PartUpdate) {
                            effectDt = new Date();
                            PartUpdate pu = (PartUpdate)tm.getMaster(effectDt);
                            PartUpdate indata = (PartUpdate)mst;
                            Iterator ite = indata.keySet().iterator();
                            while (ite.hasNext()) {
                                String key = (String)ite.next();
                                pu.put(key, indata.get(key));
                            }
                            tm.clear();
                        } else {
                            TimeManageMaster newTm = tm.cloneOwn();
                            long utc = mapMsg.getLong(rec.getFlowKey());
                            effectDt = new Date(utc);
                            newTm.addMaster(effectDt, mst);
                            newTm.clear();
                            HashMap hashMap = this.master;
                            synchronized (hashMap) {
                                this.master.put(rec.getFlowKey(), newTm);
                            }
                        }
                        this.getLogger().write("CMS__00001", new Object[]{rec.getFlowKey(), effectDt});
                        continue;
                    }
                    if (ret.getExceptionCount() <= 0) continue;
                    Throwable[] th = ret.getExceptions();
                    this.getLogger().write("CMS__00002", (Object)rec.getFlowKey(), th[0]);
                }
            }
            catch (JMSException e) {
                this.getLogger().write("CMS__00004", e);
                return;
            }
        }
    }

    private class TimeManageMaster {
        private String mFlowKey = null;
        private ArrayList mTimeList = new ArrayList();

        public void setMasterName(String name) {
            this.mFlowKey = name;
        }

        public String getMasterName() {
            return this.mFlowKey;
        }

        public void addMaster(Date time, Object master) {
            HashMap<String, Object> rec = new HashMap<String, Object>();
            rec.put(CodeMasterService.MASTER_DATA_KEY, master);
            rec.put(CodeMasterService.FIND_DATE_KEY, time);
            boolean instFlg = false;
            for (int cnt = this.mTimeList.size() - 1; cnt > -1; --cnt) {
                Map map = (Map)this.mTimeList.get(cnt);
                Date tmpTime = (Date)map.get(CodeMasterService.FIND_DATE_KEY);
                if (!tmpTime.before(time)) continue;
                if (cnt == this.mTimeList.size() - 1) {
                    this.mTimeList.add(rec);
                } else {
                    this.mTimeList.add(cnt + 1, rec);
                }
                instFlg = true;
                break;
            }
            if (!instFlg) {
                if (this.mTimeList.size() == 0) {
                    this.mTimeList.add(rec);
                } else {
                    this.mTimeList.add(0, rec);
                }
            }
        }

        public Object getMaster(Date time) {
            Object ret = null;
            for (int cnt = this.mTimeList.size() - 1; cnt > -1; --cnt) {
                Map map = (Map)this.mTimeList.get(cnt);
                Date tmpTime = (Date)map.get(CodeMasterService.FIND_DATE_KEY);
                if (!tmpTime.before(time)) continue;
                ret = map.get(CodeMasterService.MASTER_DATA_KEY);
                break;
            }
            return ret;
        }

        public void clear() {
            Date now = new Date();
            Object ret = null;
            for (int cnt = this.mTimeList.size() - 1; cnt >= 0; --cnt) {
                Map map = (Map)this.mTimeList.get(cnt);
                Date tmpTime = (Date)map.get(CodeMasterService.FIND_DATE_KEY);
                if (!tmpTime.before(now) || cnt <= 0) continue;
                for (int rcnt = cnt - 1; rcnt >= 0; --rcnt) {
                    this.mTimeList.remove(rcnt);
                }
                break;
            }
        }

        public TimeManageMaster cloneOwn() {
            TimeManageMaster ret = new TimeManageMaster();
            ret.setMasterName(this.getMasterName());
            for (int cnt = 0; cnt < this.mTimeList.size(); ++cnt) {
                ret.mTimeList.add(this.mTimeList.get(cnt));
            }
            return ret;
        }
    }
}

