/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.semaphore;

import jp.ossc.nimbus.core.NimbusClassLoader;
import jp.ossc.nimbus.core.ServiceBase;
import jp.ossc.nimbus.service.semaphore.DefaultSemaphoreServiceMBean;
import jp.ossc.nimbus.service.semaphore.MemorySemaphore;
import jp.ossc.nimbus.service.semaphore.Semaphore;

public class DefaultSemaphoreService
extends ServiceBase
implements Semaphore,
DefaultSemaphoreServiceMBean {
    private int capacity = -1;
    private Semaphore semaphore = null;
    private long sleepTime = -1L;
    private String semaphoreClassName = MemorySemaphore.class.getName();

    public boolean getResource(long timeOutMiliSecond, int maxWaitCount) {
        return this.semaphore.getResource(timeOutMiliSecond, maxWaitCount);
    }

    public boolean getResource(long timeOutMiliSecond) {
        return this.semaphore.getResource(timeOutMiliSecond);
    }

    public boolean getResource(int maxWaitCount) {
        return this.semaphore.getResource(maxWaitCount);
    }

    public boolean getResource() {
        return this.semaphore.getResource();
    }

    public void freeResource() {
        this.semaphore.freeResource();
    }

    public int getResourceCapacity() {
        return this.capacity;
    }

    public void setResourceCapacity(int capa) {
        this.capacity = capa;
    }

    public void setSleepTime(long millis) {
        this.sleepTime = millis;
    }

    public long getSleepTime() {
        return this.sleepTime;
    }

    public int getResourceRemain() {
        return this.semaphore.getResourceRemain();
    }

    public int getWaitingCount() {
        return this.semaphore.getWaitingCount();
    }

    public void release() {
        this.semaphore.release();
    }

    public void accept() {
        this.semaphore.accept();
    }

    public void setSemaphoreClassName(String name) {
        this.semaphoreClassName = name;
    }

    public String getSemaphoreClassName() {
        return this.semaphoreClassName;
    }

    public void startService() throws Exception {
        this.semaphore = (Semaphore)Class.forName(this.semaphoreClassName, true, NimbusClassLoader.getInstance()).newInstance();
        this.semaphore.setResourceCapacity(this.getResourceCapacity());
        if (this.getSleepTime() > 0L) {
            this.semaphore.setSleepTime(this.getSleepTime());
        }
    }

    public void stopService() {
        this.semaphore.release();
    }
}

