/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.core;

import java.beans.PropertyEditor;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import jp.ossc.nimbus.beans.NoSuchPropertyException;
import jp.ossc.nimbus.beans.Property;
import jp.ossc.nimbus.beans.PropertyFactory;
import jp.ossc.nimbus.beans.ServiceNameArrayEditor;
import jp.ossc.nimbus.beans.ServiceNameEditor;
import jp.ossc.nimbus.beans.ServiceNameRefArrayEditor;
import jp.ossc.nimbus.beans.ServiceNameRefEditor;
import jp.ossc.nimbus.core.FactoryServiceBase;
import jp.ossc.nimbus.core.GenericsFactoryServiceMBean;
import jp.ossc.nimbus.core.Service;
import jp.ossc.nimbus.core.ServiceLoader;
import jp.ossc.nimbus.core.ServiceManagerFactory;
import jp.ossc.nimbus.core.ServiceMetaData;
import jp.ossc.nimbus.core.ServiceName;
import jp.ossc.nimbus.core.ServiceNotFoundException;

public class GenericsFactoryService
extends FactoryServiceBase
implements Map,
GenericsFactoryServiceMBean {
    private static final String GFS__00001 = "GFS__00001";
    private static final String GFS__00002 = "GFS__00002";
    protected Class instantiateClass;
    protected Map attributes;
    protected boolean isServiceInjection;
    protected ServiceLoader loader;

    public void setInstantiateClass(Class clazz) {
        this.instantiateClass = clazz;
    }

    public Class getInstantiateClass() {
        return this.instantiateClass;
    }

    public boolean isServiceInjection() {
        return this.isServiceInjection;
    }

    public void setServiceInjection(boolean flg) {
        this.isServiceInjection = flg;
    }

    public void createService() throws Exception {
        this.attributes = new HashMap();
    }

    public void startService() throws Exception {
        if (this.instantiateClass == null) {
            throw new IllegalArgumentException("instantiateClass must be specified.");
        }
        ServiceMetaData metaData = this.manager.getServiceMetaData(this.name);
        this.loader = metaData.getServiceLoader();
    }

    public void destroyService() throws Exception {
        this.attributes = null;
        this.loader = null;
    }

    protected Object createInstance() throws Exception {
        Object instance = this.instantiateClass.newInstance();
        this.setAttributes(instance);
        return instance;
    }

    protected void setAttributes(Object instance) throws Exception {
        Iterator attrNames = this.keySet().iterator();
        while (attrNames.hasNext()) {
            String attrName = (String)attrNames.next();
            Object[] attrValue = null;
            try {
                Property prop = PropertyFactory.createProperty(attrName);
                Object val = attrValue = this.get(attrName);
                if (this.isServiceInjection) {
                    if (attrValue instanceof ServiceName) {
                        val = ServiceManagerFactory.getServiceObject((ServiceName)attrValue);
                    } else if (attrValue instanceof ServiceName[]) {
                        ServiceName[] serviceNames = (ServiceName[])attrValue;
                        Object[] services = new Object[serviceNames.length];
                        for (int i = 0; i < serviceNames.length; ++i) {
                            services[i] = ServiceManagerFactory.getServiceObject(serviceNames[i]);
                        }
                        val = services;
                    }
                } else if (attrValue instanceof String) {
                    Class type = prop.getPropertyType(instance);
                    PropertyEditor editor = this.loader.findEditor(type);
                    if (editor instanceof ServiceNameEditor) {
                        ((ServiceNameEditor)editor).setServiceManagerName(this.getServiceManagerName());
                    } else if (editor instanceof ServiceNameArrayEditor) {
                        ((ServiceNameArrayEditor)editor).setServiceManagerName(this.getServiceManagerName());
                    } else if (editor instanceof ServiceNameRefEditor) {
                        ((ServiceNameRefEditor)editor).setServiceManagerName(this.getServiceManagerName());
                    } else if (editor instanceof ServiceNameRefArrayEditor) {
                        ((ServiceNameRefArrayEditor)editor).setServiceManagerName(this.getServiceManagerName());
                    }
                    if (editor == null) {
                        throw new IllegalArgumentException("PropertyEditor not found  : " + attrName);
                    }
                    editor.setAsText((String)attrValue);
                    val = editor.getValue();
                }
                prop.setProperty(instance, val);
            }
            catch (InvocationTargetException e) {
                this.logger.write(GFS__00001, new Object[]{this.instantiateClass.getName(), attrName, attrValue}, (Throwable)e);
            }
            catch (NoSuchPropertyException e) {
                this.logger.write(GFS__00002, new Object[]{this.instantiateClass.getName(), attrName});
            }
        }
    }

    public Object getAttribute(String attributeName) {
        return this.attributes.get(attributeName);
    }

    public Service getService(String attributeName) throws ServiceNotFoundException {
        return ServiceManagerFactory.getService((ServiceName)this.getAttribute(attributeName));
    }

    public Object getServiceObject(String attributeName) throws ServiceNotFoundException {
        return ServiceManagerFactory.getServiceObject((ServiceName)this.getAttribute(attributeName));
    }

    public Object get(Object key) {
        return this.attributes.get(key);
    }

    public Object put(Object key, Object value) {
        return this.attributes.put(key, value);
    }

    public Set keySet() {
        return this.attributes.keySet();
    }

    public Collection values() {
        return this.attributes.values();
    }

    public Object remove(Object key) {
        return this.attributes.remove(key);
    }

    public void clear() {
        this.attributes.clear();
    }

    public boolean isEmpty() {
        return this.attributes.isEmpty();
    }

    public boolean containsKey(Object key) {
        return this.attributes.containsKey(key);
    }

    public boolean containsValue(Object value) {
        return this.attributes.containsValue(value);
    }

    public Set entrySet() {
        return this.attributes.entrySet();
    }

    public int size() {
        return this.attributes.size();
    }

    public void putAll(Map t) {
        this.attributes.putAll(t);
    }
}

