/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.aop.interceptor.servlet;

import java.util.Iterator;
import java.util.Properties;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import jp.ossc.nimbus.beans.ServiceNameEditor;
import jp.ossc.nimbus.core.NimbusClassLoader;
import jp.ossc.nimbus.core.ServiceManagerFactory;
import jp.ossc.nimbus.core.ServiceName;
import jp.ossc.nimbus.service.aop.InterceptorChain;
import jp.ossc.nimbus.service.aop.ServletFilterInvocationContext;
import jp.ossc.nimbus.service.aop.interceptor.servlet.ExceptionHandler;
import jp.ossc.nimbus.service.aop.interceptor.servlet.ExceptionHandlingInterceptorServiceMBean;
import jp.ossc.nimbus.service.aop.interceptor.servlet.ServletFilterInterceptorService;
import jp.ossc.nimbus.util.ClassMappingTree;

public class ExceptionHandlingInterceptorService
extends ServletFilterInterceptorService
implements ExceptionHandlingInterceptorServiceMBean {
    protected Properties exceptionAndPathMapping;
    protected ClassMappingTree exceptionMapForJSP;
    protected String defaultExceptionPath;
    protected Properties exceptionAndHandlerMapping;
    protected ClassMappingTree exceptionMapForHandler;
    protected ServiceName defaultExceptionHandlerServiceName;
    protected ExceptionHandler defaultExceptionHandler;

    public void setExceptionAndPathMapping(Properties map) {
        this.exceptionAndPathMapping = map;
    }

    public Properties getExceptionAndPathMapping() {
        return this.exceptionAndPathMapping;
    }

    public void setDefaultExceptionPath(String path) {
        this.defaultExceptionPath = path;
    }

    public String getDefaultExceptionPath() {
        return this.defaultExceptionPath;
    }

    public void setExceptionAndHandlerMapping(Properties map) {
        this.exceptionAndHandlerMapping = map;
    }

    public Properties getExceptionAndHandlerMapping() {
        return this.exceptionAndHandlerMapping;
    }

    public void setDefaultExceptionHandlerServiceName(ServiceName name) {
        this.defaultExceptionHandlerServiceName = name;
    }

    public ServiceName getDefaultExceptionHandlerServiceName() {
        return this.defaultExceptionHandlerServiceName;
    }

    public void startService() throws Exception {
        NimbusClassLoader loader;
        if (this.exceptionAndPathMapping != null) {
            this.exceptionMapForJSP = new ClassMappingTree();
            loader = NimbusClassLoader.getInstance();
            Iterator<Object> exNames = this.exceptionAndPathMapping.keySet().iterator();
            while (exNames.hasNext()) {
                String exName = (String)exNames.next();
                Class<?> clazz = Class.forName(exName, true, loader);
                this.exceptionMapForJSP.add(clazz, this.exceptionAndPathMapping.get(exName));
            }
        }
        if (this.exceptionAndHandlerMapping != null) {
            this.exceptionMapForHandler = new ClassMappingTree();
            loader = NimbusClassLoader.getInstance();
            ServiceNameEditor editor = new ServiceNameEditor();
            editor.setServiceManagerName(this.getServiceManagerName());
            Iterator<Object> exNames = this.exceptionAndHandlerMapping.keySet().iterator();
            while (exNames.hasNext()) {
                String exName = (String)exNames.next();
                Class<?> clazz = Class.forName(exName, true, loader);
                String name = (String)this.exceptionAndHandlerMapping.get(exName);
                editor.setAsText(name);
                ServiceName serviceName = (ServiceName)editor.getValue();
                this.exceptionMapForHandler.add(clazz, ServiceManagerFactory.getServiceObject(serviceName));
            }
        }
        if (this.defaultExceptionHandlerServiceName != null) {
            this.defaultExceptionHandler = (ExceptionHandler)ServiceManagerFactory.getServiceObject(this.defaultExceptionHandlerServiceName);
        }
    }

    public Object invokeFilter(ServletFilterInvocationContext context, InterceptorChain chain) throws Throwable {
        if (this.getState() == 3) {
            Object ret;
            block7: {
                ret = null;
                try {
                    ret = chain.invokeNext(context);
                }
                catch (Throwable th) {
                    RequestDispatcher rd;
                    String path;
                    ExceptionHandler handler;
                    ServletRequest request = context.getServletRequest();
                    ServletResponse response = context.getServletResponse();
                    boolean isHandled = false;
                    if (this.exceptionMapForHandler != null && (handler = this.getTargetExceptionHandlerCause(th)) != null) {
                        Throwable targetTh = this.getTargetException(this.exceptionMapForHandler, th);
                        if (targetTh == null) {
                            targetTh = th;
                        }
                        handler.handleException(targetTh, request, response);
                        isHandled = true;
                    }
                    if (this.exceptionMapForJSP != null && (path = this.getTargetHandlerJSPCause(th)) != null && (rd = request.getRequestDispatcher(path)) != null) {
                        Throwable targetTh = this.getTargetException(this.exceptionMapForJSP, th);
                        if (targetTh == null) {
                            targetTh = th;
                        }
                        rd.forward(request, response);
                        isHandled = true;
                    }
                    if (isHandled) break block7;
                    throw th;
                }
            }
            return ret;
        }
        return chain.invokeNext(context);
    }

    protected String getTargetHandlerJSPCause(Throwable th) {
        String handler = (String)this.getTargetHandlerCause(this.exceptionMapForJSP, th);
        return handler == null ? this.defaultExceptionPath : handler;
    }

    protected ExceptionHandler getTargetExceptionHandlerCause(Throwable th) {
        ExceptionHandler handler = (ExceptionHandler)this.getTargetHandlerCause(this.exceptionMapForHandler, th);
        return handler == null ? this.defaultExceptionHandler : handler;
    }

    protected Object getTargetHandlerCause(ClassMappingTree handlers, Throwable th) {
        Object handler = handlers.getValue(th.getClass());
        if (handler != null) {
            return handler;
        }
        Throwable cause = this.getCause(th);
        return cause == null ? null : this.getTargetHandlerCause(handlers, cause);
    }

    protected Throwable getTargetException(ClassMappingTree handlers, Throwable th) {
        Object handler = handlers.getValue(th.getClass());
        if (handler != null) {
            return th;
        }
        Throwable cause = this.getCause(th);
        return cause == null ? null : this.getTargetException(handlers, cause);
    }

    protected Throwable getCause(Throwable th) {
        Throwable cause = null;
        cause = th instanceof ServletException ? ((ServletException)th).getRootCause() : th.getCause();
        return cause == th ? null : cause;
    }
}

