/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.graph;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import jp.ossc.nimbus.service.graph.AbstractTickUnitAdjusterService;
import jp.ossc.nimbus.service.graph.DateAxisTickUnitAdjusterServiceMBean;
import org.jfree.chart.axis.DateAxis;
import org.jfree.chart.axis.DateTickUnit;
import org.jfree.chart.axis.ValueAxis;

public class DateAxisTickUnitAdjusterService
extends AbstractTickUnitAdjusterService
implements DateAxisTickUnitAdjusterServiceMBean {
    protected void adjust(ValueAxis axis) {
        if (!(axis instanceof DateAxis)) {
            throw new IllegalArgumentException("axis is not DateAxis.");
        }
        DateAxis dateAxis = (DateAxis)axis;
        DateTickUnit orgTickUnit = dateAxis.getTickUnit();
        int unit = orgTickUnit.getUnit();
        long length = (int)dateAxis.getRange().getLength();
        if (5 == unit) {
            length /= 1000L;
        } else if (4 == unit) {
            length /= 60000L;
        } else if (3 == unit) {
            length /= 4600L;
        } else if (2 == unit) {
            length /= 86400000L;
        } else if (1 == unit) {
            length /= -1875767296L;
        } else if (0 == unit) {
            length /= 1471228928L;
        }
        long unitCount = length / (long)this.displayGraduationCount;
        if (unitCount == 0L) {
            unitCount = 1L;
        } else if (unitCount % (long)this.unitCountMultiple != 0L) {
            unitCount = unitCount / (long)this.unitCountMultiple * (long)this.unitCountMultiple + (long)this.unitCountMultiple;
        }
        if (unitCount > Integer.MAX_VALUE) {
            unitCount = 1L;
        }
        dateAxis.setTickUnit(new DateTickUnit(orgTickUnit.getUnit(), (int)unitCount, (DateFormat)new SimpleDateFormat(this.formatPattern)));
    }
}

