/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.journal.editor;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;

public class JournalHttpServletResponseWrapper
extends HttpServletResponseWrapper
implements Serializable {
    private static final String EMPTY = "";
    private static final String[] EMPTY_STRING_ARRAY = new String[0];
    private static final String CONTENT_LENGTH_HEADER = "Content-Length";
    private static final String CONTENT_TYPE_HEADER = "Content-Type";
    private StringWriter bufferWriter;
    private PrintWriter dummyWriter;
    private PrintWriterWrapper writerWrapper;
    private ServletOutputStreamWrapper outputStreamWrapper;
    private boolean isBufferedOutput;
    private int contentLength = -1;
    private Set cookies = new HashSet();
    private Map headers = new HashMap();
    private SimpleDateFormat format;
    private int statusCode = 200;
    private String statusMessage;
    private boolean isSentError;
    private String redirectLocation;

    public JournalHttpServletResponseWrapper(HttpServletResponse response) {
        super(response);
        this.bufferWriter = new StringWriter();
        this.dummyWriter = new PrintWriter(this.bufferWriter);
    }

    private final ServletOutputStreamWrapper createServletOutputStreamWrapper() throws IOException {
        if (this.outputStreamWrapper == null) {
            ServletOutputStream sos = this.getResponse().getOutputStream();
            this.outputStreamWrapper = new ServletOutputStreamWrapper(sos);
        }
        return this.outputStreamWrapper;
    }

    private final PrintWriterWrapper createPrintWriterWrapper() throws IOException {
        if (this.writerWrapper == null) {
            PrintWriter pw = this.getResponse().getWriter();
            this.writerWrapper = new PrintWriterWrapper(pw);
        }
        return this.writerWrapper;
    }

    public void setBufferedOutput(boolean isBuffered) {
        this.isBufferedOutput = isBuffered;
    }

    public PrintWriter getWriter() throws IOException {
        return this.createPrintWriterWrapper();
    }

    public ServletOutputStream getOutputStream() throws IOException {
        return this.createServletOutputStreamWrapper();
    }

    public void setContentLength(int len) {
        super.setContentLength(len);
        if (this.isCommitted()) {
            return;
        }
        this.contentLength = len;
    }

    public int getContentLength() {
        if (this.contentLength != -1) {
            return this.contentLength;
        }
        String content = this.getContent();
        int len = 0;
        String enc = this.getCharacterEncoding();
        if (content != null && content.length() != 0 && enc != null) {
            try {
                len = content.getBytes(enc).length;
            }
            catch (UnsupportedEncodingException e) {
                // empty catch block
            }
        }
        if (this.outputStreamWrapper != null) {
            len += this.outputStreamWrapper.getLength();
        }
        return len;
    }

    public String getContent() {
        if (this.writerWrapper == null) {
            return EMPTY;
        }
        return this.writerWrapper.getContent();
    }

    public void flush() throws IOException {
        HttpServletResponse response;
        if (this.writerWrapper != null) {
            this.writerWrapper.flushBuffer();
        }
        if (this.outputStreamWrapper != null) {
            this.outputStreamWrapper.flushBuffer();
        }
        if ((response = (HttpServletResponse)this.getResponse()) instanceof JournalHttpServletResponseWrapper) {
            ((JournalHttpServletResponseWrapper)response).flush();
        }
    }

    public void addCookie(Cookie cookie) {
        super.addCookie(cookie);
        if (this.isCommitted()) {
            return;
        }
        this.cookies.add(cookie);
    }

    public Cookie[] getCookies() {
        return this.cookies.toArray(new Cookie[this.cookies.size()]);
    }

    public void addDateHeader(String name, long date) {
        super.addDateHeader(name, date);
        this.addInnerHeader(name, this.formatDateHeader(date));
    }

    protected String formatDateHeader(long date) {
        if (this.format == null) {
            this.format = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss zzz", this.getLocale());
        }
        this.format.setTimeZone(TimeZone.getTimeZone("GMT"));
        return this.format.format(new Date(date));
    }

    public void addHeader(String name, String value) {
        super.addHeader(name, value);
        this.addInnerHeader(name, value);
    }

    public void addIntHeader(String name, int value) {
        super.addIntHeader(name, value);
        this.addInnerHeader(name, String.valueOf(value));
    }

    public void setDateHeader(String name, long date) {
        super.setDateHeader(name, date);
        this.setInnerHeader(name, this.formatDateHeader(date));
    }

    public void setHeader(String name, String value) {
        super.setHeader(name, value);
        this.setInnerHeader(name, value);
    }

    public void setIntHeader(String name, int value) {
        super.setIntHeader(name, value);
        this.setInnerHeader(name, String.valueOf(value));
    }

    protected void addInnerHeader(String name, String value) {
        if (this.isCommitted()) {
            return;
        }
        if (this.headers.containsKey(name)) {
            ((List)this.headers.get(name)).add(value);
        } else {
            ArrayList<String> list = new ArrayList<String>();
            list.add(value);
            this.headers.put(name, list);
        }
        if (name.equalsIgnoreCase(CONTENT_LENGTH_HEADER)) {
            int contentLength = 0;
            try {
                contentLength = Integer.parseInt(value);
            }
            catch (NumberFormatException e) {
                contentLength = -1;
            }
            if (contentLength >= 0) {
                this.setContentLength(contentLength);
            }
        } else if (name.equalsIgnoreCase(CONTENT_TYPE_HEADER)) {
            this.setContentType(value);
        }
    }

    protected void setInnerHeader(String name, String value) {
        List<String> list;
        if (this.isCommitted()) {
            return;
        }
        if (this.headers.containsKey(name)) {
            list = (List)this.headers.get(name);
            list.clear();
            list.add(value);
        } else {
            list = new ArrayList<String>();
            list.add(value);
            this.headers.put(name, list);
        }
        if (name.equalsIgnoreCase(CONTENT_LENGTH_HEADER)) {
            int contentLength = 0;
            try {
                contentLength = Integer.parseInt(value);
            }
            catch (NumberFormatException e) {
                contentLength = -1;
            }
            if (contentLength >= 0) {
                this.setContentLength(contentLength);
            }
        } else if (name.equalsIgnoreCase(CONTENT_TYPE_HEADER)) {
            this.setContentType(value);
        }
    }

    public Iterator getHeaderNames() {
        return this.headers.keySet().iterator();
    }

    public String getHeader(String name) {
        if (this.headers.containsKey(name)) {
            List list = (List)this.headers.get(name);
            return (String)list.get(0);
        }
        return null;
    }

    public String[] getHeaders(String name) {
        if (this.headers.containsKey(name)) {
            List list = (List)this.headers.get(name);
            return list.toArray(new String[list.size()]);
        }
        return EMPTY_STRING_ARRAY;
    }

    public void setStatus(int sc) {
        super.setStatus(sc);
        this.statusCode = sc;
    }

    public void setStatus(int sc, String sm) {
        super.setStatus(sc, sm);
        this.statusCode = sc;
        this.statusMessage = sm;
    }

    public int getStatus() {
        return this.statusCode;
    }

    public String getStatusMessage() {
        return this.statusMessage;
    }

    public void sendError(int sc) throws IOException {
        this.statusCode = sc;
        this.isSentError = true;
        super.sendError(sc);
    }

    public void sendError(int sc, String msg) throws IOException {
        this.statusCode = sc;
        this.statusMessage = msg;
        this.isSentError = true;
        super.sendError(sc, msg);
    }

    public boolean isSentError() {
        return this.isSentError;
    }

    public void sendRedirect(String location) throws IOException {
        this.redirectLocation = location;
        super.sendRedirect(location);
    }

    public String getRedirectLocation() {
        return this.redirectLocation;
    }

    private class ServletOutputStreamWrapper
    extends ServletOutputStream {
        private int length;
        private ServletOutputStream sos;
        private ByteArrayOutputStream baos = new ByteArrayOutputStream();

        public ServletOutputStreamWrapper(ServletOutputStream real) {
            this.sos = real;
        }

        public void write(int b) throws IOException {
            if (JournalHttpServletResponseWrapper.this.isBufferedOutput) {
                this.baos.write(b);
            } else {
                this.sos.write(b);
            }
            ++this.length;
        }

        public void write(byte[] b) throws IOException {
            if (JournalHttpServletResponseWrapper.this.isBufferedOutput) {
                this.baos.write(b);
            } else {
                this.sos.write(b);
            }
            this.length += b.length;
        }

        public void write(byte[] b, int off, int len) throws IOException {
            if (JournalHttpServletResponseWrapper.this.isBufferedOutput) {
                this.baos.write(b, off, len);
            } else {
                this.sos.write(b, off, len);
            }
            this.length += len;
        }

        public void print(String s) throws IOException {
            this.sos.print(s);
        }

        public void print(boolean b) throws IOException {
            this.sos.print(b);
        }

        public void print(char c) throws IOException {
            this.sos.print(c);
        }

        public void print(int i) throws IOException {
            this.sos.print(i);
        }

        public void print(long l) throws IOException {
            this.sos.print(l);
        }

        public void print(float f) throws IOException {
            this.sos.print(f);
        }

        public void print(double d) throws IOException {
            this.sos.print(d);
        }

        public void println() throws IOException {
            this.sos.println();
        }

        public void println(String s) throws IOException {
            this.sos.println(s);
        }

        public void println(boolean b) throws IOException {
            this.sos.println(b);
        }

        public void println(char c) throws IOException {
            this.sos.println(c);
        }

        public void println(int i) throws IOException {
            this.sos.println(i);
        }

        public void println(long l) throws IOException {
            this.sos.println(l);
        }

        public void println(float f) throws IOException {
            this.sos.println(f);
        }

        public void println(double d) throws IOException {
            this.sos.println(d);
        }

        public int getLength() {
            return this.length;
        }

        public void flushBuffer() throws IOException {
            if (JournalHttpServletResponseWrapper.this.isBufferedOutput) {
                this.baos.writeTo((OutputStream)this.sos);
                this.baos.reset();
            }
        }
    }

    private class PrintWriterWrapper
    extends PrintWriter {
        private PrintWriter pw;

        public PrintWriterWrapper(PrintWriter real) {
            super(JournalHttpServletResponseWrapper.this.dummyWriter);
            this.pw = real;
        }

        public void print(boolean b) {
            super.print(b);
            if (!JournalHttpServletResponseWrapper.this.isBufferedOutput) {
                this.pw.print(b);
            }
        }

        public void print(char c) {
            super.print(c);
            if (!JournalHttpServletResponseWrapper.this.isBufferedOutput) {
                this.pw.print(c);
            }
        }

        public void print(char[] s) {
            super.print(s);
            if (!JournalHttpServletResponseWrapper.this.isBufferedOutput) {
                this.pw.print(s);
            }
        }

        public void print(double d) {
            super.print(d);
            if (!JournalHttpServletResponseWrapper.this.isBufferedOutput) {
                this.pw.print(d);
            }
        }

        public void print(float f) {
            super.print(f);
            if (!JournalHttpServletResponseWrapper.this.isBufferedOutput) {
                this.pw.print(f);
            }
        }

        public void print(int i) {
            super.print(i);
            if (!JournalHttpServletResponseWrapper.this.isBufferedOutput) {
                this.pw.print(i);
            }
        }

        public void print(long l) {
            super.print(l);
            if (!JournalHttpServletResponseWrapper.this.isBufferedOutput) {
                this.pw.print(l);
            }
        }

        public void print(Object obj) {
            super.print(obj);
            if (!JournalHttpServletResponseWrapper.this.isBufferedOutput) {
                this.pw.print(obj);
            }
        }

        public void print(String s) {
            super.print(s);
            if (!JournalHttpServletResponseWrapper.this.isBufferedOutput) {
                this.pw.print(s);
            }
        }

        public void println() {
            super.println();
            if (!JournalHttpServletResponseWrapper.this.isBufferedOutput) {
                this.pw.println();
            }
        }

        public void println(boolean x) {
            super.println(x);
            if (!JournalHttpServletResponseWrapper.this.isBufferedOutput) {
                this.pw.println(x);
            }
        }

        public void println(char x) {
            super.println(x);
            if (!JournalHttpServletResponseWrapper.this.isBufferedOutput) {
                this.pw.println(x);
            }
        }

        public void println(char[] x) {
            super.println(x);
            if (!JournalHttpServletResponseWrapper.this.isBufferedOutput) {
                this.pw.println(x);
            }
        }

        public void println(double x) {
            super.println(x);
            if (!JournalHttpServletResponseWrapper.this.isBufferedOutput) {
                this.pw.println(x);
            }
        }

        public void println(float x) {
            super.println(x);
            if (!JournalHttpServletResponseWrapper.this.isBufferedOutput) {
                this.pw.println(x);
            }
        }

        public void println(int x) {
            super.println(x);
            if (!JournalHttpServletResponseWrapper.this.isBufferedOutput) {
                this.pw.println(x);
            }
        }

        public void println(long x) {
            super.println(x);
            if (!JournalHttpServletResponseWrapper.this.isBufferedOutput) {
                this.pw.println(x);
            }
        }

        public void println(Object x) {
            super.println(x);
            if (!JournalHttpServletResponseWrapper.this.isBufferedOutput) {
                this.pw.println(x);
            }
        }

        public void println(String x) {
            super.println(x);
            if (!JournalHttpServletResponseWrapper.this.isBufferedOutput) {
                this.pw.println(x);
            }
        }

        public void write(char[] buf) {
            super.write(buf);
            if (!JournalHttpServletResponseWrapper.this.isBufferedOutput) {
                this.pw.write(buf);
            }
        }

        public void write(char[] buf, int off, int len) {
            super.write(buf, off, len);
            if (!JournalHttpServletResponseWrapper.this.isBufferedOutput) {
                this.pw.write(buf, off, len);
            }
        }

        public void write(int c) {
            super.write(c);
            if (!JournalHttpServletResponseWrapper.this.isBufferedOutput) {
                this.pw.write(c);
            }
        }

        public void write(String s) {
            super.write(s);
            if (!JournalHttpServletResponseWrapper.this.isBufferedOutput) {
                this.pw.write(s);
            }
        }

        public void write(String s, int off, int len) {
            super.write(s, off, len);
            if (!JournalHttpServletResponseWrapper.this.isBufferedOutput) {
                this.pw.write(s, off, len);
            }
        }

        public String getContent() {
            return JournalHttpServletResponseWrapper.this.bufferWriter.toString();
        }

        public void flushBuffer() throws IOException {
            if (JournalHttpServletResponseWrapper.this.isBufferedOutput) {
                this.pw.print(this.getContent());
                JournalHttpServletResponseWrapper.this.bufferWriter = new StringWriter();
            }
        }
    }
}

