/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.journal.editor;

import java.io.Serializable;
import jp.ossc.nimbus.service.journal.JournalRecord;
import jp.ossc.nimbus.service.journal.RequestJournal;
import jp.ossc.nimbus.service.journal.editor.BlockJournalEditorServiceBase;
import jp.ossc.nimbus.service.journal.editor.SimpleRequestJournalEditorServiceMBean;
import jp.ossc.nimbus.service.journal.editorfinder.EditorFinder;

public class SimpleRequestJournalEditorService
extends BlockJournalEditorServiceBase
implements SimpleRequestJournalEditorServiceMBean,
Serializable {
    private static final String DEFAULT_JOURNAL_SEPARATOR = "******************************************************************";
    private static final String HEADER = "[JournalRequest]";
    private static final String REQUEST_ID_HEADER = "Request ID : ";
    private static final String START_TIME_HEADER = "Start Time : ";
    private static final String RECORDS_HEADER = "Journal Records : ";
    private static final String END_TIME_HEADER = "End Time : ";
    private static final String PERFORMANCE_HEADER = "Performance : ";
    private static final String PERFORMANCE_UNIT = " [msec]";
    private String separator = "******************************************************************";
    private boolean isOutputSeparator = true;
    private boolean isOutputRequestId = true;
    private boolean isOutputStartTime = true;
    private boolean isOutputRecords = true;
    private boolean isOutputEndTime = true;
    private boolean isOutputPerformance = true;
    private String[] outputRecordKeys;

    public SimpleRequestJournalEditorService() {
        this.setHeader(HEADER);
    }

    public void setSeparator(String separator) {
        this.separator = separator;
    }

    public String getSeparator() {
        return this.separator;
    }

    public void setOutputSeparator(boolean isOutput) {
        this.isOutputSeparator = isOutput;
    }

    public boolean isOutputSeparator() {
        return this.isOutputSeparator;
    }

    public void setOutputRequestId(boolean isOutput) {
        this.isOutputRequestId = isOutput;
    }

    public boolean isOutputRequestId() {
        return this.isOutputRequestId;
    }

    public void setOutputStartTime(boolean isOutput) {
        this.isOutputStartTime = isOutput;
    }

    public boolean isOutputStartTime() {
        return this.isOutputStartTime;
    }

    public void setOutputRecords(boolean isOutput) {
        this.isOutputRecords = isOutput;
    }

    public boolean isOutputRecords() {
        return this.isOutputRecords;
    }

    public void setOutputEndTime(boolean isOutput) {
        this.isOutputEndTime = isOutput;
    }

    public boolean isOutputEndTime() {
        return this.isOutputEndTime;
    }

    public void setOutputPerformance(boolean isOutput) {
        this.isOutputPerformance = isOutput;
    }

    public boolean isOutputPerformance() {
        return this.isOutputPerformance;
    }

    public void setOutputRecordKeys(String[] keys) {
        this.outputRecordKeys = keys;
    }

    public String[] getOutputRecordKeys() {
        return this.outputRecordKeys;
    }

    protected void startBlock(EditorFinder finder, Object key, Object value, StringBuffer buf) {
        RequestJournal request = (RequestJournal)value;
        if (this.isOutputSeparator() && request.isRoot()) {
            StringBuffer subBuf = new StringBuffer();
            this.makeSeparatorFormat(finder, key, request, subBuf);
            subBuf.append(this.getLineSeparator());
            buf.insert(0, subBuf.toString());
        }
        super.startBlock(finder, key, request, buf);
    }

    protected boolean processBlock(EditorFinder finder, Object key, Object value, StringBuffer buf) {
        RequestJournal request = (RequestJournal)value;
        boolean isMake = false;
        if (this.isOutputRequestId()) {
            this.makeRequestIdFormat(finder, key, request, buf);
            isMake = true;
        }
        if (this.isOutputStartTime()) {
            if (isMake) {
                buf.append(this.getLineSeparator());
            }
            this.makeStartTimeFormat(finder, key, request, buf);
            isMake = true;
        }
        if (this.isOutputRecords()) {
            if (isMake) {
                buf.append(this.getLineSeparator());
            }
            this.makeRecordsFormat(finder, key, request, buf);
            isMake = true;
        }
        if (this.isOutputEndTime()) {
            if (isMake) {
                buf.append(this.getLineSeparator());
            }
            this.makeEndTimeFormat(finder, key, request, buf);
            isMake = true;
        }
        if (this.isOutputPerformance()) {
            if (isMake) {
                buf.append(this.getLineSeparator());
            }
            this.makePerformanceFormat(finder, key, request, buf);
            isMake = true;
        }
        return isMake;
    }

    protected StringBuffer makeSeparatorFormat(EditorFinder finder, Object key, RequestJournal request, StringBuffer buf) {
        return buf.append(this.separator);
    }

    protected StringBuffer makeRequestIdFormat(EditorFinder finder, Object key, RequestJournal request, StringBuffer buf) {
        return buf.append(REQUEST_ID_HEADER).append(request.getRequestId());
    }

    protected StringBuffer makeStartTimeFormat(EditorFinder finder, Object key, RequestJournal request, StringBuffer buf) {
        buf.append(START_TIME_HEADER);
        return this.makeObjectFormat(finder, null, request.getStartTime(), buf);
    }

    protected StringBuffer makeRecordsFormat(EditorFinder finder, Object key, RequestJournal request, StringBuffer buf) {
        buf.append(RECORDS_HEADER);
        JournalRecord[] records = request.getParamAry();
        if (records.length == 0) {
            buf.append("null");
            return buf;
        }
        buf.append(this.getLineSeparator());
        StringBuffer subBuf = new StringBuffer();
        if (this.outputRecordKeys == null) {
            this.makeRecordsFormat(finder, records, subBuf);
        } else {
            int max = this.outputRecordKeys.length;
            for (int i = 0; i < max; ++i) {
                records = request.findParamArys(this.outputRecordKeys[i]);
                if (records == null || records.length == 0) continue;
                this.makeRecordsFormat(finder, records, subBuf);
                if (i == max - 1) continue;
                subBuf.append(this.getLineSeparator());
            }
        }
        this.addIndent(subBuf);
        return buf.append(subBuf);
    }

    protected StringBuffer makeRecordsFormat(EditorFinder finder, JournalRecord[] records, StringBuffer buf) {
        int max = records.length;
        for (int i = 0; i < max; ++i) {
            buf.append(records[i].toObject());
            if (i == max - 1) continue;
            buf.append(this.getLineSeparator());
        }
        return buf;
    }

    protected StringBuffer makeEndTimeFormat(EditorFinder finder, Object key, RequestJournal request, StringBuffer buf) {
        buf.append(END_TIME_HEADER);
        return this.makeObjectFormat(finder, null, request.getEndTime(), buf);
    }

    protected StringBuffer makePerformanceFormat(EditorFinder finder, Object key, RequestJournal request, StringBuffer buf) {
        return buf.append(PERFORMANCE_HEADER).append(request.getPerformance()).append(PERFORMANCE_UNIT);
    }
}

