/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.journal.editorfinder;

import java.util.Iterator;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jp.ossc.nimbus.beans.ServiceNameEditor;
import jp.ossc.nimbus.core.ServiceBase;
import jp.ossc.nimbus.core.ServiceManagerFactory;
import jp.ossc.nimbus.core.ServiceName;
import jp.ossc.nimbus.service.journal.JournalEditor;
import jp.ossc.nimbus.service.journal.editorfinder.EditorFinder;
import jp.ossc.nimbus.service.journal.editorfinder.RegexClassMappedEditorFinderServiceMBean;

public class RegexClassMappedEditorFinderService
extends ServiceBase
implements EditorFinder,
RegexClassMappedEditorFinderServiceMBean {
    private ServiceName parentEditorfinderServiceName;
    private EditorFinder parentEditorfinder;
    private SortedMap editorMapping;
    private Map editorRegexMapping;

    public void setParentEditorfinderServiceName(ServiceName name) {
        this.parentEditorfinderServiceName = name;
    }

    public ServiceName getParentEditorfinderServiceName() {
        return this.parentEditorfinderServiceName;
    }

    public void setEditorMapping(SortedMap map) {
        this.editorMapping = map;
    }

    public SortedMap getEditorMapping() {
        return this.editorMapping;
    }

    public void createService() throws Exception {
        this.editorRegexMapping = new TreeMap();
    }

    public void setEditorfinder(EditorFinder parentEditorfinder) {
        this.parentEditorfinder = parentEditorfinder;
    }

    public void startService() throws Exception {
        if (this.parentEditorfinderServiceName != null) {
            this.parentEditorfinder = (EditorFinder)ServiceManagerFactory.getServiceObject(this.parentEditorfinderServiceName);
        }
        if (this.editorMapping == null) {
            throw new IllegalArgumentException("editorMapping must be specified.");
        }
        ServiceNameEditor editor = new ServiceNameEditor();
        editor.setServiceManagerName(this.getServiceManagerName());
        Iterator keys = this.editorMapping.keySet().iterator();
        while (keys.hasNext()) {
            String key = (String)keys.next();
            JournalEditor journalEditor = null;
            Pattern pattern = Pattern.compile(key);
            Object value = this.editorMapping.get(key);
            if (value instanceof String) {
                String nameStr = (String)value;
                editor.setAsText(nameStr);
                ServiceName name = (ServiceName)editor.getValue();
                journalEditor = (JournalEditor)ServiceManagerFactory.getServiceObject(name);
            } else if (value instanceof JournalEditor) {
                journalEditor = (JournalEditor)value;
            }
            this.editorRegexMapping.put(pattern, journalEditor);
        }
    }

    public void stopService() throws Exception {
        this.editorRegexMapping.clear();
    }

    public void destroyService() throws Exception {
        this.editorRegexMapping = null;
    }

    public JournalEditor findEditor(Class clazz) {
        JournalEditor editor = this.findEditor(clazz.getName());
        if (editor == null) {
            Class<?>[] interfaces = clazz.getInterfaces();
            for (int i = 0; i < interfaces.length; ++i) {
                editor = this.findEditor(interfaces[i]);
                if (editor == null) continue;
                return editor;
            }
        }
        if (editor == null) {
            Class tmpClass = clazz;
            while ((tmpClass = tmpClass.getSuperclass()) != null) {
                editor = this.findEditor(tmpClass);
                if (editor == null) continue;
                return editor;
            }
        }
        if (editor == null && this.parentEditorfinder != null) {
            editor = this.parentEditorfinder.findEditor(clazz);
        }
        return editor;
    }

    private JournalEditor findEditor(String className) {
        Iterator patterns = this.editorRegexMapping.keySet().iterator();
        while (patterns.hasNext()) {
            Pattern pattern = (Pattern)patterns.next();
            Matcher matcher = pattern.matcher(className);
            if (!matcher.matches()) continue;
            return (JournalEditor)this.editorRegexMapping.get(pattern);
        }
        return null;
    }

    public JournalEditor findEditor(Object obj) {
        JournalEditor editor = null;
        if (this.parentEditorfinder != null) {
            editor = this.parentEditorfinder.findEditor(obj);
        }
        if (editor == null) {
            if (obj == null) {
                return null;
            }
            return this.findEditor(obj.getClass());
        }
        return editor;
    }
}

