/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.writer.db;

import java.io.Serializable;
import java.lang.reflect.Array;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Timer;
import java.util.TimerTask;
import jp.ossc.nimbus.core.ServiceBase;
import jp.ossc.nimbus.core.ServiceManagerFactory;
import jp.ossc.nimbus.core.ServiceName;
import jp.ossc.nimbus.service.connection.ConnectionFactory;
import jp.ossc.nimbus.service.connection.ConnectionFactoryException;
import jp.ossc.nimbus.service.log.Logger;
import jp.ossc.nimbus.service.writer.MessageWriteException;
import jp.ossc.nimbus.service.writer.WritableElement;
import jp.ossc.nimbus.service.writer.WritableRecord;
import jp.ossc.nimbus.service.writer.db.DatabaseWriterServiceMBean;

public class DatabaseWriterService
extends ServiceBase
implements DatabaseWriterServiceMBean,
Serializable {
    private static final String DBW__ = "DBW__";
    private static final String DBW__0 = "DBW__0";
    private static final String DBW__00 = "DBW__00";
    private static final String DBW__000 = "DBW__000";
    private static final String DBW__0000 = "DBW__0000";
    private static final String DBW__00001 = "DBW__00001";
    private static final String DBW__00002 = "DBW__00002";
    private Properties insertSQLs;
    private List insertSQLList;
    private int bufferSize;
    private List recordBuffer;
    private long bufferTimeout;
    private Timer bufferTimeoutTimer;
    private TimerTask bufferTimeoutTimerTask;
    private ServiceName connectionFactoryServiceName;
    private ConnectionFactory connectionFactory;

    public void setInsertSQL(Properties sqls) {
        this.insertSQLs = sqls;
    }

    public Properties getInsertSQL() {
        return this.insertSQLs;
    }

    public void setBufferSize(int size) {
        this.bufferSize = size;
    }

    public int getBufferSize() {
        return this.bufferSize;
    }

    public void setBufferTimeout(long timeout) {
        this.bufferTimeout = timeout;
    }

    public long getBufferTimeout() {
        return this.bufferTimeout;
    }

    public void setConnectionFactoryServiceName(ServiceName name) {
        this.connectionFactoryServiceName = name;
    }

    public ServiceName getConnectionFactoryServiceName() {
        return this.connectionFactoryServiceName;
    }

    public void setConnectionFactory(ConnectionFactory connectionFactory) {
        this.connectionFactory = connectionFactory;
    }

    public void createService() throws Exception {
        this.insertSQLList = new ArrayList();
        this.recordBuffer = new ArrayList();
    }

    public void startService() throws Exception {
        if (this.connectionFactory == null) {
            if (this.connectionFactoryServiceName == null) {
                throw new IllegalArgumentException("ConnectionFactoryServiceName is null");
            }
            this.connectionFactory = (ConnectionFactory)ServiceManagerFactory.getServiceObject(this.connectionFactoryServiceName);
        }
        if (this.insertSQLs == null) {
            throw new IllegalArgumentException("InsertSQL is null");
        }
        Iterator<Object> sqls = this.insertSQLs.keySet().iterator();
        while (sqls.hasNext()) {
            String sql = (String)sqls.next();
            this.insertSQLList.add(new InsertSQL(sql, this.insertSQLs.getProperty(sql)));
        }
        if (this.bufferTimeout > 0L && this.bufferSize > 0) {
            this.bufferTimeoutTimer = new Timer(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopService() throws Exception {
        if (this.bufferTimeoutTimer != null) {
            Timer timer = this.bufferTimeoutTimer;
            synchronized (timer) {
                this.bufferTimeoutTimer.cancel();
                this.bufferTimeoutTimer = null;
                this.bufferTimeoutTimerTask = null;
            }
        }
        if (this.bufferSize > 0 && this.recordBuffer.size() > 0) {
            this.writeBatch();
        }
        this.recordBuffer.clear();
        this.insertSQLList.clear();
        if (this.connectionFactoryServiceName == null) {
            this.connectionFactory = null;
        }
    }

    public void destroyService() throws Exception {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void write(WritableRecord rec) throws MessageWriteException {
        block33: {
            Object object;
            if (this.getState() != 3) {
                return;
            }
            final Logger logger = this.getLogger();
            if (this.bufferSize <= 0) {
                Connection conn;
                block32: {
                    conn = null;
                    conn = this.connectionFactory.getConnection();
                    Iterator insertSQLs = this.insertSQLList.iterator();
                    while (insertSQLs.hasNext()) {
                        InsertSQL sql = (InsertSQL)insertSQLs.next();
                        try {
                            sql.open(conn);
                            int index = 0;
                            int maxIndex = 1;
                            do {
                                maxIndex = this.setStatement(sql, rec, index);
                                sql.statement.executeUpdate();
                            } while (++index < maxIndex);
                        }
                        finally {
                            try {
                                sql.close();
                            }
                            catch (SQLException e) {}
                        }
                    }
                    if (conn.getAutoCommit()) break block32;
                    conn.commit();
                }
                Object var11_15 = null;
                if (conn == null) break block33;
                try {
                    conn.close();
                }
                catch (SQLException e) {
                    // empty catch block
                }
                conn = null;
                {
                    break block33;
                    catch (SQLException e) {
                        try {
                            if (!conn.getAutoCommit()) {
                                conn.rollback();
                            }
                        }
                        catch (SQLException ex) {
                            // empty catch block
                        }
                        logger.write(DBW__00001, e);
                        throw new MessageWriteException(e);
                    }
                    catch (ConnectionFactoryException e) {
                        logger.write(DBW__00002, e);
                        throw new MessageWriteException(e);
                    }
                }
                catch (Throwable throwable) {
                    Object var11_16 = null;
                    if (conn != null) {
                        try {
                            conn.close();
                        }
                        catch (SQLException e) {
                            // empty catch block
                        }
                        conn = null;
                    }
                    throw throwable;
                }
            }
            if (this.bufferTimeoutTimer != null && this.bufferTimeoutTimerTask == null) {
                object = this.bufferTimeoutTimer;
                synchronized (object) {
                    if (this.bufferTimeoutTimer != null && this.bufferTimeoutTimerTask == null) {
                        this.bufferTimeoutTimerTask = new TimerTask(){

                            public void run() {
                                try {
                                    DatabaseWriterService.this.writeBatch();
                                }
                                catch (MessageWriteException e) {
                                }
                                catch (Throwable e) {
                                    logger.write(DatabaseWriterService.DBW__00002, e);
                                }
                            }
                        };
                        this.bufferTimeoutTimer.schedule(this.bufferTimeoutTimerTask, this.bufferTimeout);
                    }
                }
            }
            object = this;
            synchronized (object) {
                this.recordBuffer.add(rec);
            }
            if (this.recordBuffer.size() >= this.bufferSize) {
                this.writeBatch();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    protected synchronized void writeBatch() throws MessageWriteException {
        Logger logger;
        block45: {
            Connection conn;
            block44: {
                logger = this.getLogger();
                if (this.bufferTimeoutTimer != null && this.bufferTimeoutTimerTask != null) {
                    Timer timer = this.bufferTimeoutTimer;
                    synchronized (timer) {
                        if (this.bufferTimeoutTimer != null && this.bufferTimeoutTimerTask != null) {
                            this.bufferTimeoutTimerTask.cancel();
                            this.bufferTimeoutTimerTask = null;
                        }
                    }
                }
                if (this.recordBuffer.size() == 0) {
                    return;
                }
                conn = null;
                conn = this.connectionFactory.getConnection();
                Iterator insertSQLs = this.insertSQLList.iterator();
                int maxSize = this.recordBuffer.size();
                if (maxSize > this.bufferSize) {
                    maxSize = this.bufferSize;
                }
                int totalCount = 0;
                while (insertSQLs.hasNext()) {
                    SQLException e4222;
                    Object var14_18;
                    InsertSQL sql = (InsertSQL)insertSQLs.next();
                    try {
                        sql.open(conn);
                        int i = 0;
                        for (i = 0; i < maxSize; ++i) {
                            int index = 0;
                            int maxIndex = 1;
                            WritableRecord rec = (WritableRecord)this.recordBuffer.get(i);
                            int count = 0;
                            try {
                                do {
                                    maxIndex = this.setStatement(sql, rec, index);
                                    sql.statement.addBatch();
                                    if (++count < this.bufferSize) continue;
                                    sql.statement.executeBatch();
                                    count = 0;
                                } while (++index < maxIndex);
                                continue;
                            }
                            catch (SQLException e22) {
                                this.recordBuffer.remove(i);
                                throw e22;
                            }
                        }
                        if (totalCount < i) {
                            totalCount = i;
                        }
                        try {
                            sql.statement.executeBatch();
                        }
                        catch (SQLException e3) {
                            for (int j = 0; j < totalCount; ++j) {
                                this.recordBuffer.remove(0);
                            }
                            throw e3;
                        }
                        var14_18 = null;
                    }
                    catch (Throwable throwable) {
                        var14_18 = null;
                        try {
                            sql.statement.clearBatch();
                        }
                        catch (SQLException e4222) {
                            // empty catch block
                        }
                        try {
                            sql.close();
                        }
                        catch (SQLException e4222) {
                            // empty catch block
                        }
                        throw throwable;
                    }
                    try {
                        sql.statement.clearBatch();
                    }
                    catch (SQLException e4222) {
                        // empty catch block
                    }
                    try {
                        sql.close();
                    }
                    catch (SQLException e4222) {}
                }
                for (int i = 0; i < totalCount; ++i) {
                    this.recordBuffer.remove(0);
                }
                if (conn.getAutoCommit()) break block44;
                conn.commit();
            }
            Object var17_22 = null;
            if (conn == null) break block45;
            try {
                conn.close();
            }
            catch (SQLException e) {
                // empty catch block
            }
            conn = null;
            {
                break block45;
                catch (SQLException e) {
                    try {
                        if (!conn.getAutoCommit()) {
                            conn.rollback();
                        }
                    }
                    catch (SQLException ex) {
                        // empty catch block
                    }
                    logger.write(DBW__00001, e);
                    throw new MessageWriteException(e);
                }
                catch (ConnectionFactoryException e) {
                    logger.write(DBW__00002, e);
                    throw new MessageWriteException(e);
                }
            }
            catch (Throwable throwable) {
                Object var17_23 = null;
                if (conn != null) {
                    try {
                        conn.close();
                    }
                    catch (SQLException e) {
                        // empty catch block
                    }
                    conn = null;
                }
                throw throwable;
            }
        }
        if (this.recordBuffer.size() >= this.bufferSize) {
            this.writeBatch();
        }
        if (this.bufferTimeoutTimer != null && this.bufferTimeoutTimerTask == null && this.recordBuffer.size() != 0) {
            Timer timer = this.bufferTimeoutTimer;
            synchronized (timer) {
                if (this.bufferTimeoutTimer != null && this.bufferTimeoutTimerTask == null) {
                    this.bufferTimeoutTimerTask = new TimerTask(){

                        public void run() {
                            try {
                                DatabaseWriterService.this.writeBatch();
                            }
                            catch (MessageWriteException e) {
                            }
                            catch (Throwable e) {
                                logger.write(DatabaseWriterService.DBW__00002, e);
                            }
                        }
                    };
                    this.bufferTimeoutTimer.schedule(this.bufferTimeoutTimerTask, this.bufferTimeout);
                }
            }
        }
    }

    private int setStatement(InsertSQL sql, WritableRecord rec, int index) throws SQLException {
        int maxIndex = 1;
        if (sql.keyList != null) {
            Map elementMap = rec.getElementMap();
            int max = sql.keyList.size();
            for (int i = 0; i < max; ++i) {
                WritableElement element = (WritableElement)elementMap.get(sql.keyList.get(i));
                Object val = null;
                if (element != null) {
                    val = element.toObject();
                }
                if (val != null) {
                    if (val instanceof List) {
                        List list = (List)val;
                        int size = list.size();
                        if (maxIndex < size) {
                            maxIndex = size;
                        }
                        val = index < size ? list.get(index) : null;
                    } else if (val.getClass().isArray()) {
                        int length = Array.getLength(val);
                        if (maxIndex < length) {
                            maxIndex = length;
                        }
                        val = index < length ? Array.get(val, index) : null;
                    }
                }
                sql.statement.setObject(i + 1, val);
            }
        }
        return maxIndex;
    }

    protected static class InsertSQL
    implements Serializable {
        PreparedStatement statement;
        List keyList;
        private String statementString;

        public InsertSQL(String stm, String keys) throws SQLException, IllegalArgumentException {
            this.statementString = stm;
            if (keys.length() == 0) {
                return;
            }
            this.keyList = new ArrayList();
            boolean isEscape = false;
            StringBuffer buf = new StringBuffer();
            int max = keys.length();
            block4: for (int i = 0; i < max; ++i) {
                char c = keys.charAt(i);
                switch (c) {
                    case '\\': {
                        if (isEscape) {
                            buf.append(c);
                            isEscape = false;
                            continue block4;
                        }
                        isEscape = true;
                        continue block4;
                    }
                    case ',': {
                        if (isEscape) {
                            buf.append(c);
                            isEscape = false;
                            continue block4;
                        }
                        this.keyList.add(buf.toString());
                        buf.setLength(0);
                        continue block4;
                    }
                    default: {
                        if (isEscape) {
                            throw new IllegalArgumentException("'\\' is escape character. : " + keys);
                        }
                        buf.append(c);
                    }
                }
            }
            if (isEscape) {
                throw new IllegalArgumentException("'\\' is escape character. : " + keys);
            }
            if (buf.length() != 0) {
                this.keyList.add(buf.toString());
                buf.setLength(0);
            }
        }

        public void open(Connection con) throws SQLException {
            this.statement = con.prepareStatement(this.statementString);
        }

        public void close() throws SQLException {
            this.statement.close();
            this.statement = null;
        }
    }
}

