/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.graph;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import jp.ossc.nimbus.service.graph.DatabaseDatasetFactoryService;
import jp.ossc.nimbus.service.graph.DatabaseOHLCDatasetFactoryServiceMBean;
import jp.ossc.nimbus.service.graph.DatasetCondition;
import jp.ossc.nimbus.service.graph.DatasetCreateException;
import org.jfree.data.general.Dataset;
import org.jfree.data.xy.DefaultOHLCDataset;
import org.jfree.data.xy.OHLCDataItem;

public class DatabaseOHLCDatasetFactoryService
extends DatabaseDatasetFactoryService
implements DatabaseOHLCDatasetFactoryServiceMBean {
    private String dateFormatPattern;
    private String dateColumnName;
    private String timeColumnName;
    private String openPriceColumnName;
    private String highPriceColumnName;
    private String lowPriceColumnName;
    private String closePriceColumnName;
    private String volumeColumnName;

    public void createService() throws Exception {
        super.createService();
    }

    public void startService() throws Exception {
        super.startService();
        if (this.dateFormatPattern != null) {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat(this.dateFormatPattern);
        }
        if (!this.isPermitNullColumnName()) {
            if (this.dateColumnName == null) {
                throw new IllegalArgumentException("date column name must be specified.");
            }
            if (this.openPriceColumnName == null) {
                throw new IllegalArgumentException("open price column name must be specified.");
            }
            if (this.highPriceColumnName == null) {
                throw new IllegalArgumentException("high price column name must be specified.");
            }
            if (this.lowPriceColumnName == null) {
                throw new IllegalArgumentException("low price column name must be specified.");
            }
            if (this.closePriceColumnName == null) {
                throw new IllegalArgumentException("close price column name must be specified.");
            }
            if (this.volumeColumnName == null) {
                throw new IllegalArgumentException("volume column name must be specified.");
            }
        }
    }

    public void stopService() throws Exception {
        super.stopService();
    }

    public void destroyService() throws Exception {
        super.destroyService();
    }

    public void setDateFormatPattern(String pattern) {
        this.dateFormatPattern = pattern;
    }

    public String getDateFormatPattern() {
        return this.dateFormatPattern;
    }

    public void setDateColumnName(String columnName) {
        this.dateColumnName = columnName;
    }

    public String getDateColumnName() {
        return this.dateColumnName;
    }

    public void setTimeColumnName(String columnName) {
        this.timeColumnName = columnName;
    }

    public String getTimeColumnName() {
        return this.timeColumnName;
    }

    public void setOpenPriceColumnName(String columnName) {
        this.openPriceColumnName = columnName;
    }

    public String getOpenPriceColumnName() {
        return this.openPriceColumnName;
    }

    public void setHighPriceColumnName(String columnName) {
        this.highPriceColumnName = columnName;
    }

    public String getHighPriceColumnName() {
        return this.highPriceColumnName;
    }

    public void setLowPriceColumnName(String columnName) {
        this.lowPriceColumnName = columnName;
    }

    public String getLowPriceColumnName() {
        return this.lowPriceColumnName;
    }

    public void setClosePriceColumnName(String columnName) {
        this.closePriceColumnName = columnName;
    }

    public String getClosePriceColumnName() {
        return this.closePriceColumnName;
    }

    public void setVolumeColumnName(String columnName) {
        this.volumeColumnName = columnName;
    }

    public String getVolumeColumnName() {
        return this.volumeColumnName;
    }

    protected Dataset createDataset(DatasetCondition[] dsConditions, String[] seriesArray, ResultSet[] rSets) throws DatasetCreateException {
        if (seriesArray == null || seriesArray.length == 0 || rSets == null || rSets.length == 0) {
            return null;
        }
        SimpleDateFormat dateFormat = null;
        if (this.dateFormatPattern != null) {
            dateFormat = new SimpleDateFormat(this.dateFormatPattern);
        }
        String series = seriesArray[0];
        ResultSet rs = rSets[0];
        ArrayList<OHLCDataItem> list = new ArrayList<OHLCDataItem>();
        try {
            while (rs.next()) {
                Date date = null;
                double openPrice = 0.0;
                double highPrice = 0.0;
                double lowPrice = 0.0;
                double closePrice = 0.0;
                double volume = 0.0;
                if (dateFormat != null) {
                    String dateStr = null;
                    if (this.dateColumnName != null) {
                        dateStr = rs.getString(this.dateColumnName);
                    }
                    if (this.timeColumnName != null) {
                        dateStr = dateStr != null ? dateStr + rs.getString(this.timeColumnName) : rs.getString(this.timeColumnName);
                    }
                    date = dateFormat.parse(dateStr);
                } else {
                    date = rs.getDate(this.dateColumnName);
                }
                if (date == null) {
                    throw new DatasetCreateException("date is null.");
                }
                if (this.openPriceColumnName != null) {
                    openPrice = this.getDoubleWithWasNullCheck(rs, this.openPriceColumnName);
                }
                if (this.highPriceColumnName != null) {
                    highPrice = this.getDoubleWithWasNullCheck(rs, this.highPriceColumnName);
                }
                if (this.lowPriceColumnName != null) {
                    lowPrice = this.getDoubleWithWasNullCheck(rs, this.lowPriceColumnName);
                }
                if (this.closePriceColumnName != null) {
                    closePrice = this.getDoubleWithWasNullCheck(rs, this.closePriceColumnName);
                }
                if (this.volumeColumnName != null) {
                    volume = this.getDoubleWithWasNullCheck(rs, this.volumeColumnName);
                }
                OHLCDataItem item = new OHLCDataItem(date, openPrice, highPrice, lowPrice, closePrice, volume);
                list.add(item);
            }
        }
        catch (SQLException e) {
            throw new DatasetCreateException(e);
        }
        catch (ParseException e) {
            throw new DatasetCreateException(e);
        }
        return new DefaultOHLCDataset((Comparable)((Object)series), list.toArray(new OHLCDataItem[list.size()]));
    }
}

