/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.soap;

import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import javax.xml.namespace.QName;
import javax.xml.rpc.Service;
import javax.xml.rpc.handler.HandlerInfo;
import jp.ossc.nimbus.core.ServiceBase;
import jp.ossc.nimbus.core.ServiceManagerFactory;
import jp.ossc.nimbus.core.ServiceName;
import jp.ossc.nimbus.service.soap.JaxRpcServiceFactory;
import jp.ossc.nimbus.service.soap.PortException;
import jp.ossc.nimbus.service.soap.PortFactoryServiceMBean;

public class PortFactoryService
extends ServiceBase
implements PortFactoryServiceMBean {
    private static final String SEPARATOR = ",";
    private static final int PORT_NAME = 0;
    private static final int ENDPOINT_INTERFACE_NAME = 1;
    private ServiceName jaxRpcServiceFactoryName;
    private String nameSpace;
    private Service jaxRpcService;
    private List handlerInfos;
    private Properties portAliasProp;

    public void createService() throws Exception {
        this.handlerInfos = new ArrayList();
    }

    public void startService() throws Exception {
        if (this.jaxRpcServiceFactoryName == null) {
            throw new IllegalArgumentException("jaxRpcServiceFactoryName must be specified.");
        }
        if (this.portAliasProp == null) {
            throw new IllegalArgumentException("portAliasProp must be specified.");
        }
        JaxRpcServiceFactory jaxRpcServiceFactory = (JaxRpcServiceFactory)ServiceManagerFactory.getServiceObject(this.jaxRpcServiceFactoryName);
        this.nameSpace = jaxRpcServiceFactory.getNameSpace();
        this.jaxRpcService = jaxRpcServiceFactory.getService();
    }

    public void stopService() throws Exception {
    }

    public void destroyService() throws Exception {
        this.nameSpace = null;
        this.jaxRpcService = null;
        this.handlerInfos = null;
    }

    public Object getPort(String portAlias) throws PortException {
        String portNameClassName = this.portAliasProp.getProperty(portAlias);
        String[] names = portNameClassName.split(SEPARATOR);
        if (names.length < 2) {
            return new PortException("port name or endpoint interface name is illegal : " + portNameClassName);
        }
        try {
            Class<?> endpointInterface = Class.forName(names[1]);
            QName portQN = new QName(this.nameSpace, names[0]);
            if (this.handlerInfos != null && this.handlerInfos.size() != 0) {
                this.jaxRpcService.getHandlerRegistry().setHandlerChain(portQN, this.handlerInfos);
            }
            return this.jaxRpcService.getPort(portQN, endpointInterface);
        }
        catch (Exception e) {
            throw new PortException(e);
        }
    }

    public void setHandlerInfos(List infos) {
        this.handlerInfos = infos;
    }

    public void addHandlerInfo(HandlerInfo info) {
        if (this.handlerInfos != null) {
            this.handlerInfos.add(info);
        }
    }

    public List getHandlerInfos() {
        return this.handlerInfos;
    }

    public void clearHandlerInfos() {
        if (this.handlerInfos != null) {
            this.handlerInfos.clear();
        }
    }

    public Properties getPortAliasProp() {
        return this.portAliasProp;
    }

    public void setPortAliasProp(Properties prop) {
        this.portAliasProp = prop;
    }

    public ServiceName getJaxRpcServiceFactoryName() {
        return this.jaxRpcServiceFactoryName;
    }

    public void setJaxRpcServiceFactoryName(ServiceName serviceName) {
        this.jaxRpcServiceFactoryName = serviceName;
    }
}

